/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;

public interface IGuiWrapper {
    default public void displayTooltip(ITextComponent component, int x, int y, int maxWidth) {
        this.displayTooltips(Collections.singletonList(component), x, y, maxWidth);
    }

    default public void displayTooltip(ITextComponent component, int x, int y) {
        this.displayTooltips(Collections.singletonList(component), x, y);
    }

    default public void displayTooltips(List<ITextComponent> components, int xAxis, int yAxis) {
        this.displayTooltips(components, xAxis, yAxis, -1);
    }

    default public void displayTooltips(List<ITextComponent> components, int xAxis, int yAxis, int maxWidth) {
        List toolTips = components.stream().map(ITextComponent::func_150254_d).collect(Collectors.toList());
        GuiUtils.drawHoveringText(toolTips, (int)xAxis, (int)yAxis, (int)this.getWidth(), (int)this.getHeight(), (int)maxWidth, (FontRenderer)this.getFont());
    }

    default public int getLeft() {
        if (this instanceof ContainerScreen) {
            return ((ContainerScreen)this).getGuiLeft();
        }
        return 0;
    }

    default public int getTop() {
        if (this instanceof ContainerScreen) {
            return ((ContainerScreen)this).getGuiTop();
        }
        return 0;
    }

    default public int getWidth() {
        if (this instanceof ContainerScreen) {
            return ((ContainerScreen)this).getXSize();
        }
        return 0;
    }

    default public int getHeight() {
        if (this instanceof ContainerScreen) {
            return ((ContainerScreen)this).getYSize();
        }
        return 0;
    }

    @Nullable
    public FontRenderer getFont();

    default public void renderItem(@Nonnull ItemStack stack, int xAxis, int yAxis) {
        this.renderItem(stack, xAxis, yAxis, 1.0f);
    }

    public void renderItem(@Nonnull ItemStack var1, int var2, int var3, float var4);
}

