/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.util.helpers;

import com.google.common.collect.Multiset;
import java.util.AbstractList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.StreamSupport;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Tuple;

public class NBTHelper {
    public static <T> ListNBT writeIterable(Iterable<T> iterable, Function<? super T, ? extends INBT> serializer) {
        return StreamSupport.stream(iterable.spliterator(), false).map(serializer).collect(NBTHelper.toListNBT());
    }

    public static <K, V> ListNBT serializeMap(Map<K, V> map, Function<? super K, ? extends INBT> keySerializer, Function<? super V, ? extends INBT> valueSerializer) {
        ListNBT list = new ListNBT();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            CompoundNBT compound = new CompoundNBT();
            compound.func_218657_a("key", keySerializer.apply(entry.getKey()));
            compound.func_218657_a("val", valueSerializer.apply(entry.getValue()));
            list.add((Object)compound);
        }
        return list;
    }

    public static <V> ListNBT serializeUUIDMap(Map<UUID, V> map, Function<? super V, ? extends INBT> valueSerializer) {
        ListNBT list = new ListNBT();
        for (Map.Entry<UUID, V> entry : map.entrySet()) {
            CompoundNBT compound = new CompoundNBT();
            compound.func_186854_a("key", entry.getKey());
            compound.func_218657_a("val", valueSerializer.apply(entry.getValue()));
            list.add((Object)compound);
        }
        return list;
    }

    public static <K, V> Map<K, V> deserializeMap(ListNBT list, Map<K, V> toAppendTo, Function<INBT, ? extends K> keyDeserializer, Function<INBT, ? extends V> valueDeserializer) {
        for (INBT nbt : list) {
            if (!(nbt instanceof CompoundNBT)) continue;
            CompoundNBT compound = (CompoundNBT)nbt;
            toAppendTo.put(keyDeserializer.apply(compound.func_74781_a("key")), valueDeserializer.apply(compound.func_74781_a("val")));
        }
        return toAppendTo;
    }

    public static <V> Map<UUID, V> deserializeUUIDMap(ListNBT list, Map<UUID, V> toAppendTo, Function<INBT, ? extends V> valueDeserializer) {
        for (INBT nbt : list) {
            if (!(nbt instanceof CompoundNBT)) continue;
            CompoundNBT compound = (CompoundNBT)nbt;
            toAppendTo.put(compound.func_186857_a("key"), valueDeserializer.apply(compound.func_74781_a("val")));
        }
        return toAppendTo;
    }

    public static <T, C extends Collection<T>> C deserializeCollection(ListNBT list, C toAppendTo, Function<INBT, ? extends T> elementDeserializer) {
        for (INBT nbt : list) {
            toAppendTo.add(elementDeserializer.apply(nbt));
        }
        return toAppendTo;
    }

    public static <T> Multiset<T> deserializeMultisetEntries(ListNBT list, Multiset<T> toAppendTo, Function<INBT, Tuple<? extends T, Integer>> entryDeserializer) {
        list.stream().map(entryDeserializer).forEach(p -> toAppendTo.add(p.func_76341_a(), ((Integer)p.func_76340_b()).intValue()));
        return toAppendTo;
    }

    public static <T extends INBT> Collector<T, ListNBT, ListNBT> toListNBT() {
        return new Collector<T, ListNBT, ListNBT>(){

            @Override
            public Supplier<ListNBT> supplier() {
                return ListNBT::new;
            }

            @Override
            public BiConsumer<ListNBT, T> accumulator() {
                return AbstractList::add;
            }

            @Override
            public BinaryOperator<ListNBT> combiner() {
                return (l1, l2) -> {
                    l1.addAll((Collection)l2);
                    return l1;
                };
            }

            @Override
            public Function<ListNBT, ListNBT> finisher() {
                return Function.identity();
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return EnumSet.of(Collector.Characteristics.IDENTITY_FINISH, Collector.Characteristics.UNORDERED);
            }
        };
    }
}

