/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.renderer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Floats;
import com.mojang.blaze3d.vertex.DefaultColorVertexBuilder;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.blaze3d.vertex.IVertexConsumer;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.IntArrays;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.BitSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DireBufferBuilder
extends DefaultColorVertexBuilder
implements IVertexConsumer {
    private static final Logger LOGGER = LogManager.getLogger();
    private ByteBuffer byteBuffer;
    private final List<DrawState> drawStates = Lists.newArrayList();
    private int drawStateIndex = 0;
    private int renderedBytes = 0;
    private int nextElementBytes = 0;
    private int uploadedBytes = 0;
    private int vertexCount;
    @Nullable
    private VertexFormatElement vertexFormatElement;
    private int vertexFormatIndex;
    private int drawMode;
    private VertexFormat vertexFormat;
    private boolean fastFormat;
    private boolean fullFormat;
    private boolean isDrawing;

    public DireBufferBuilder(int bufferSizeIn) {
        this.byteBuffer = GLAllocation.func_74524_c((int)(bufferSizeIn * 4));
    }

    protected void growBuffer() {
        this.growBuffer(this.vertexFormat.func_177338_f());
    }

    private void growBuffer(int increaseAmount) {
        if (this.nextElementBytes + increaseAmount > this.byteBuffer.capacity()) {
            int i = this.byteBuffer.capacity();
            int j = i + DireBufferBuilder.roundUpPositive(increaseAmount);
            LOGGER.debug("Needed to grow BufferBuilder buffer: Old size {} bytes, new size {} bytes.", (Object)i, (Object)j);
            ByteBuffer bytebuffer = GLAllocation.func_74524_c((int)j);
            this.byteBuffer.position(0);
            bytebuffer.put(this.byteBuffer);
            bytebuffer.rewind();
            this.byteBuffer = bytebuffer;
        }
    }

    private static int roundUpPositive(int xIn) {
        int j;
        int i = 0x200000;
        if (xIn == 0) {
            return i;
        }
        if (xIn < 0) {
            i *= -1;
        }
        return (j = xIn % i) == 0 ? xIn : xIn + i - j;
    }

    public void sortVertexData(float cameraX, float cameraY, float cameraZ) {
        this.byteBuffer.clear();
        FloatBuffer floatbuffer = this.byteBuffer.asFloatBuffer();
        int i = this.vertexCount / 4;
        float[] afloat = new float[i];
        for (int j = 0; j < i; ++j) {
            afloat[j] = DireBufferBuilder.getDistanceSq(floatbuffer, cameraX, cameraY, cameraZ, this.vertexFormat.func_181719_f(), this.renderedBytes / 4 + j * this.vertexFormat.func_177338_f());
        }
        int[] aint = new int[i];
        int k = 0;
        while (k < aint.length) {
            aint[k] = k++;
        }
        IntArrays.mergeSort((int[])aint, (p_227830_1_, p_227830_2_) -> Floats.compare((float)afloat[p_227830_1_], (float)afloat[p_227830_2_]));
        BitSet bitset = new BitSet();
        FloatBuffer floatbuffer1 = GLAllocation.func_74529_h((int)(this.vertexFormat.func_181719_f() * 4));
        int l = bitset.nextClearBit(0);
        while (l < aint.length) {
            int i1 = aint[l];
            if (i1 != l) {
                this.limitToVertex(floatbuffer, i1);
                floatbuffer1.clear();
                floatbuffer1.put(floatbuffer);
                int j1 = i1;
                int k1 = aint[i1];
                while (j1 != l) {
                    this.limitToVertex(floatbuffer, k1);
                    FloatBuffer floatbuffer2 = floatbuffer.slice();
                    this.limitToVertex(floatbuffer, j1);
                    floatbuffer.put(floatbuffer2);
                    bitset.set(j1);
                    j1 = k1;
                    k1 = aint[k1];
                }
                this.limitToVertex(floatbuffer, l);
                floatbuffer1.flip();
                floatbuffer.put(floatbuffer1);
            }
            bitset.set(l);
            l = bitset.nextClearBit(l + 1);
        }
    }

    private void limitToVertex(FloatBuffer floatBufferIn, int indexIn) {
        int i = this.vertexFormat.func_181719_f() * 4;
        floatBufferIn.limit(this.renderedBytes / 4 + (indexIn + 1) * i);
        floatBufferIn.position(this.renderedBytes / 4 + indexIn * i);
    }

    public State getVertexState() {
        this.byteBuffer.limit(this.nextElementBytes);
        this.byteBuffer.position(this.renderedBytes);
        ByteBuffer bytebuffer = ByteBuffer.allocate(this.vertexCount * this.vertexFormat.func_177338_f());
        bytebuffer.put(this.byteBuffer);
        this.byteBuffer.clear();
        return new State(bytebuffer, this.vertexFormat);
    }

    private static float getDistanceSq(FloatBuffer floatBufferIn, float x, float y, float z, int integerSize, int offset) {
        float f = floatBufferIn.get(offset + integerSize * 0 + 0);
        float f1 = floatBufferIn.get(offset + integerSize * 0 + 1);
        float f2 = floatBufferIn.get(offset + integerSize * 0 + 2);
        float f3 = floatBufferIn.get(offset + integerSize * 1 + 0);
        float f4 = floatBufferIn.get(offset + integerSize * 1 + 1);
        float f5 = floatBufferIn.get(offset + integerSize * 1 + 2);
        float f6 = floatBufferIn.get(offset + integerSize * 2 + 0);
        float f7 = floatBufferIn.get(offset + integerSize * 2 + 1);
        float f8 = floatBufferIn.get(offset + integerSize * 2 + 2);
        float f9 = floatBufferIn.get(offset + integerSize * 3 + 0);
        float f10 = floatBufferIn.get(offset + integerSize * 3 + 1);
        float f11 = floatBufferIn.get(offset + integerSize * 3 + 2);
        float f12 = (f + f3 + f6 + f9) * 0.25f - x;
        float f13 = (f1 + f4 + f7 + f10) * 0.25f - y;
        float f14 = (f2 + f5 + f8 + f11) * 0.25f - z;
        return f12 * f12 + f13 * f13 + f14 * f14;
    }

    public void setVertexState(State state) {
        state.stateByteBuffer.clear();
        int i = state.stateByteBuffer.capacity();
        this.growBuffer(i);
        this.byteBuffer.limit(this.byteBuffer.capacity());
        this.byteBuffer.position(this.renderedBytes);
        this.byteBuffer.put(state.stateByteBuffer);
        this.byteBuffer.clear();
        VertexFormat vertexformat = state.stateVertexFormat;
        this.setVertexFormat(vertexformat);
        this.vertexCount = i / vertexformat.func_177338_f();
        this.nextElementBytes = this.renderedBytes + this.vertexCount * vertexformat.func_177338_f();
    }

    public void begin(int glMode, VertexFormat format) {
        if (this.isDrawing) {
            throw new IllegalStateException("Already building!");
        }
        this.isDrawing = true;
        this.drawMode = glMode;
        this.setVertexFormat(format);
        this.vertexFormatElement = (VertexFormatElement)format.func_227894_c_().get(0);
        this.vertexFormatIndex = 0;
        this.byteBuffer.clear();
    }

    private void setVertexFormat(VertexFormat vertexFormatIn) {
        if (this.vertexFormat != vertexFormatIn) {
            this.vertexFormat = vertexFormatIn;
            boolean flag = vertexFormatIn == DefaultVertexFormats.field_227849_i_;
            boolean flag1 = vertexFormatIn == DefaultVertexFormats.field_176600_a;
            this.fastFormat = flag || flag1;
            this.fullFormat = flag;
        }
    }

    public void finishDrawing() {
        if (!this.isDrawing) {
            throw new IllegalStateException("Not building!");
        }
        this.isDrawing = false;
        this.drawStates.add(new DrawState(this.vertexFormat, this.vertexCount, this.drawMode));
        this.renderedBytes += this.vertexCount * this.vertexFormat.func_177338_f();
        this.vertexCount = 0;
        this.vertexFormatElement = null;
        this.vertexFormatIndex = 0;
    }

    public void func_225589_a_(int indexIn, byte byteIn) {
        this.byteBuffer.put(this.nextElementBytes + indexIn, byteIn);
    }

    public void func_225591_a_(int indexIn, short shortIn) {
        this.byteBuffer.putShort(this.nextElementBytes + indexIn, shortIn);
    }

    public void func_225590_a_(int indexIn, float floatIn) {
        this.byteBuffer.putFloat(this.nextElementBytes + indexIn, floatIn);
    }

    public void func_181675_d() {
        if (this.vertexFormatIndex != 0) {
            throw new IllegalStateException("Not filled all elements of the vertex");
        }
        ++this.vertexCount;
        this.growBuffer();
    }

    public void func_181667_k() {
        VertexFormatElement vertexformatelement;
        ImmutableList immutablelist = this.vertexFormat.func_227894_c_();
        this.vertexFormatIndex = (this.vertexFormatIndex + 1) % immutablelist.size();
        this.nextElementBytes += this.vertexFormatElement.func_177368_f();
        this.vertexFormatElement = vertexformatelement = (VertexFormatElement)immutablelist.get(this.vertexFormatIndex);
        if (vertexformatelement.func_177375_c() == VertexFormatElement.Usage.PADDING) {
            this.func_181667_k();
        }
        if (this.field_227854_a_ && this.vertexFormatElement.func_177375_c() == VertexFormatElement.Usage.COLOR) {
            super.func_225586_a_(this.field_227855_b_, this.field_227856_c_, this.field_227857_d_, this.field_227858_e_);
        }
    }

    public IVertexBuilder func_225586_a_(int red, int green, int blue, int alpha) {
        if (this.field_227854_a_) {
            throw new IllegalStateException();
        }
        return super.func_225586_a_(red, green, blue, alpha);
    }

    public void func_225588_a_(float x, float y, float z, float red, float green, float blue, float alpha, float texU, float texV, int overlayUV, int lightmapUV, float normalX, float normalY, float normalZ) {
        if (this.field_227854_a_) {
            throw new IllegalStateException();
        }
        if (this.fastFormat) {
            int i;
            this.func_225590_a_(0, x);
            this.func_225590_a_(4, y);
            this.func_225590_a_(8, z);
            this.func_225589_a_(12, (byte)(red * 255.0f));
            this.func_225589_a_(13, (byte)(green * 255.0f));
            this.func_225589_a_(14, (byte)(blue * 255.0f));
            this.func_225589_a_(15, (byte)(alpha * 255.0f));
            this.func_225590_a_(16, texU);
            this.func_225590_a_(20, texV);
            if (this.fullFormat) {
                this.func_225591_a_(24, (short)(overlayUV & 0xFFFF));
                this.func_225591_a_(26, (short)(overlayUV >> 16 & 0xFFFF));
                i = 28;
            } else {
                i = 24;
            }
            this.func_225591_a_(i + 0, (short)(lightmapUV & 0xFFFF));
            this.func_225591_a_(i + 2, (short)(lightmapUV >> 16 & 0xFFFF));
            this.func_225589_a_(i + 4, IVertexConsumer.func_227846_a_((float)normalX));
            this.func_225589_a_(i + 5, IVertexConsumer.func_227846_a_((float)normalY));
            this.func_225589_a_(i + 6, IVertexConsumer.func_227846_a_((float)normalZ));
            this.nextElementBytes += i + 8;
            this.func_181675_d();
        } else {
            super.func_225588_a_(x, y, z, red, green, blue, alpha, texU, texV, overlayUV, lightmapUV, normalX, normalY, normalZ);
        }
    }

    public Pair<DrawState, ByteBuffer> getNextBuffer() {
        DrawState bufferbuilder$drawstate = this.drawStates.get(this.drawStateIndex++);
        this.byteBuffer.position(this.uploadedBytes);
        this.uploadedBytes += bufferbuilder$drawstate.getVertexCount() * bufferbuilder$drawstate.getFormat().func_177338_f();
        this.byteBuffer.limit(this.uploadedBytes);
        if (this.drawStateIndex == this.drawStates.size() && this.vertexCount == 0) {
            this.reset();
        }
        ByteBuffer bytebuffer = this.byteBuffer.slice();
        this.byteBuffer.clear();
        return Pair.of((Object)bufferbuilder$drawstate, (Object)bytebuffer);
    }

    public void reset() {
        if (this.renderedBytes != this.uploadedBytes) {
            LOGGER.warn("Bytes mismatch " + this.renderedBytes + " " + this.uploadedBytes);
        }
        this.discard();
    }

    public void discard() {
        this.renderedBytes = 0;
        this.uploadedBytes = 0;
        this.nextElementBytes = 0;
        this.drawStates.clear();
        this.drawStateIndex = 0;
    }

    public VertexFormatElement func_225592_i_() {
        if (this.vertexFormatElement == null) {
            throw new IllegalStateException("BufferBuilder not started");
        }
        return this.vertexFormatElement;
    }

    public boolean isDrawing() {
        return this.isDrawing;
    }

    public void putBulkData(ByteBuffer buffer) {
        this.growBuffer(buffer.limit() + this.vertexFormat.func_177338_f());
        this.byteBuffer.position(this.vertexCount * this.vertexFormat.func_177338_f());
        this.byteBuffer.put(buffer);
        this.vertexCount += buffer.limit() / this.vertexFormat.func_177338_f();
    }

    public VertexFormat getVertexFormat() {
        return this.vertexFormat;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class State {
        private final ByteBuffer stateByteBuffer;
        private final VertexFormat stateVertexFormat;

        private State(ByteBuffer byteBufferIn, VertexFormat vertexFormatIn) {
            this.stateByteBuffer = byteBufferIn;
            this.stateVertexFormat = vertexFormatIn;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class DrawState {
        private final VertexFormat format;
        private final int vertexCount;
        private final int drawMode;

        private DrawState(VertexFormat formatIn, int vertexCountIn, int drawModeIn) {
            this.format = formatIn;
            this.vertexCount = vertexCountIn;
            this.drawMode = drawModeIn;
        }

        public VertexFormat getFormat() {
            return this.format;
        }

        public int getVertexCount() {
            return this.vertexCount;
        }

        public int getDrawMode() {
            return this.drawMode;
        }
    }
}

