/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.supermultidrills.crafting.recipe;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.lib.collection.StackList;
import net.silentchaos512.lib.crafting.recipe.ExtendedShapelessRecipe;
import net.silentchaos512.supermultidrills.SuperMultiDrills;
import net.silentchaos512.supermultidrills.init.ModItems;
import net.silentchaos512.supermultidrills.item.DrillHeadItem;
import net.silentchaos512.supermultidrills.item.DrillItem;

public class DrillRecipe
extends ExtendedShapelessRecipe {
    public static final ResourceLocation NAME = SuperMultiDrills.getId("drill_crafting");
    public static final ExtendedShapelessRecipe.Serializer<DrillRecipe> SERIALIZER = ExtendedShapelessRecipe.Serializer.basic(DrillRecipe::new);

    private DrillRecipe(ShapelessRecipe recipe) {
        super(recipe);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public boolean func_77569_a(CraftingInventory inv, World worldIn) {
        return this.getBaseRecipe().func_77569_a(inv, worldIn) && DrillRecipe.getParts((IInventory)inv).stream().allMatch(part -> part.getPart().isCraftingAllowed(DrillItem.GEAR_TYPE));
    }

    public ItemStack func_77572_b(CraftingInventory inv) {
        return ModItems.drill.construct(DrillRecipe.getParts((IInventory)inv));
    }

    private static Collection<PartData> getParts(IInventory inv) {
        return StackList.from((IInventory)inv).stream().flatMap(stack -> {
            if (stack.func_77973_b() instanceof DrillHeadItem) {
                return GearData.getConstructionParts((ItemStack)stack).stream();
            }
            return Stream.of(PartData.from((ItemStack)stack));
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

