/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.tubesreloaded.common.routing;

import com.github.commoble.tubesreloaded.common.routing.Endpoint;
import java.util.LinkedList;
import java.util.Queue;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Route
implements Comparable<Route> {
    public Queue<Direction> sequenceOfMoves;
    public Endpoint destination;
    public int length;

    public Route(Endpoint destination, int length, Queue<Direction> sequenceOfMoves) {
        this.destination = destination;
        this.length = length;
        this.sequenceOfMoves = sequenceOfMoves;
    }

    public boolean isRouteDestinationValid(World world, BlockPos startPos, Direction insertionSide, ItemStack stack) {
        if (this.destination.pos.equals((Object)startPos.func_177972_a(insertionSide)) && this.destination.face.func_176734_d().equals((Object)insertionSide)) {
            return false;
        }
        return this.destination.canInsertItem(world, stack);
    }

    @Override
    public int compareTo(Route other) {
        if (this.length != other.length) {
            return this.length - other.length;
        }
        BlockPos thisEnd = this.destination.pos;
        BlockPos otherEnd = other.destination.pos;
        if (thisEnd.func_177956_o() != otherEnd.func_177956_o()) {
            return thisEnd.func_177956_o() - otherEnd.func_177956_o();
        }
        if (thisEnd.func_177952_p() != otherEnd.func_177952_p()) {
            return thisEnd.func_177952_p() - otherEnd.func_177952_p();
        }
        return thisEnd.func_177958_n() - otherEnd.func_177958_n();
    }

    public String toStringFrom(BlockPos startPos) {
        LinkedList<String> moveStrings = new LinkedList<String>();
        moveStrings.add(startPos.toString());
        for (Direction face : this.sequenceOfMoves) {
            if (face == null) {
                moveStrings.add("null");
                continue;
            }
            moveStrings.add(face.toString());
        }
        return String.join((CharSequence)", ", moveStrings);
    }
}

