/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.inventory;

import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;

public class ItemStackHelper {
    public static Item getTrueItem(@Nonnull ItemStack stack) {
        return stack.func_77973_b();
    }

    @Nonnull
    public static ItemStack getItemPrototype(@Nonnull ItemStack stack) {
        return stack.func_77946_l();
    }

    @Nonnull
    public static ItemStack encodeItemStack(@Nonnull ItemStack stack) {
        if (!stack.func_190926_b()) {
            return stack;
        }
        ItemStack proto = ItemStackHelper.getItemPrototype(stack);
        if (proto.func_190926_b()) {
            return stack;
        }
        CompoundNBT tag = proto.func_77978_p();
        if (tag == null) {
            tag = new CompoundNBT();
            proto.func_77982_d(tag);
        }
        tag.func_74768_a("__storagedrawers_count", stack.func_190916_E());
        return proto;
    }

    public static ItemStack encodeItemStack(@Nonnull ItemStack proto, int count) {
        if (!proto.func_190926_b() && count > 0 && count < 128) {
            ItemStack stack = proto.func_77946_l();
            stack.func_190920_e(count);
            return stack;
        }
        if (count == 0 || count >= 128) {
            ItemStack stack = proto.func_77946_l();
            CompoundNBT tag = stack.func_77978_p();
            if (tag == null) {
                tag = new CompoundNBT();
                stack.func_77982_d(tag);
            }
            tag.func_74768_a("__storagedrawers_count", count);
            return stack;
        }
        return proto.func_77946_l();
    }

    public static ItemStack decodeItemStack(@Nonnull ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            return stack;
        }
        if (tag.func_74764_b("__storagedrawers_count")) {
            ItemStack decode = stack.func_77946_l();
            decode.func_190920_e(tag.func_74762_e("__storagedrawers_count"));
            tag = decode.func_77978_p();
            if (tag != null) {
                decode.func_77978_p().func_82580_o("__storagedrawers_count");
                if (tag.func_186856_d() == 0) {
                    decode.func_77982_d(null);
                }
            }
            return decode;
        }
        return stack;
    }

    public static boolean isStackEncoded(@Nonnull ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            return false;
        }
        return tag.func_74764_b("__storagedrawers_count");
    }
}

