/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.pulsar.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.pulsar.config.IConfiguration;
import slimeknights.mantle.pulsar.control.PulseManager;
import slimeknights.mantle.pulsar.pulse.PulseMeta;

public class PulsarConfig
implements IConfiguration {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private ForgeConfigSpec SPEC = this.BUILDER.build();
    private final CommentedFileConfig config;
    private final String description;
    private boolean configBuilt;
    private final Map<String, ForgeConfigSpec.BooleanValue> modules = new LinkedHashMap<String, ForgeConfigSpec.BooleanValue>();

    public PulsarConfig(String confName, String description) {
        this.config = this.createConfig(FMLPaths.CONFIGDIR.get(), confName);
        this.description = description.toLowerCase(Locale.US);
        this.configBuilt = false;
        this.BUILDER.push(this.description);
    }

    @Override
    public void load() {
    }

    @Override
    public void postLoad() {
        if (!this.configBuilt) {
            this.BUILDER.pop();
            this.SPEC = this.BUILDER.build();
            this.SPEC.setConfig((CommentedConfig)this.config);
        }
        this.configBuilt = true;
    }

    @Override
    public boolean isModuleEnabled(@Nonnull PulseMeta meta) {
        ForgeConfigSpec.BooleanValue entry = this.modules.get(meta.getId());
        if (entry == null) {
            this.modules.put(meta.getId(), this.BUILDER.comment(meta.getDescription()).worldRestart().define(meta.getId(), meta.isDefaultEnabled()));
            return meta.isEnabled();
        }
        return (Boolean)entry.get();
    }

    @Override
    public void addPulse(@Nonnull PulseMeta meta) {
        ForgeConfigSpec.BooleanValue entry = this.modules.get(meta.getId());
        if (entry == null) {
            this.modules.put(meta.getId(), this.BUILDER.comment(meta.getDescription()).worldRestart().define(meta.getId(), meta.isDefaultEnabled()));
        }
    }

    @Override
    public void flush() {
        this.config.save();
    }

    public CommentedFileConfig createConfig(Path configBasePath, String configName) {
        Path configPath = configBasePath.resolve(String.format("%s.toml", configName));
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)configPath).sync().autosave().writingMode(WritingMode.REPLACE).build();
        LOGGER.debug(PulseManager.PULSAR, "Built TOML config for {}", (Object)configPath.toString());
        configData.load();
        LOGGER.debug(PulseManager.PULSAR, "Loaded TOML config file {}", (Object)configPath.toString());
        return configData;
    }
}

