/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.config;

import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import slimeknights.mantle.config.AbstractConfig;
import slimeknights.mantle.config.AbstractConfigFile;
import slimeknights.mantle.config.AbstractConfigSyncPacket;
import slimeknights.mantle.network.NetworkWrapper;

class ExampleSync {
    static NetworkWrapper networkWrapper;
    static ExampleSync INSTANCE;
    @OnlyIn(value=Dist.CLIENT)
    private static boolean needsRestart;

    ExampleSync() {
    }

    static void setup() {
        networkWrapper = new NetworkWrapper("mantle:example");
        networkWrapper.registerPacket(ExampleSyncPacketImpl.class, AbstractConfigSyncPacket::encode, ExampleSyncPacketImpl::new, AbstractConfigSyncPacket::handle);
        INSTANCE = new ExampleSync();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.DEDICATED_SERVER)
    public void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity && FMLEnvironment.dist.isDedicatedServer()) {
            ExampleSyncPacketImpl packet = new ExampleSyncPacketImpl();
            networkWrapper.sendTo(packet, (ServerPlayerEntity)event.getPlayer());
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void playerJoinedWorld(TickEvent.ClientTickEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (needsRestart) {
            player.func_145747_a((ITextComponent)new StringTextComponent("Configs synced with server. Configs require a restart"));
        } else {
            player.func_145747_a((ITextComponent)new StringTextComponent("Configs synced with server."));
        }
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    static class ExampleSyncPacketImpl
    extends AbstractConfigSyncPacket {
        public ExampleSyncPacketImpl(PacketBuffer buffer) {
            super(buffer);
        }

        public ExampleSyncPacketImpl() {
        }

        @Override
        protected AbstractConfig getConfig() {
            return ExampleConfig.INSTANCE;
        }

        @Override
        protected boolean sync() {
            if (super.sync()) {
                MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
                return true;
            }
            return false;
        }
    }

    static class ExampleConfigFile
    extends AbstractConfigFile {
        public ExampleConfigFile(File configFolder) {
            super(configFolder, "exampleconfigfile");
        }

        @Override
        public void insertDefaults() {
        }

        @Override
        protected int getConfigVersion() {
            return 1;
        }
    }

    static class ExampleConfig
    extends AbstractConfig {
        static ExampleConfig INSTANCE = new ExampleConfig();
        ExampleConfigFile exampleConfigFile;

        ExampleConfig() {
        }

        public void onPreInit(FMLCommonSetupEvent event) {
            this.exampleConfigFile = this.load(new ExampleConfigFile(FMLPaths.CONFIGDIR.get().toFile()), ExampleConfigFile.class);
            if (FMLEnvironment.dist.isDedicatedServer()) {
                MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
            }
        }
    }
}

