/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.simplechunkloaders.m_limited;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.valkyrieofnight.simplechunkloaders.SimpleChunkLoaders;
import com.valkyrieofnight.simplechunkloaders.m_limited.LimitedChunkLoaderContainer;
import com.valkyrieofnight.simplechunkloaders.m_limited.SCLLimited;
import com.valkyrieofnight.vlib.core.io.nbt.INBTSerializer;
import com.valkyrieofnight.vlib.core.obj.tileentity.VLTileEntity;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.SaveDataType;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.TickTracker;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class LimitedChunkLoaderTile
extends VLTileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    protected TickTracker tracker = TickTracker.Builder.create().setCanProcessStartProvider(this::canStartProcess).setGetProcessDurationProvider(this::getDuration).setOnProcessStartAction(this::processStart).setOnProcessCompleteAction(this::processComplete).build();
    protected Inv handler = new Inv(1);
    public static Map<ItemStack, Integer> FUELS = Maps.newLinkedHashMap();
    private boolean onPlace = false;

    public LimitedChunkLoaderTile() {
        super(SCLLimited.LOADER_TILE_TYPE);
    }

    public ItemStack insertFuel(ItemStack newFuel) {
        if (this.canConsumeFuel(newFuel)) {
            return this.handler.addItem(newFuel);
        }
        return newFuel;
    }

    public Inv getHandler() {
        return this.handler;
    }

    public boolean canConsumeFuel(ItemStack fuel) {
        for (ItemStack st : FUELS.keySet()) {
            if (!st.func_77969_a(fuel)) continue;
            return true;
        }
        return false;
    }

    public void onReplaced() {
        SimpleChunkLoaders.LOADER.getByDimension(this.func_145831_w().func_201675_m().func_186058_p()).unLoad(this.field_174879_c);
    }

    public void onPlaced() {
        this.onPlace = true;
    }

    protected boolean canStartProcess() {
        boolean startable = this.canConsumeFuel(this.handler.func_70301_a(0));
        if (!startable) {
            SimpleChunkLoaders.LOADER.getByDimension(this.func_145831_w().func_201675_m().func_186058_p()).unLoad(this.field_174879_c);
        } else {
            SimpleChunkLoaders.LOADER.getByDimension(this.func_145831_w().func_201675_m().func_186058_p()).load(this.field_174879_c);
        }
        return startable;
    }

    protected int getDuration() {
        ItemStack inv = this.handler.func_70301_a(0);
        for (ItemStack st : FUELS.keySet()) {
            if (!st.func_77969_a(inv)) continue;
            return FUELS.get(st);
        }
        return 0;
    }

    protected void processStart() {
        if (!this.tracker.hasStarted()) {
            this.handler.func_70298_a(0, 1);
        }
    }

    protected void processComplete() {
    }

    public void func_73660_a() {
        if (this.field_145850_b.func_201670_d()) {
            return;
        }
        this.markForUpdate();
        if (this.onPlace) {
            if (this.tracker.hasStarted()) {
                SimpleChunkLoaders.LOADER.getByDimension(this.func_145831_w().func_201675_m().func_186058_p()).load(this.field_174879_c);
            }
            this.onPlace = false;
        }
        this.tracker.tick();
    }

    public CompoundNBT save(CompoundNBT nbt, SaveDataType type) {
        super.save(nbt, type);
        nbt.func_218657_a("inv", (INBT)this.handler.serializeNBT());
        nbt.func_218657_a("t", (INBT)this.tracker.serializeNBT());
        return nbt;
    }

    public void load(CompoundNBT nbt, SaveDataType type) {
        super.load(nbt, type);
        if (nbt.func_74764_b("inv")) {
            CompoundNBT inv = nbt.func_74775_l("inv");
            this.handler.deserializeNBT(inv);
        }
        if (nbt.func_74764_b("t")) {
            CompoundNBT tkr = nbt.func_74775_l("t");
            this.tracker.deserializeNBT(tkr);
        }
    }

    public int getCurrentDuration() {
        return this.tracker.getCurrentDuration();
    }

    public int getCurrentProgress() {
        return this.tracker.getCurrentProgress();
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent("Test");
    }

    @Nullable
    public LimitedChunkLoaderContainer createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new LimitedChunkLoaderContainer(i, playerInventory, this);
    }

    static {
        FUELS.put(new ItemStack((IItemProvider)Items.field_151079_bi), 27000);
        FUELS.put(new ItemStack((IItemProvider)Items.field_151061_bv), 40500);
        FUELS.put(new ItemStack((IItemProvider)Items.field_185158_cP), 54000);
    }

    public static class Inv
    implements IInventory,
    INBTSerializer {
        private final int slotsCount;
        private List<IInventoryChangedListener> listeners;
        private NonNullList<ItemStack> contents;

        public Inv(int slots) {
            this.slotsCount = slots;
            this.contents = NonNullList.func_191197_a((int)slots, (Object)ItemStack.field_190927_a);
        }

        public void addListener(IInventoryChangedListener listener) {
            if (this.listeners == null) {
                this.listeners = Lists.newArrayList();
            }
            this.listeners.add(listener);
        }

        public void removeListener(IInventoryChangedListener listener) {
            this.listeners.remove(listener);
        }

        public ItemStack func_70301_a(int slot) {
            return slot >= 0 && slot < this.contents.size() ? (ItemStack)this.contents.get(slot) : ItemStack.field_190927_a;
        }

        public ItemStack func_70298_a(int slot, int amnt) {
            ItemStack split = ItemStackHelper.func_188382_a(this.contents, (int)slot, (int)amnt);
            if (!split.func_190926_b()) {
                this.func_70296_d();
            }
            return split;
        }

        public ItemStack addItem(ItemStack stack) {
            ItemStack copy = stack.func_77946_l();
            this.add(copy);
            if (copy.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            this.putInEmpty(copy);
            return copy.func_190926_b() ? ItemStack.field_190927_a : copy;
        }

        public ItemStack func_70304_b(int slot) {
            ItemStack stack = (ItemStack)this.contents.get(slot);
            if (stack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            this.contents.set(slot, (Object)ItemStack.field_190927_a);
            return stack;
        }

        public void func_70299_a(int slot, ItemStack stack) {
            this.contents.set(slot, (Object)stack);
            if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
                stack.func_190920_e(this.func_70297_j_());
            }
            this.func_70296_d();
        }

        public int func_70302_i_() {
            return this.slotsCount;
        }

        public boolean func_191420_l() {
            ItemStack slot;
            Iterator var1 = this.contents.iterator();
            do {
                if (var1.hasNext()) continue;
                return true;
            } while ((slot = (ItemStack)var1.next()).func_190926_b());
            return false;
        }

        public void func_70296_d() {
            if (this.listeners != null) {
                for (IInventoryChangedListener listener : this.listeners) {
                    listener.func_76316_a((IInventory)this);
                }
            }
        }

        public boolean func_70300_a(PlayerEntity player) {
            return true;
        }

        public void func_174888_l() {
            this.contents.clear();
            this.func_70296_d();
        }

        public void fillStackedContents(RecipeItemHelper recipeHelper) {
            for (ItemStack stack : this.contents) {
                recipeHelper.func_194112_a(stack);
            }
        }

        public String toString() {
            return this.contents.stream().filter(p_223371_0_ -> !p_223371_0_.func_190926_b()).collect(Collectors.toList()).toString();
        }

        private void putInEmpty(ItemStack item) {
            for (int i = 0; i < this.slotsCount; ++i) {
                ItemStack slot = this.func_70301_a(i);
                if (!slot.func_190926_b()) continue;
                this.func_70299_a(i, item.func_77946_l());
                item.func_190920_e(0);
                return;
            }
        }

        private void add(ItemStack item) {
            for (int i = 0; i < this.slotsCount; ++i) {
                ItemStack slot = this.func_70301_a(i);
                if (!ItemStack.func_179545_c((ItemStack)slot, (ItemStack)item)) continue;
                this.combine(item, slot);
                if (!item.func_190926_b()) continue;
                return;
            }
        }

        private void combine(ItemStack stack, ItemStack stack2) {
            int maxStack = Math.min(this.func_70297_j_(), stack2.func_77976_d());
            int insertable = Math.min(stack.func_190916_E(), maxStack - stack2.func_190916_E());
            if (insertable > 0) {
                stack2.func_190917_f(insertable);
                stack.func_190918_g(insertable);
                this.func_70296_d();
            }
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT inv = new CompoundNBT();
            ItemStackHelper.func_191282_a((CompoundNBT)inv, this.contents);
            return inv;
        }

        public void deserializeNBT(CompoundNBT compoundNBT) {
            ItemStackHelper.func_191283_b((CompoundNBT)compoundNBT, this.contents);
        }
    }
}

