/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.registry;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.schedule.Schedule;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.entity.item.PaintingType;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.villager.IVillagerType;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.Potions;
import net.minecraft.stats.StatType;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IObjectIntIterable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.registry.DefaultedRegistry;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.provider.BiomeProviderType;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGeneratorType;
import net.minecraft.world.gen.blockplacer.BlockPlacerType;
import net.minecraft.world.gen.blockstateprovider.BlockStateProviderType;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.jigsaw.IJigsawDeserializer;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.template.IRuleTestType;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.foliageplacer.FoliagePlacerType;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.treedecorator.TreeDecoratorType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Registry<T>
implements IObjectIntIterable<T> {
    protected static final Logger field_212616_e = LogManager.getLogger();
    private static final Map<ResourceLocation, Supplier<?>> field_218376_a = Maps.newLinkedHashMap();
    public static final MutableRegistry<MutableRegistry<?>> field_212617_f = new SimpleRegistry();
    @Deprecated
    public static final Registry<SoundEvent> field_212633_v = Registry.forge("sound_event", SoundEvent.class, () -> SoundEvents.field_187638_cR);
    @Deprecated
    public static final DefaultedRegistry<Fluid> field_212619_h = Registry.forgeDefaulted("fluid", Fluid.class, () -> Fluids.field_204541_a);
    @Deprecated
    public static final Registry<Effect> field_212631_t = Registry.forge("mob_effect", Effect.class, () -> Effects.field_188425_z);
    @Deprecated
    public static final DefaultedRegistry<Block> field_212618_g = Registry.forgeDefaulted("block", Block.class, () -> Blocks.field_150350_a);
    @Deprecated
    public static final Registry<Enchantment> field_212628_q = Registry.forge("enchantment", Enchantment.class, () -> Enchantments.field_185308_t);
    @Deprecated
    public static final DefaultedRegistry<EntityType<?>> field_212629_r = Registry.forgeDefaulted("entity_type", EntityType.class, () -> EntityType.field_200784_X);
    @Deprecated
    public static final DefaultedRegistry<Item> field_212630_s = Registry.forgeDefaulted("item", Item.class, () -> Items.field_190931_a);
    @Deprecated
    public static final DefaultedRegistry<Potion> field_212621_j = Registry.forgeDefaulted("potion", Potion.class, () -> Potions.field_185229_a);
    @Deprecated
    public static final Registry<WorldCarver<?>> field_218377_o = Registry.forge("carver", WorldCarver.class, () -> WorldCarver.field_222709_a);
    @Deprecated
    public static final Registry<SurfaceBuilder<?>> field_218378_p = Registry.forge("surface_builder", SurfaceBuilder.class, () -> SurfaceBuilder.field_215396_G);
    @Deprecated
    public static final Registry<Feature<?>> field_218379_q = Registry.forge("feature", Feature.class, () -> Feature.field_202290_aj);
    @Deprecated
    public static final Registry<Placement<?>> field_218380_r = Registry.forge("decorator", Placement.class, () -> Placement.field_215022_h);
    @Deprecated
    public static final Registry<Biome> field_212624_m = Registry.forge("biome", Biome.class, () -> Biomes.field_180279_ad);
    public static final Registry<BlockStateProviderType<?>> field_229387_t_ = Registry.func_222935_a("block_state_provider_type", () -> BlockStateProviderType.field_227394_a_);
    public static final Registry<BlockPlacerType<?>> field_229388_u_ = Registry.func_222935_a("block_placer_type", () -> BlockPlacerType.field_227259_a_);
    public static final Registry<FoliagePlacerType<?>> field_229389_v_ = Registry.func_222935_a("foliage_placer_type", () -> FoliagePlacerType.field_227386_a_);
    public static final Registry<TreeDecoratorType<?>> field_229390_w_ = Registry.func_222935_a("tree_decorator_type", () -> TreeDecoratorType.field_227426_b_);
    @Deprecated
    public static final Registry<ParticleType<? extends IParticleData>> field_212632_u = Registry.forge("particle_type", ParticleType.class, () -> ParticleTypes.field_197611_d);
    @Deprecated
    public static final Registry<BiomeProviderType<?, ?>> field_212625_n = Registry.forge("biome_source_type", BiomeProviderType.class, () -> BiomeProviderType.field_206859_d);
    @Deprecated
    public static final Registry<TileEntityType<?>> field_212626_o = Registry.forge("block_entity_type", TileEntityType.class, () -> TileEntityType.field_200971_b);
    @Deprecated
    public static final Registry<ChunkGeneratorType<?, ?>> field_212627_p = Registry.forge("chunk_generator_type", ChunkGeneratorType.class, () -> ChunkGeneratorType.field_205489_f);
    @Deprecated
    public static final Registry<DimensionType> field_212622_k = Registry.func_222939_a("dimension_type", DimensionManager.getRegistry(), () -> DimensionType.field_223227_a_);
    @Deprecated
    public static final DefaultedRegistry<PaintingType> field_212620_i = Registry.forgeDefaulted("motive", PaintingType.class, () -> PaintingType.field_200843_b);
    public static final Registry<ResourceLocation> field_212623_l = Registry.func_222935_a("custom_stat", () -> Stats.field_75953_u);
    @Deprecated
    public static final DefaultedRegistry<ChunkStatus> field_218360_A = Registry.forgeDefaulted("chunk_status", ChunkStatus.class, () -> ChunkStatus.field_223226_a_);
    @Deprecated
    public static final Registry<Structure<?>> field_218361_B = GameData.getStructureFeatures();
    public static final Registry<IStructurePieceType> field_218362_C = Registry.func_222935_a("structure_piece", () -> IStructurePieceType.field_214782_c);
    public static final Registry<IRuleTestType> field_218363_D = Registry.func_222935_a("rule_test", () -> IRuleTestType.field_214911_b);
    public static final Registry<IStructureProcessorType> field_218364_E = Registry.func_222935_a("structure_processor", () -> IStructureProcessorType.field_214920_b);
    public static final Registry<IJigsawDeserializer> field_218365_F = Registry.func_222935_a("structure_pool_element", () -> IJigsawDeserializer.field_214931_e);
    @Deprecated
    public static final Registry<ContainerType<?>> field_218366_G = Registry.forge("menu", ContainerType.class, () -> ContainerType.field_221514_h);
    public static final Registry<IRecipeType<?>> field_218367_H = Registry.func_222935_a("recipe_type", () -> IRecipeType.field_222149_a);
    @Deprecated
    public static final Registry<IRecipeSerializer<?>> field_218368_I = Registry.forge("recipe_serializer", IRecipeSerializer.class, () -> IRecipeSerializer.field_222158_b);
    @Deprecated
    public static final Registry<StatType<?>> field_212634_w = Registry.forge("stat_type", StatType.class, () -> Stats.field_75929_E);
    public static final DefaultedRegistry<IVillagerType> field_218369_K = Registry.func_222933_a("villager_type", "plains", () -> IVillagerType.field_221175_c);
    @Deprecated
    public static final DefaultedRegistry<VillagerProfession> field_218370_L = Registry.forgeDefaulted("villager_profession", VillagerProfession.class, () -> VillagerProfession.field_221151_a);
    @Deprecated
    public static final DefaultedRegistry<PointOfInterestType> field_218371_M = Registry.forgeDefaulted("point_of_interest_type", PointOfInterestType.class, () -> PointOfInterestType.field_221054_b);
    @Deprecated
    public static final DefaultedRegistry<MemoryModuleType<?>> field_218372_N = Registry.forgeDefaulted("memory_module_type", MemoryModuleType.class, () -> MemoryModuleType.field_220940_a);
    @Deprecated
    public static final DefaultedRegistry<SensorType<?>> field_218373_O = Registry.forgeDefaulted("sensor_type", SensorType.class, () -> SensorType.field_220997_a);
    @Deprecated
    public static final Registry<Schedule> field_218374_P = Registry.forge("schedule", Schedule.class, () -> Schedule.field_221383_a);
    @Deprecated
    public static final Registry<Activity> field_218375_Q = Registry.forge("activity", Activity.class, () -> Activity.field_221366_b);

    private static <T> Registry<T> func_222935_a(String p_222935_0_, Supplier<T> p_222935_1_) {
        return Registry.func_222939_a(p_222935_0_, new SimpleRegistry(), p_222935_1_);
    }

    private static <T> DefaultedRegistry<T> func_222933_a(String p_222933_0_, String p_222933_1_, Supplier<T> p_222933_2_) {
        return Registry.func_222939_a(p_222933_0_, new DefaultedRegistry(p_222933_1_), p_222933_2_);
    }

    private static <T, R extends MutableRegistry<T>> R func_222939_a(String p_222939_0_, R p_222939_1_, Supplier<T> p_222939_2_) {
        ResourceLocation resourcelocation = new ResourceLocation(p_222939_0_);
        field_218376_a.put(resourcelocation, p_222939_2_);
        return (R)((MutableRegistry)field_212617_f.func_218381_a(resourcelocation, p_222939_1_));
    }

    @Nullable
    public abstract ResourceLocation func_177774_c(T var1);

    public abstract int func_148757_b(@Nullable T var1);

    @Nullable
    public abstract T func_82594_a(@Nullable ResourceLocation var1);

    public abstract Optional<T> func_218349_b(@Nullable ResourceLocation var1);

    public abstract Set<ResourceLocation> func_148742_b();

    @Nullable
    public abstract T func_186801_a(Random var1);

    public Stream<T> func_201756_e() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract boolean func_212607_c(ResourceLocation var1);

    public static <T> T func_218325_a(Registry<? super T> p_218325_0_, String p_218325_1_, T p_218325_2_) {
        return Registry.func_218322_a(p_218325_0_, new ResourceLocation(p_218325_1_), p_218325_2_);
    }

    public static <T> T func_218322_a(Registry<? super T> p_218322_0_, ResourceLocation p_218322_1_, T p_218322_2_) {
        return (T)((MutableRegistry)p_218322_0_).func_218381_a(p_218322_1_, p_218322_2_);
    }

    public static <T> T func_218343_a(Registry<? super T> p_218343_0_, int p_218343_1_, String p_218343_2_, T p_218343_3_) {
        return (T)((MutableRegistry)p_218343_0_).func_218382_a(p_218343_1_, new ResourceLocation(p_218343_2_), p_218343_3_);
    }

    private static <T extends IForgeRegistryEntry<T>> Registry<T> forge(String name, Class<? super T> cls, Supplier<T> def) {
        return Registry.func_222939_a(name, GameData.getWrapper(cls), def);
    }

    private static <T extends IForgeRegistryEntry<T>> DefaultedRegistry<T> forgeDefaulted(String name, Class<? super T> cls, Supplier<T> def) {
        return Registry.func_222939_a(name, GameData.getWrapperDefaulted(cls), def);
    }

    static {
        field_218376_a.entrySet().forEach(p_229397_0_ -> {
            if (((Supplier)p_229397_0_.getValue()).get() == null) {
                field_212616_e.error("Unable to bootstrap registry '{}'", p_229397_0_.getKey());
            }
        });
        field_212617_f.forEach(p_229396_0_ -> {
            if (p_229396_0_.func_195866_d()) {
                field_212616_e.error("Registry '{}' was empty after loading", (Object)field_212617_f.func_177774_c(p_229396_0_));
                if (SharedConstants.field_206244_b) {
                    throw new IllegalStateException("Registry: '" + field_212617_f.func_177774_c(p_229396_0_) + "' is empty, not allowed, fix me!");
                }
            }
            if (p_229396_0_ instanceof DefaultedRegistry) {
                ResourceLocation resourcelocation = ((DefaultedRegistry)p_229396_0_).func_212609_b();
                Validate.notNull((Object)p_229396_0_.func_82594_a(resourcelocation), (String)("Missing default of DefaultedMappedRegistry: " + resourcelocation), (Object[])new Object[0]);
            }
        });
    }
}

