/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.StitcherException;
import net.minecraft.client.renderer.texture.ITickable;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.PngSizeInfo;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class AtlasTexture
extends Texture
implements ITickable {
    private static final Logger field_147635_d = LogManager.getLogger();
    @Deprecated
    public static final ResourceLocation field_110575_b = PlayerContainer.field_226615_c_;
    @Deprecated
    public static final ResourceLocation field_215262_g = new ResourceLocation("textures/atlas/particles.png");
    private final List<TextureAtlasSprite> field_94258_i = Lists.newArrayList();
    private final Set<ResourceLocation> field_195427_i = Sets.newHashSet();
    private final Map<ResourceLocation, TextureAtlasSprite> field_94252_e = Maps.newHashMap();
    private final ResourceLocation field_229214_j_;
    private final int field_215265_o;

    public AtlasTexture(ResourceLocation textureLocationIn) {
        this.field_229214_j_ = textureLocationIn;
        this.field_215265_o = RenderSystem.maxSupportedTextureSize();
    }

    @Override
    public void func_195413_a(IResourceManager manager) throws IOException {
    }

    public void func_215260_a(SheetData sheetDataIn) {
        this.field_195427_i.clear();
        this.field_195427_i.addAll(sheetDataIn.field_217805_a);
        field_147635_d.info("Created: {}x{}x{} {}-atlas", (Object)sheetDataIn.field_217806_b, (Object)sheetDataIn.field_217807_c, (Object)sheetDataIn.field_229224_d_, (Object)this.field_229214_j_);
        TextureUtil.func_225681_a_((int)this.func_110552_b(), (int)sheetDataIn.field_229224_d_, (int)sheetDataIn.field_217806_b, (int)sheetDataIn.field_217807_c);
        this.func_195419_g();
        for (TextureAtlasSprite textureatlassprite : sheetDataIn.field_217808_d) {
            this.field_94252_e.put(textureatlassprite.func_195668_m(), textureatlassprite);
            try {
                textureatlassprite.func_195663_q();
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a(throwable, "Stitching texture atlas");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Texture being stitched together");
                crashreportcategory.func_71507_a("Atlas path", this.field_229214_j_);
                crashreportcategory.func_71507_a("Sprite", textureatlassprite);
                throw new ReportedException(crashreport);
            }
            if (!textureatlassprite.func_130098_m()) continue;
            this.field_94258_i.add(textureatlassprite);
        }
        ForgeHooksClient.onTextureStitchedPost((AtlasTexture)this);
    }

    public SheetData func_229220_a_(IResourceManager resourceManagerIn, Stream<ResourceLocation> resourceLocationsIn, IProfiler profilerIn, int maxMipmapLevelIn) {
        profilerIn.func_76320_a("preparing");
        Set<ResourceLocation> set = resourceLocationsIn.peek(p_229222_0_ -> {
            if (p_229222_0_ == null) {
                throw new IllegalArgumentException("Location cannot be null!");
            }
        }).collect(Collectors.toSet());
        int i = this.field_215265_o;
        Stitcher stitcher = new Stitcher(i, i, maxMipmapLevelIn);
        int j = Integer.MAX_VALUE;
        int k = 1 << maxMipmapLevelIn;
        profilerIn.func_219895_b("extracting_frames");
        ForgeHooksClient.onTextureStitchedPre((AtlasTexture)this, set);
        for (TextureAtlasSprite.Info textureatlassprite$info : this.func_215256_a(resourceManagerIn, set)) {
            j = Math.min(j, Math.min(textureatlassprite$info.func_229250_b_(), textureatlassprite$info.func_229252_c_()));
            int l = Math.min(Integer.lowestOneBit(textureatlassprite$info.func_229250_b_()), Integer.lowestOneBit(textureatlassprite$info.func_229252_c_()));
            if (l < k) {
                field_147635_d.warn("Texture {} with size {}x{} limits mip level from {} to {}", (Object)textureatlassprite$info.func_229248_a_(), (Object)textureatlassprite$info.func_229250_b_(), (Object)textureatlassprite$info.func_229252_c_(), (Object)MathHelper.func_151239_c((int)k), (Object)MathHelper.func_151239_c((int)l));
                k = l;
            }
            stitcher.func_229211_a_(textureatlassprite$info);
        }
        int i1 = Math.min(j, k);
        int j1 = MathHelper.func_151239_c((int)i1);
        int k1 = maxMipmapLevelIn;
        profilerIn.func_219895_b("register");
        stitcher.func_229211_a_(MissingTextureSprite.func_229177_b_());
        profilerIn.func_219895_b("stitching");
        try {
            stitcher.func_94305_f();
        }
        catch (StitcherException stitcherexception) {
            CrashReport crashreport = CrashReport.func_85055_a(stitcherexception, "Stitching");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Stitcher");
            crashreportcategory.func_71507_a("Sprites", stitcherexception.func_225331_a().stream().map(p_229216_0_ -> String.format("%s[%dx%d]", p_229216_0_.func_229248_a_(), p_229216_0_.func_229250_b_(), p_229216_0_.func_229252_c_())).collect(Collectors.joining(",")));
            crashreportcategory.func_71507_a("Max Texture Size", i);
            throw new ReportedException(crashreport);
        }
        profilerIn.func_219895_b("loading");
        List<TextureAtlasSprite> list = this.func_229217_a_(resourceManagerIn, stitcher, k1);
        profilerIn.func_76319_b();
        return new SheetData(set, stitcher.func_110935_a(), stitcher.func_110936_b(), k1, list);
    }

    private Collection<TextureAtlasSprite.Info> func_215256_a(IResourceManager resourceManagerIn, Set<ResourceLocation> spriteLocationsIn) {
        ArrayList list = Lists.newArrayList();
        ConcurrentLinkedQueue<TextureAtlasSprite.Info> concurrentlinkedqueue = new ConcurrentLinkedQueue<TextureAtlasSprite.Info>();
        for (ResourceLocation resourcelocation : spriteLocationsIn) {
            if (MissingTextureSprite.func_195675_b().equals((Object)resourcelocation)) continue;
            list.add(CompletableFuture.runAsync(() -> {
                TextureAtlasSprite.Info textureatlassprite$info;
                ResourceLocation resourcelocation1 = this.func_195420_b(resourcelocation);
                try (IResource iresource = resourceManagerIn.func_199002_a(resourcelocation1);){
                    PngSizeInfo pngsizeinfo = new PngSizeInfo(iresource.toString(), iresource.func_199027_b());
                    AnimationMetadataSection animationmetadatasection = (AnimationMetadataSection)iresource.func_199028_a((IMetadataSectionSerializer)AnimationMetadataSection.field_195817_a);
                    if (animationmetadatasection == null) {
                        animationmetadatasection = AnimationMetadataSection.field_229300_b_;
                    }
                    Pair pair = animationmetadatasection.func_225641_a_(pngsizeinfo.field_188533_a, pngsizeinfo.field_188534_b);
                    textureatlassprite$info = new TextureAtlasSprite.Info(resourcelocation, (Integer)pair.getFirst(), (Integer)pair.getSecond(), animationmetadatasection);
                }
                catch (RuntimeException runtimeexception) {
                    field_147635_d.error("Unable to parse metadata from {} : {}", (Object)resourcelocation1, (Object)runtimeexception);
                    return;
                }
                catch (IOException ioexception) {
                    field_147635_d.error("Using missing texture, unable to load {} : {}", (Object)resourcelocation1, (Object)ioexception);
                    return;
                }
                concurrentlinkedqueue.add(textureatlassprite$info);
            }, Util.func_215072_e()));
        }
        CompletableFuture.allOf(list.toArray(new CompletableFuture[0])).join();
        return concurrentlinkedqueue;
    }

    private List<TextureAtlasSprite> func_229217_a_(IResourceManager resourceManagerIn, Stitcher stitcherIn, int mipmapLevelIn) {
        ConcurrentLinkedQueue concurrentlinkedqueue = new ConcurrentLinkedQueue();
        ArrayList list = Lists.newArrayList();
        stitcherIn.func_229209_a_((p_229215_5_, p_229215_6_, p_229215_7_, p_229215_8_, p_229215_9_) -> {
            if (p_229215_5_ == MissingTextureSprite.func_229177_b_()) {
                MissingTextureSprite missingtexturesprite = MissingTextureSprite.func_229176_a_((AtlasTexture)this, (int)mipmapLevelIn, (int)p_229215_6_, (int)p_229215_7_, (int)p_229215_8_, (int)p_229215_9_);
                concurrentlinkedqueue.add(missingtexturesprite);
            } else {
                list.add(CompletableFuture.runAsync(() -> {
                    TextureAtlasSprite textureatlassprite = this.func_229218_a_(resourceManagerIn, p_229215_5_, p_229215_6_, p_229215_7_, mipmapLevelIn, p_229215_8_, p_229215_9_);
                    if (textureatlassprite != null) {
                        concurrentlinkedqueue.add(textureatlassprite);
                    }
                }, Util.func_215072_e()));
            }
        });
        CompletableFuture.allOf(list.toArray(new CompletableFuture[0])).join();
        return Lists.newArrayList(concurrentlinkedqueue);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private TextureAtlasSprite func_229218_a_(IResourceManager resourceManagerIn, TextureAtlasSprite.Info spriteInfoIn, int widthIn, int heightIn, int mipmapLevelIn, int originX, int originY) {
        ResourceLocation resourcelocation = this.func_195420_b(spriteInfoIn.func_229248_a_());
        try (IResource iresource = resourceManagerIn.func_199002_a(resourcelocation);){
            TextureAtlasSprite textureatlassprite;
            NativeImage nativeimage = NativeImage.func_195713_a(iresource.func_199027_b());
            TextureAtlasSprite textureAtlasSprite = textureatlassprite = new TextureAtlasSprite(this, spriteInfoIn, mipmapLevelIn, widthIn, heightIn, originX, originY, nativeimage);
            return textureAtlasSprite;
        }
        catch (RuntimeException runtimeexception) {
            field_147635_d.error("Unable to parse metadata from {}", (Object)resourcelocation, (Object)runtimeexception);
            return null;
        }
        catch (IOException ioexception) {
            field_147635_d.error("Using missing texture, unable to load {}", (Object)resourcelocation, (Object)ioexception);
            return null;
        }
    }

    private ResourceLocation func_195420_b(ResourceLocation location) {
        return new ResourceLocation(location.func_110624_b(), String.format("textures/%s%s", location.func_110623_a(), ".png"));
    }

    public void func_94248_c() {
        this.func_229148_d_();
        for (TextureAtlasSprite textureatlassprite : this.field_94258_i) {
            textureatlassprite.func_94219_l();
        }
    }

    public void func_110550_d() {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(this::func_94248_c);
        } else {
            this.func_94248_c();
        }
    }

    public TextureAtlasSprite func_195424_a(ResourceLocation location) {
        TextureAtlasSprite textureatlassprite = this.field_94252_e.get(location);
        return textureatlassprite == null ? this.field_94252_e.get(MissingTextureSprite.func_195675_b()) : textureatlassprite;
    }

    public void func_195419_g() {
        for (TextureAtlasSprite textureatlassprite : this.field_94252_e.values()) {
            textureatlassprite.close();
        }
        this.field_94252_e.clear();
        this.field_94258_i.clear();
    }

    public ResourceLocation func_229223_g_() {
        return this.field_229214_j_;
    }

    public void func_229221_b_(SheetData sheetDataIn) {
        this.func_174937_a(false, sheetDataIn.field_229224_d_ > 0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class SheetData {
        final Set<ResourceLocation> field_217805_a;
        final int field_217806_b;
        final int field_217807_c;
        final int field_229224_d_;
        final List<TextureAtlasSprite> field_217808_d;

        public SheetData(Set<ResourceLocation> spriteLocationsIn, int widthIn, int heightIn, int mipmapLevelIn, List<TextureAtlasSprite> spritesIn) {
            this.field_217805_a = spriteLocationsIn;
            this.field_217806_b = widthIn;
            this.field_217807_c = heightIn;
            this.field_229224_d_ = mipmapLevelIn;
            this.field_217808_d = spritesIn;
        }
    }
}

