/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.GlazedTerracottaBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.StateContainer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTables;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.extensions.IForgeBlock;
import net.minecraftforge.common.util.ReverseTagWrapper;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.GameData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Block
extends ForgeRegistryEntry<Block>
implements IItemProvider,
IForgeBlock {
    protected static final Logger field_196273_d = LogManager.getLogger();
    @Deprecated
    public static final ObjectIntIdentityMap<BlockState> field_176229_d = GameData.getBlockStateIDMap();
    private static final Direction[] field_212556_a = new Direction[]{Direction.WEST, Direction.EAST, Direction.NORTH, Direction.SOUTH, Direction.DOWN, Direction.UP};
    private static final LoadingCache<VoxelShape, Boolean> field_223006_b = CacheBuilder.newBuilder().maximumSize(512L).weakKeys().build((CacheLoader)new CacheLoader<VoxelShape, Boolean>(){

        public Boolean load(VoxelShape p_load_1_) {
            return !VoxelShapes.func_197879_c((VoxelShape)VoxelShapes.func_197868_b(), (VoxelShape)p_load_1_, (IBooleanFunction)IBooleanFunction.field_223236_g_);
        }
    });
    private static final VoxelShape field_220083_b = VoxelShapes.func_197878_a((VoxelShape)VoxelShapes.func_197868_b(), (VoxelShape)Block.func_208617_a(2.0, 0.0, 2.0, 14.0, 16.0, 14.0), (IBooleanFunction)IBooleanFunction.field_223234_e_);
    private static final VoxelShape field_220084_c = Block.func_208617_a(7.0, 0.0, 7.0, 9.0, 10.0, 9.0);
    protected final int field_149784_t;
    protected final float field_149782_v;
    protected final float field_149781_w;
    protected final boolean field_149789_z;
    protected final SoundType field_149762_H;
    protected final Material field_149764_J;
    protected final MaterialColor field_181083_K;
    private final float field_149765_K;
    private final float field_226886_f_;
    private final float field_226887_g_;
    protected final StateContainer<Block, BlockState> field_176227_L;
    private BlockState field_196275_y;
    protected final boolean field_196274_w;
    private final boolean field_208621_p;
    private final boolean field_226888_j_;
    @Nullable
    private ResourceLocation field_220085_g;
    @Nullable
    private String field_149770_b;
    @Nullable
    private Item field_220086_i;
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<RenderSideCacheKey>> field_210300_r = ThreadLocal.withInitial(() -> {
        Object2ByteLinkedOpenHashMap<RenderSideCacheKey> object2bytelinkedopenhashmap = new Object2ByteLinkedOpenHashMap<RenderSideCacheKey>(2048, 0.25f){

            protected void rehash(int p_rehash_1_) {
            }
        };
        object2bytelinkedopenhashmap.defaultReturnValue((byte)127);
        return object2bytelinkedopenhashmap;
    });
    protected Random RANDOM = new Random();
    private ToolType harvestTool;
    private int harvestLevel;
    private final ReverseTagWrapper<Block> reverseTags = new ReverseTagWrapper((Object)this, BlockTags::getGeneration, BlockTags::func_199896_a);
    private final Supplier<ResourceLocation> lootTableSupplier;

    public static int func_196246_j(@Nullable BlockState state) {
        if (state == null) {
            return 0;
        }
        int i = field_176229_d.func_148747_b((Object)state);
        return i == -1 ? 0 : i;
    }

    public static BlockState func_196257_b(int id) {
        BlockState blockstate = (BlockState)((Object)field_176229_d.func_148745_a(id));
        return blockstate == null ? Blocks.field_150350_a.func_176223_P() : blockstate;
    }

    public static Block func_149634_a(@Nullable Item itemIn) {
        return itemIn instanceof BlockItem ? ((BlockItem)itemIn).func_179223_d() : Blocks.field_150350_a;
    }

    public static BlockState func_199601_a(BlockState oldState, BlockState newState, World worldIn, BlockPos pos) {
        VoxelShape voxelshape = VoxelShapes.func_197882_b((VoxelShape)oldState.func_196952_d((IBlockReader)((Object)worldIn), pos), (VoxelShape)newState.func_196952_d((IBlockReader)((Object)worldIn), pos), (IBooleanFunction)IBooleanFunction.field_223232_c_).func_197751_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        for (Entity entity : worldIn.func_72839_b(null, voxelshape.func_197752_a())) {
            double d0 = VoxelShapes.func_212437_a((Direction.Axis)Direction.Axis.Y, (AxisAlignedBB)entity.func_174813_aQ().func_72317_d(0.0, 1.0, 0.0), Stream.of(voxelshape), (double)-1.0);
            entity.func_70634_a(entity.func_226277_ct_(), entity.func_226278_cu_() + 1.0 + d0, entity.func_226281_cx_());
        }
        return newState;
    }

    public static VoxelShape func_208617_a(double x1, double y1, double z1, double x2, double y2, double z2) {
        return VoxelShapes.func_197873_a((double)(x1 / 16.0), (double)(y1 / 16.0), (double)(z1 / 16.0), (double)(x2 / 16.0), (double)(y2 / 16.0), (double)(z2 / 16.0));
    }

    @Deprecated
    public boolean func_220067_a(BlockState state, IBlockReader worldIn, BlockPos pos, EntityType<?> type) {
        return state.func_224755_d(worldIn, pos, Direction.UP) && state.getLightValue(worldIn, pos) < 14;
    }

    @Deprecated
    public boolean func_196261_e(BlockState state) {
        return false;
    }

    @Deprecated
    public int func_149750_m(BlockState state) {
        return this.field_149784_t;
    }

    @Deprecated
    public Material func_149688_o(BlockState state) {
        return this.field_149764_J;
    }

    @Deprecated
    public MaterialColor func_180659_g(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return this.field_181083_K;
    }

    @Deprecated
    public void func_196242_c(BlockState stateIn, IWorld worldIn, BlockPos pos, int flags) {
        try (BlockPos.PooledMutable blockpos$pooledmutable = BlockPos.PooledMutable.func_185346_s();){
            for (Direction direction : field_212556_a) {
                blockpos$pooledmutable.func_189533_g((Vec3i)pos).func_189536_c(direction);
                BlockState blockstate = worldIn.func_180495_p((BlockPos)blockpos$pooledmutable);
                BlockState blockstate1 = blockstate.func_196956_a(direction.func_176734_d(), stateIn, worldIn, (BlockPos)blockpos$pooledmutable, pos);
                Block.func_196263_a(blockstate, blockstate1, worldIn, (BlockPos)blockpos$pooledmutable, flags);
            }
        }
    }

    public boolean func_203417_a(Tag<Block> tagIn) {
        return tagIn.func_199685_a_(this);
    }

    public static BlockState func_199770_b(BlockState currentState, IWorld worldIn, BlockPos pos) {
        BlockState blockstate = currentState;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (Direction direction : field_212556_a) {
            blockpos$mutable.func_189533_g((Vec3i)pos).func_189536_c(direction);
            blockstate = blockstate.func_196956_a(direction, worldIn.func_180495_p((BlockPos)blockpos$mutable), worldIn, pos, (BlockPos)blockpos$mutable);
        }
        return blockstate;
    }

    public static void func_196263_a(BlockState oldState, BlockState newState, IWorld worldIn, BlockPos pos, int flags) {
        if (newState != oldState) {
            if (newState.func_196958_f()) {
                if (!worldIn.func_201670_d()) {
                    worldIn.func_175655_b(pos, (flags & 0x20) == 0);
                }
            } else {
                worldIn.func_180501_a(pos, newState, flags & 0xFFFFFFDF);
            }
        }
    }

    @Deprecated
    public void func_196248_b(BlockState state, IWorld worldIn, BlockPos pos, int flags) {
    }

    @Deprecated
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return stateIn;
    }

    @Deprecated
    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return state;
    }

    @Deprecated
    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state;
    }

    public Block(Properties properties) {
        StateContainer.Builder builder = new StateContainer.Builder((Object)this);
        this.func_206840_a((StateContainer.Builder<Block, BlockState>)builder);
        this.field_149764_J = properties.field_200953_a;
        this.field_181083_K = properties.field_200954_b;
        this.field_196274_w = properties.field_200955_c;
        this.field_149762_H = properties.field_200956_d;
        this.field_149784_t = properties.field_200957_e;
        this.field_149781_w = properties.field_200958_f;
        this.field_149782_v = properties.field_200959_g;
        this.field_149789_z = properties.field_200960_h;
        this.harvestLevel = properties.harvestLevel;
        this.harvestTool = properties.harvestTool;
        ResourceLocation lootTableCache = properties.field_222381_j;
        this.lootTableSupplier = lootTableCache != null ? () -> lootTableCache : (properties.lootTableSupplier != null ? properties.lootTableSupplier : () -> new ResourceLocation(this.getRegistryName().func_110624_b(), "blocks/" + this.getRegistryName().func_110623_a()));
        this.field_149765_K = properties.field_200961_i;
        this.field_226886_f_ = properties.field_226893_j_;
        this.field_226887_g_ = properties.field_226894_k_;
        this.field_208621_p = properties.field_208772_j;
        this.field_220085_g = properties.field_222381_j;
        this.field_226888_j_ = properties.field_226895_m_;
        this.field_176227_L = builder.func_206893_a(BlockState::new);
        this.func_180632_j((BlockState)this.field_176227_L.func_177621_b());
    }

    public static boolean func_220073_a(Block blockIn) {
        return blockIn instanceof LeavesBlock || blockIn == Blocks.field_180401_cv || blockIn == Blocks.field_196625_cS || blockIn == Blocks.field_196628_cT || blockIn == Blocks.field_150440_ba || blockIn == Blocks.field_150423_aK || blockIn.func_203417_a(BlockTags.field_226150_J_);
    }

    @Deprecated
    public boolean func_220081_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_185904_a().func_76218_k() && state.func_224756_o(worldIn, pos) && !state.func_185897_m();
    }

    @Deprecated
    public boolean func_229869_c_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return this.field_149764_J.func_76230_c() && state.func_224756_o(worldIn, pos);
    }

    @Deprecated
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_229870_f_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_229980_m_(worldIn, pos);
    }

    @Deprecated
    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        switch (type) {
            case LAND: {
                return !state.func_224756_o(worldIn, pos);
            }
            case WATER: {
                return worldIn.func_204610_c(pos).func_206884_a(FluidTags.field_206959_a);
            }
            case AIR: {
                return !state.func_224756_o(worldIn, pos);
            }
        }
        return false;
    }

    @Deprecated
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @Deprecated
    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        return state.func_185904_a().func_76222_j() && (useContext.func_195996_i().func_190926_b() || useContext.func_195996_i().func_77973_b() != this.func_199767_j());
    }

    @Deprecated
    public boolean func_225541_a_(BlockState p_225541_1_, Fluid p_225541_2_) {
        return this.field_149764_J.func_76222_j() || !this.field_149764_J.func_76220_a();
    }

    @Deprecated
    public float func_176195_g(BlockState blockState, IBlockReader worldIn, BlockPos pos) {
        return this.field_149782_v;
    }

    public boolean func_149653_t(BlockState state) {
        return this.field_149789_z;
    }

    @Deprecated
    public boolean func_149716_u() {
        return this.hasTileEntity(this.func_176223_P());
    }

    @Deprecated
    public boolean func_201783_b(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    @Deprecated
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_225543_m_(BlockState p_225543_1_) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean func_176225_a(BlockState adjacentState, IBlockReader blockState, BlockPos blockAccess, Direction pos) {
        BlockPos blockpos = blockAccess.func_177972_a(pos);
        BlockState blockstate = blockState.func_180495_p(blockpos);
        if (adjacentState.func_200017_a(blockstate, pos)) {
            return false;
        }
        if (blockstate.func_200132_m()) {
            RenderSideCacheKey block$rendersidecachekey = new RenderSideCacheKey(adjacentState, blockstate, pos);
            Object2ByteLinkedOpenHashMap<RenderSideCacheKey> object2bytelinkedopenhashmap = field_210300_r.get();
            byte b0 = object2bytelinkedopenhashmap.getAndMoveToFirst((Object)block$rendersidecachekey);
            if (b0 != 127) {
                return b0 != 0;
            }
            VoxelShape voxelshape = adjacentState.func_215702_a(blockState, blockAccess, pos);
            VoxelShape voxelshape1 = blockstate.func_215702_a(blockState, blockpos, pos.func_176734_d());
            boolean flag = VoxelShapes.func_197879_c((VoxelShape)voxelshape, (VoxelShape)voxelshape1, (IBooleanFunction)IBooleanFunction.field_223234_e_);
            if (object2bytelinkedopenhashmap.size() == 2048) {
                object2bytelinkedopenhashmap.removeLastByte();
            }
            object2bytelinkedopenhashmap.putAndMoveToFirst((Object)block$rendersidecachekey, (byte)(flag ? 1 : 0));
            return flag;
        }
        return true;
    }

    @Deprecated
    public final boolean func_200124_e(BlockState state) {
        return this.field_226888_j_;
    }

    @Deprecated
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        return false;
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197868_b();
    }

    @Deprecated
    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.field_196274_w ? state.func_196954_c(worldIn, pos) : VoxelShapes.func_197880_a();
    }

    @Deprecated
    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_196954_c(worldIn, pos);
    }

    @Deprecated
    public VoxelShape func_199600_g(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return VoxelShapes.func_197880_a();
    }

    public static boolean func_220064_c(IBlockReader worldIn, BlockPos pos) {
        BlockState blockstate = worldIn.func_180495_p(pos);
        return !blockstate.func_203425_a(BlockTags.field_206952_E) && !VoxelShapes.func_197879_c((VoxelShape)blockstate.func_196952_d(worldIn, pos).func_212434_a(Direction.UP), (VoxelShape)field_220083_b, (IBooleanFunction)IBooleanFunction.field_223232_c_);
    }

    public static boolean func_220055_a(IWorldReader worldIn, BlockPos pos, Direction directionIn) {
        BlockState blockstate = worldIn.func_180495_p(pos);
        return !blockstate.func_203425_a(BlockTags.field_206952_E) && !VoxelShapes.func_197879_c((VoxelShape)blockstate.func_196952_d((IBlockReader)((Object)worldIn), pos).func_212434_a(directionIn), (VoxelShape)field_220084_c, (IBooleanFunction)IBooleanFunction.field_223232_c_);
    }

    public static boolean func_220056_d(BlockState state, IBlockReader worldIn, BlockPos pos, Direction side) {
        return !state.func_203425_a(BlockTags.field_206952_E) && Block.func_208061_a(state.func_196952_d(worldIn, pos), side);
    }

    public static boolean func_208061_a(VoxelShape shape, Direction side) {
        VoxelShape voxelshape = shape.func_212434_a(side);
        return Block.func_208062_a(voxelshape);
    }

    public static boolean func_208062_a(VoxelShape shape) {
        return (Boolean)field_223006_b.getUnchecked((Object)shape);
    }

    @Deprecated
    public final boolean func_200012_i(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_200132_m() ? Block.func_208062_a(state.func_196951_e(worldIn, pos)) : false;
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return !Block.func_208062_a(state.func_196954_c(reader, pos)) && state.func_204520_s().func_206888_e();
    }

    @Deprecated
    public int func_200011_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        if (state.func_200015_d(worldIn, pos)) {
            return worldIn.func_201572_C();
        }
        return state.func_200131_a(worldIn, pos) ? 0 : 1;
    }

    @Deprecated
    public boolean func_220074_n(BlockState state) {
        return false;
    }

    @Deprecated
    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        this.func_225534_a_(state, worldIn, pos, random);
    }

    @Deprecated
    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
    }

    public void func_176206_d(IWorld worldIn, BlockPos pos, BlockState state) {
    }

    @Deprecated
    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        DebugPacketSender.func_218806_a((World)worldIn, (BlockPos)pos);
    }

    public int func_149738_a(IWorldReader worldIn) {
        return 10;
    }

    @Nullable
    @Deprecated
    public INamedContainerProvider func_220052_b(BlockState state, World worldIn, BlockPos pos) {
        return null;
    }

    @Deprecated
    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
    }

    @Deprecated
    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.hasTileEntity() && state.func_177230_c() != newState.func_177230_c()) {
            worldIn.func_175713_t(pos);
        }
    }

    @Deprecated
    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader worldIn, BlockPos pos) {
        float f = state.func_185887_b(worldIn, pos);
        if (f == -1.0f) {
            return 0.0f;
        }
        int i = ForgeHooks.canHarvestBlock((BlockState)state, (PlayerEntity)player, (IBlockReader)worldIn, (BlockPos)pos) ? 30 : 100;
        return player.getDigSpeed(state, pos) / f / (float)i;
    }

    @Deprecated
    public void func_220062_a(BlockState state, World worldIn, BlockPos pos, ItemStack stack) {
    }

    public ResourceLocation func_220068_i() {
        if (this.field_220085_g == null) {
            this.field_220085_g = this.lootTableSupplier.get();
        }
        return this.field_220085_g;
    }

    @Deprecated
    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        ResourceLocation resourcelocation = this.func_220068_i();
        if (resourcelocation == LootTables.field_186419_a) {
            return Collections.emptyList();
        }
        LootContext lootcontext = builder.func_216015_a(LootParameters.field_216287_g, state).func_216022_a(LootParameterSets.field_216267_h);
        ServerWorld serverworld = lootcontext.func_202879_g();
        LootTable loottable = serverworld.func_73046_m().func_200249_aQ().func_186521_a(resourcelocation);
        return loottable.func_216113_a(lootcontext);
    }

    public static List<ItemStack> func_220070_a(BlockState state, ServerWorld worldIn, BlockPos pos, @Nullable TileEntity tileEntityIn) {
        LootContext.Builder lootcontext$builder = new LootContext.Builder(worldIn).func_216023_a(worldIn.field_73012_v).func_216015_a(LootParameters.field_216286_f, pos).func_216015_a(LootParameters.field_216289_i, ItemStack.field_190927_a).func_216021_b(LootParameters.field_216288_h, tileEntityIn);
        return state.func_215693_a(lootcontext$builder);
    }

    public static List<ItemStack> func_220077_a(BlockState state, ServerWorld worldIn, BlockPos pos, @Nullable TileEntity tileEntityIn, @Nullable Entity entityIn, ItemStack stack) {
        LootContext.Builder lootcontext$builder = new LootContext.Builder(worldIn).func_216023_a(worldIn.field_73012_v).func_216015_a(LootParameters.field_216286_f, pos).func_216015_a(LootParameters.field_216289_i, stack).func_216021_b(LootParameters.field_216281_a, entityIn).func_216021_b(LootParameters.field_216288_h, tileEntityIn);
        return state.func_215693_a(lootcontext$builder);
    }

    public static void func_220075_c(BlockState state, World worldIn, BlockPos pos) {
        if (worldIn instanceof ServerWorld) {
            Block.func_220070_a(state, (ServerWorld)worldIn, pos, null).forEach(p_220079_2_ -> Block.func_180635_a(worldIn, pos, p_220079_2_));
        }
        state.func_215706_a(worldIn, pos, ItemStack.field_190927_a);
    }

    public static void func_220059_a(BlockState state, World worldIn, BlockPos pos, @Nullable TileEntity tileEntityIn) {
        if (worldIn instanceof ServerWorld) {
            Block.func_220070_a(state, (ServerWorld)worldIn, pos, tileEntityIn).forEach(p_220061_2_ -> Block.func_180635_a(worldIn, pos, p_220061_2_));
        }
        state.func_215706_a(worldIn, pos, ItemStack.field_190927_a);
    }

    public static void func_220054_a(BlockState state, World worldIn, BlockPos pos, @Nullable TileEntity tileEntityIn, Entity entityIn, ItemStack stack) {
        if (worldIn instanceof ServerWorld) {
            Block.func_220077_a(state, (ServerWorld)worldIn, pos, tileEntityIn, entityIn, stack).forEach(p_220057_2_ -> Block.func_180635_a(worldIn, pos, p_220057_2_));
        }
        state.func_215706_a(worldIn, pos, stack);
    }

    public static void func_180635_a(World worldIn, BlockPos pos, ItemStack stack) {
        if (!worldIn.field_72995_K && !stack.func_190926_b() && worldIn.func_82736_K().func_223586_b(GameRules.field_223603_f) && !worldIn.restoringBlockSnapshots) {
            float f = 0.5f;
            double d0 = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
            double d1 = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
            double d2 = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
            ItemEntity itementity = new ItemEntity(worldIn, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, stack);
            itementity.func_174869_p();
            worldIn.func_217376_c(itementity);
        }
    }

    public void func_180637_b(World worldIn, BlockPos pos, int amount) {
        if (!worldIn.field_72995_K && worldIn.func_82736_K().func_223586_b(GameRules.field_223603_f) && !worldIn.restoringBlockSnapshots) {
            while (amount > 0) {
                int i = ExperienceOrbEntity.func_70527_a(amount);
                amount -= i;
                worldIn.func_217376_c(new ExperienceOrbEntity(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, i));
            }
        }
    }

    @Deprecated
    public float func_149638_a() {
        return this.field_149781_w;
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
    }

    @Deprecated
    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return true;
    }

    @Deprecated
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult p_225533_6_) {
        return ActionResultType.PASS;
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.func_176223_P();
    }

    @Deprecated
    public void func_196270_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
    }

    @Deprecated
    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return 0;
    }

    @Deprecated
    public boolean func_149744_f(BlockState state) {
        return false;
    }

    @Deprecated
    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
    }

    @Deprecated
    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return 0;
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        player.func_71029_a(Stats.field_188065_ae.func_199076_b(this));
        player.func_71020_j(0.005f);
        Block.func_220054_a(state, worldIn, pos, te, player, stack);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
    }

    public boolean func_181623_g() {
        return !this.field_149764_J.func_76220_a() && !this.field_149764_J.func_76224_d();
    }

    @OnlyIn(value=Dist.CLIENT)
    public ITextComponent func_200291_n() {
        return new TranslationTextComponent(this.func_149739_a(), new Object[0]);
    }

    public String func_149739_a() {
        if (this.field_149770_b == null) {
            this.field_149770_b = Util.func_200697_a((String)"block", (ResourceLocation)Registry.field_212618_g.func_177774_c((Object)this));
        }
        return this.field_149770_b;
    }

    @Deprecated
    public boolean func_189539_a(BlockState state, World worldIn, BlockPos pos, int id, int param) {
        return false;
    }

    @Deprecated
    public PushReaction func_149656_h(BlockState state) {
        return this.field_149764_J.func_186274_m();
    }

    @Deprecated
    @OnlyIn(value=Dist.CLIENT)
    public float func_220080_a(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_224756_o(worldIn, pos) ? 0.2f : 1.0f;
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        entityIn.func_225503_b_(fallDistance, 1.0f);
    }

    public void func_176216_a(IBlockReader worldIn, Entity entityIn) {
        entityIn.func_213317_d(entityIn.func_213322_ci().func_216372_d(1.0, 0.0, 1.0));
    }

    @Deprecated
    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack(this);
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack(this));
    }

    @Deprecated
    public IFluidState func_204507_t(BlockState state) {
        return Fluids.field_204541_a.func_207188_f();
    }

    @Deprecated
    public float func_208618_m() {
        return this.field_149765_K;
    }

    public float func_226891_m_() {
        return this.field_226886_f_;
    }

    public float func_226892_n_() {
        return this.field_226887_g_;
    }

    @Deprecated
    @OnlyIn(value=Dist.CLIENT)
    public long func_209900_a(BlockState state, BlockPos pos) {
        return MathHelper.func_180186_a((Vec3i)pos);
    }

    public void func_220066_a(World worldIn, BlockState state, BlockRayTraceResult hit, Entity projectile) {
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        worldIn.func_217378_a(player, 2001, pos, Block.func_196246_j(state));
    }

    public void func_176224_k(World worldIn, BlockPos pos) {
    }

    @Deprecated
    public boolean func_149659_a(Explosion explosionIn) {
        return true;
    }

    @Deprecated
    public boolean func_149740_M(BlockState state) {
        return false;
    }

    @Deprecated
    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return 0;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
    }

    public StateContainer<Block, BlockState> func_176194_O() {
        return this.field_176227_L;
    }

    protected final void func_180632_j(BlockState state) {
        this.field_196275_y = state;
    }

    public final BlockState func_176223_P() {
        return this.field_196275_y;
    }

    public OffsetType func_176218_Q() {
        return OffsetType.NONE;
    }

    @Deprecated
    public Vec3d func_190949_e(BlockState state, IBlockReader worldIn, BlockPos pos) {
        OffsetType block$offsettype = this.func_176218_Q();
        if (block$offsettype == OffsetType.NONE) {
            return Vec3d.field_186680_a;
        }
        long i = MathHelper.func_180187_c((int)pos.func_177958_n(), (int)0, (int)pos.func_177952_p());
        return new Vec3d(((double)((float)(i & 0xFL) / 15.0f) - 0.5) * 0.5, block$offsettype == OffsetType.XYZ ? ((double)((float)(i >> 4 & 0xFL) / 15.0f) - 1.0) * 0.2 : 0.0, ((double)((float)(i >> 8 & 0xFL) / 15.0f) - 0.5) * 0.5);
    }

    @Deprecated
    public SoundType func_220072_p(BlockState state) {
        return this.field_149762_H;
    }

    public Item func_199767_j() {
        if (this.field_220086_i == null) {
            this.field_220086_i = Item.func_150898_a(this);
        }
        return (Item)((Object)this.field_220086_i.delegate.get());
    }

    public boolean func_208619_r() {
        return this.field_208621_p;
    }

    public String toString() {
        return "Block{" + this.getRegistryName() + "}";
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
    }

    public float getSlipperiness(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity entity) {
        return this.field_149765_K;
    }

    @Nullable
    public ToolType getHarvestTool(BlockState state) {
        return this.harvestTool;
    }

    public int getHarvestLevel(BlockState state) {
        return this.harvestLevel;
    }

    public boolean canSustainPlant(BlockState state, IBlockReader world, BlockPos pos, Direction facing, IPlantable plantable) {
        BlockState plant = plantable.getPlant(world, pos.func_177972_a(facing));
        PlantType type = plantable.getPlantType(world, pos.func_177972_a(facing));
        if (plant.func_177230_c() == Blocks.field_150434_aF) {
            return this.getBlock() == Blocks.field_150434_aF || this.getBlock() == Blocks.field_150354_m || this.getBlock() == Blocks.field_196611_F;
        }
        if (plant.func_177230_c() == Blocks.field_196608_cF && this == Blocks.field_196608_cF) {
            return true;
        }
        if (plantable instanceof BushBlock && ((BushBlock)plantable).func_200014_a_(state, world, pos)) {
            return true;
        }
        switch (type) {
            case Desert: {
                return this.getBlock() == Blocks.field_150354_m || this.getBlock() == Blocks.field_150405_ch || this.getBlock() instanceof GlazedTerracottaBlock;
            }
            case Nether: {
                return this.getBlock() == Blocks.field_150425_aM;
            }
            case Crop: {
                return this.getBlock() == Blocks.field_150458_ak;
            }
            case Cave: {
                return Block.func_220056_d(state, world, pos, Direction.UP);
            }
            case Plains: {
                return this.getBlock() == Blocks.field_196658_i || Tags.Blocks.DIRT.func_199685_a_(this) || this.getBlock() == Blocks.field_150458_ak;
            }
            case Water: {
                return state.func_185904_a() == Material.field_151586_h;
            }
            case Beach: {
                boolean isBeach = this.getBlock() == Blocks.field_196658_i || Tags.Blocks.DIRT.func_199685_a_(this) || this.getBlock() == Blocks.field_150354_m;
                boolean hasWater = world.func_180495_p(pos.func_177974_f()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177976_e()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177978_c()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177968_d()).func_185904_a() == Material.field_151586_h;
                return isBeach && hasWater;
            }
        }
        return false;
    }

    public final Set<ResourceLocation> getTags() {
        return this.reverseTags.getTagNames();
    }

    static {
        ForgeHooks.setBlockToolSetter((block, tool, level) -> {
            block.harvestTool = tool;
            block.harvestLevel = level;
        });
    }

    public static final class RenderSideCacheKey {
        private final BlockState field_212164_a;
        private final BlockState field_212165_b;
        private final Direction field_212166_c;

        public RenderSideCacheKey(BlockState state, BlockState adjacentState, Direction side) {
            this.field_212164_a = state;
            this.field_212165_b = adjacentState;
            this.field_212166_c = side;
        }

        public boolean equals(Object p_equals_1_) {
            if (this == p_equals_1_) {
                return true;
            }
            if (!(p_equals_1_ instanceof RenderSideCacheKey)) {
                return false;
            }
            RenderSideCacheKey block$rendersidecachekey = (RenderSideCacheKey)p_equals_1_;
            return this.field_212164_a == block$rendersidecachekey.field_212164_a && this.field_212165_b == block$rendersidecachekey.field_212165_b && this.field_212166_c == block$rendersidecachekey.field_212166_c;
        }

        public int hashCode() {
            int i = ((Object)((Object)this.field_212164_a)).hashCode();
            i = 31 * i + ((Object)((Object)this.field_212165_b)).hashCode();
            i = 31 * i + this.field_212166_c.hashCode();
            return i;
        }
    }

    public static class Properties {
        private Material field_200953_a;
        private MaterialColor field_200954_b;
        private boolean field_200955_c = true;
        private SoundType field_200956_d = SoundType.field_185851_d;
        private int field_200957_e;
        private float field_200958_f;
        private float field_200959_g;
        private boolean field_200960_h;
        private float field_200961_i = 0.6f;
        private float field_226893_j_ = 1.0f;
        private float field_226894_k_ = 1.0f;
        private ResourceLocation field_222381_j;
        private boolean field_226895_m_ = true;
        private boolean field_208772_j;
        private int harvestLevel = -1;
        private ToolType harvestTool;
        private Supplier<ResourceLocation> lootTableSupplier;

        private Properties(Material materialIn, MaterialColor mapColorIn) {
            this.field_200953_a = materialIn;
            this.field_200954_b = mapColorIn;
        }

        public static Properties func_200945_a(Material materialIn) {
            return Properties.func_200949_a(materialIn, materialIn.func_151565_r());
        }

        public static Properties func_200952_a(Material materialIn, DyeColor color) {
            return Properties.func_200949_a(materialIn, color.func_196055_e());
        }

        public static Properties func_200949_a(Material materialIn, MaterialColor mapColorIn) {
            return new Properties(materialIn, mapColorIn);
        }

        public static Properties func_200950_a(Block blockIn) {
            Properties block$properties = new Properties(blockIn.field_149764_J, blockIn.field_181083_K);
            block$properties.field_200953_a = blockIn.field_149764_J;
            block$properties.field_200959_g = blockIn.field_149782_v;
            block$properties.field_200958_f = blockIn.field_149781_w;
            block$properties.field_200955_c = blockIn.field_196274_w;
            block$properties.field_200960_h = blockIn.field_149789_z;
            block$properties.field_200957_e = blockIn.field_149784_t;
            block$properties.field_200954_b = blockIn.field_181083_K;
            block$properties.field_200956_d = blockIn.field_149762_H;
            block$properties.field_200961_i = blockIn.func_208618_m();
            block$properties.field_226893_j_ = blockIn.func_226891_m_();
            block$properties.field_208772_j = blockIn.field_208621_p;
            block$properties.field_226895_m_ = blockIn.field_226888_j_;
            block$properties.harvestLevel = blockIn.harvestLevel;
            block$properties.harvestTool = blockIn.harvestTool;
            return block$properties;
        }

        public Properties func_200942_a() {
            this.field_200955_c = false;
            this.field_226895_m_ = false;
            return this;
        }

        public Properties func_226896_b_() {
            this.field_226895_m_ = false;
            return this;
        }

        public Properties func_200941_a(float slipperinessIn) {
            this.field_200961_i = slipperinessIn;
            return this;
        }

        public Properties func_226897_b_(float factor) {
            this.field_226893_j_ = factor;
            return this;
        }

        public Properties func_226898_c_(float factor) {
            this.field_226894_k_ = factor;
            return this;
        }

        public Properties func_200947_a(SoundType soundTypeIn) {
            this.field_200956_d = soundTypeIn;
            return this;
        }

        public Properties func_200951_a(int lightValueIn) {
            this.field_200957_e = lightValueIn;
            return this;
        }

        public Properties func_200948_a(float hardnessIn, float resistanceIn) {
            this.field_200959_g = hardnessIn;
            this.field_200958_f = Math.max(0.0f, resistanceIn);
            return this;
        }

        protected Properties func_200946_b() {
            return this.func_200943_b(0.0f);
        }

        public Properties func_200943_b(float hardnessAndResistance) {
            this.func_200948_a(hardnessAndResistance, hardnessAndResistance);
            return this;
        }

        public Properties func_200944_c() {
            this.field_200960_h = true;
            return this;
        }

        public Properties func_208770_d() {
            this.field_208772_j = true;
            return this;
        }

        public Properties harvestLevel(int harvestLevel) {
            this.harvestLevel = harvestLevel;
            return this;
        }

        public Properties harvestTool(ToolType harvestTool) {
            this.harvestTool = harvestTool;
            return this;
        }

        public Properties func_222380_e() {
            this.field_222381_j = LootTables.field_186419_a;
            return this;
        }

        public Properties func_222379_b(Block blockIn) {
            this.lootTableSupplier = () -> ((Block)((Object)((Object)blockIn.delegate.get()))).func_220068_i();
            return this;
        }
    }

    public static enum OffsetType {
        NONE,
        XZ,
        XYZ;

    }
}

