/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.elements;

import mcjty.theoneprobe.api.IElementNew;
import mcjty.theoneprobe.api.IIconStyle;
import mcjty.theoneprobe.apiimpl.TheOneProbeImp;
import mcjty.theoneprobe.apiimpl.client.ElementIconRender;
import mcjty.theoneprobe.apiimpl.styles.IconStyle;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class ElementIcon
implements IElementNew {
    private final ResourceLocation icon;
    private final int u;
    private final int v;
    private final int w;
    private final int h;
    private final IIconStyle style;

    public ElementIcon(ResourceLocation icon, int u, int v, int w, int h, IIconStyle style) {
        this.icon = icon;
        this.u = u;
        this.v = v;
        this.w = w;
        this.h = h;
        this.style = style;
    }

    public ElementIcon(PacketBuffer buf) {
        this.icon = buf.func_192575_l();
        this.u = buf.readInt();
        this.v = buf.readInt();
        this.w = buf.readInt();
        this.h = buf.readInt();
        this.style = new IconStyle().width(buf.readInt()).height(buf.readInt()).textureWidth(buf.readInt()).textureHeight(buf.readInt());
    }

    @Override
    public void render(int x, int y) {
        ElementIconRender.render(this.icon, x, y, this.w, this.h, this.u, this.v, this.style.getTextureWidth(), this.style.getTextureHeight());
    }

    @Override
    public int getWidth() {
        return this.style.getWidth();
    }

    @Override
    public int getHeight() {
        return this.style.getHeight();
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.func_192572_a(this.icon);
        buf.writeInt(this.u);
        buf.writeInt(this.v);
        buf.writeInt(this.w);
        buf.writeInt(this.h);
        buf.writeInt(this.style.getWidth());
        buf.writeInt(this.style.getHeight());
        buf.writeInt(this.style.getTextureWidth());
        buf.writeInt(this.style.getTextureHeight());
    }

    @Override
    public int getID() {
        return TheOneProbeImp.ELEMENT_ICON;
    }
}

