/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile.grid;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.grid.GridType;
import com.raoulvdberge.refinedstorage.api.network.grid.ICraftingGridListener;
import com.raoulvdberge.refinedstorage.api.network.grid.IGridTab;
import com.raoulvdberge.refinedstorage.api.network.grid.INetworkAwareGrid;
import com.raoulvdberge.refinedstorage.api.network.grid.handler.IFluidGridHandler;
import com.raoulvdberge.refinedstorage.api.network.grid.handler.IItemGridHandler;
import com.raoulvdberge.refinedstorage.api.storage.cache.IStorageCache;
import com.raoulvdberge.refinedstorage.api.storage.cache.IStorageCacheListener;
import com.raoulvdberge.refinedstorage.api.util.IFilter;
import com.raoulvdberge.refinedstorage.apiimpl.storage.cache.listener.FluidGridStorageCacheListener;
import com.raoulvdberge.refinedstorage.inventory.item.FilterItemHandler;
import com.raoulvdberge.refinedstorage.item.WirelessFluidGridItem;
import com.raoulvdberge.refinedstorage.network.grid.WirelessFluidGridSettingsUpdateMessage;
import com.raoulvdberge.refinedstorage.screen.BaseScreen;
import com.raoulvdberge.refinedstorage.screen.grid.GridScreen;
import com.raoulvdberge.refinedstorage.util.NetworkUtils;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class WirelessFluidGrid
implements INetworkAwareGrid {
    private ItemStack stack;
    @Nullable
    private final MinecraftServer server;
    private final DimensionType nodeDimension;
    private final BlockPos nodePos;
    private final int slotId;
    private int sortingType;
    private int sortingDirection;
    private int searchBoxMode;
    private int tabSelected;
    private int tabPage;
    private int size;
    private List<IFilter> filters = new ArrayList<IFilter>();
    private List<IGridTab> tabs = new ArrayList<IGridTab>();
    private FilterItemHandler filter = (FilterItemHandler)new FilterItemHandler(this.filters, this.tabs).addListener((handler, slot, reading) -> {
        if (!this.stack.func_77942_o()) {
            this.stack.func_77982_d(new CompoundNBT());
        }
        StackUtils.writeItems((IItemHandler)handler, 0, this.stack.func_77978_p());
    });

    public WirelessFluidGrid(ItemStack stack, @Nullable MinecraftServer server, int slotId) {
        this.stack = stack;
        this.server = server;
        this.nodeDimension = WirelessFluidGridItem.getDimension(stack);
        this.nodePos = new BlockPos(WirelessFluidGridItem.getX(stack), WirelessFluidGridItem.getY(stack), WirelessFluidGridItem.getZ(stack));
        this.slotId = slotId;
        this.sortingType = WirelessFluidGridItem.getSortingType(stack);
        this.sortingDirection = WirelessFluidGridItem.getSortingDirection(stack);
        this.searchBoxMode = WirelessFluidGridItem.getSearchBoxMode(stack);
        this.tabSelected = WirelessFluidGridItem.getTabSelected(stack);
        this.tabPage = WirelessFluidGridItem.getTabPage(stack);
        this.size = WirelessFluidGridItem.getSize(stack);
        if (stack.func_77942_o()) {
            StackUtils.readItems(this.filter, 0, stack.func_77978_p());
        }
    }

    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public GridType getGridType() {
        return GridType.FLUID;
    }

    @Override
    @Nullable
    public INetwork getNetwork() {
        ServerWorld world = DimensionManager.getWorld((MinecraftServer)this.server, (DimensionType)this.nodeDimension, (boolean)true, (boolean)true);
        if (world != null) {
            return NetworkUtils.getNetworkFromNode(NetworkUtils.getNodeFromTile(world.func_175625_s(this.nodePos)));
        }
        return null;
    }

    @Override
    public IStorageCacheListener createListener(ServerPlayerEntity player) {
        return new FluidGridStorageCacheListener(player, this.getNetwork());
    }

    @Override
    @Nullable
    public IStorageCache getStorageCache() {
        INetwork network = this.getNetwork();
        return network != null ? network.getFluidStorageCache() : null;
    }

    @Override
    @Nullable
    public IItemGridHandler getItemHandler() {
        return null;
    }

    @Override
    @Nullable
    public IFluidGridHandler getFluidHandler() {
        INetwork network = this.getNetwork();
        return network != null ? network.getFluidGridHandler() : null;
    }

    @Override
    public void addCraftingListener(ICraftingGridListener listener) {
    }

    @Override
    public void removeCraftingListener(ICraftingGridListener listener) {
    }

    @Override
    public ITextComponent getTitle() {
        return new TranslationTextComponent("gui.refinedstorage.fluid_grid", new Object[0]);
    }

    @Override
    public int getViewType() {
        return 0;
    }

    @Override
    public int getSortingType() {
        return this.sortingType;
    }

    @Override
    public int getSortingDirection() {
        return this.sortingDirection;
    }

    @Override
    public int getSearchBoxMode() {
        return this.searchBoxMode;
    }

    @Override
    public int getTabSelected() {
        return this.tabSelected;
    }

    @Override
    public int getTabPage() {
        return Math.min(this.tabPage, this.getTotalTabPages());
    }

    @Override
    public int getTotalTabPages() {
        return (int)Math.floor((float)Math.max(0, this.tabs.size() - 1) / 5.0f);
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void onViewTypeChanged(int type) {
    }

    @Override
    public void onSortingTypeChanged(int type) {
        RS.NETWORK_HANDLER.sendToServer(new WirelessFluidGridSettingsUpdateMessage(this.getSortingDirection(), type, this.getSearchBoxMode(), this.getSize(), this.getTabSelected(), this.getTabPage()));
        this.sortingType = type;
        BaseScreen.executeLater(GridScreen.class, grid -> grid.getView().sort());
    }

    @Override
    public void onSortingDirectionChanged(int direction) {
        RS.NETWORK_HANDLER.sendToServer(new WirelessFluidGridSettingsUpdateMessage(direction, this.getSortingType(), this.getSearchBoxMode(), this.getSize(), this.getTabSelected(), this.getTabPage()));
        this.sortingDirection = direction;
        BaseScreen.executeLater(GridScreen.class, grid -> grid.getView().sort());
    }

    @Override
    public void onSearchBoxModeChanged(int searchBoxMode) {
        RS.NETWORK_HANDLER.sendToServer(new WirelessFluidGridSettingsUpdateMessage(this.getSortingDirection(), this.getSortingType(), searchBoxMode, this.getSize(), this.getTabSelected(), this.getTabPage()));
        this.searchBoxMode = searchBoxMode;
    }

    @Override
    public void onSizeChanged(int size) {
        RS.NETWORK_HANDLER.sendToServer(new WirelessFluidGridSettingsUpdateMessage(this.getSortingDirection(), this.getSortingType(), this.getSearchBoxMode(), size, this.getTabSelected(), this.getTabPage()));
        this.size = size;
        BaseScreen.executeLater(GridScreen.class, BaseScreen::init);
    }

    @Override
    public void onTabSelectionChanged(int tab) {
        this.tabSelected = tab == this.tabSelected ? -1 : tab;
        RS.NETWORK_HANDLER.sendToServer(new WirelessFluidGridSettingsUpdateMessage(this.getSortingDirection(), this.getSortingType(), this.getSearchBoxMode(), this.getSize(), this.tabSelected, this.getTabPage()));
        BaseScreen.executeLater(GridScreen.class, grid -> grid.getView().sort());
    }

    @Override
    public void onTabPageChanged(int page) {
        if (page >= 0 && page <= this.getTotalTabPages()) {
            RS.NETWORK_HANDLER.sendToServer(new WirelessFluidGridSettingsUpdateMessage(this.getSortingDirection(), this.getSortingType(), this.getSearchBoxMode(), this.getSize(), this.getTabSelected(), page));
            this.tabPage = page;
        }
    }

    @Override
    public List<IFilter> getFilters() {
        return this.filters;
    }

    @Override
    public List<IGridTab> getTabs() {
        return this.tabs;
    }

    @Override
    public IItemHandlerModifiable getFilter() {
        return this.filter;
    }

    @Override
    public CraftingInventory getCraftingMatrix() {
        return null;
    }

    @Override
    public CraftResultInventory getCraftingResult() {
        return null;
    }

    @Override
    public void onCraftingMatrixChanged() {
    }

    @Override
    public void onCrafted(PlayerEntity player) {
    }

    @Override
    public void onClear(PlayerEntity player) {
    }

    @Override
    public void onCraftedShift(PlayerEntity player) {
    }

    @Override
    public void onRecipeTransfer(PlayerEntity player, ItemStack[][] recipe) {
    }

    @Override
    public boolean isGridActive() {
        return true;
    }

    @Override
    public int getSlotId() {
        return this.slotId;
    }

    @Override
    public void onClosed(PlayerEntity player) {
        INetwork network = this.getNetwork();
        if (network != null) {
            network.getNetworkItemManager().close(player);
        }
    }
}

