/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.block;

import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.api.storage.cache.InvalidateCause;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.ExternalStorageNetworkNode;
import com.raoulvdberge.refinedstorage.block.BlockDirection;
import com.raoulvdberge.refinedstorage.block.CableBlock;
import com.raoulvdberge.refinedstorage.container.ExternalStorageContainer;
import com.raoulvdberge.refinedstorage.container.factory.PositionalTileContainerProvider;
import com.raoulvdberge.refinedstorage.tile.ExternalStorageTile;
import com.raoulvdberge.refinedstorage.util.BlockUtils;
import com.raoulvdberge.refinedstorage.util.CollisionUtils;
import com.raoulvdberge.refinedstorage.util.NetworkUtils;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class ExternalStorageBlock
extends CableBlock {
    private static final VoxelShape HEAD_NORTH = VoxelShapes.func_197872_a((VoxelShape)ExternalStorageBlock.func_208617_a((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)2.0), (VoxelShape)HOLDER_NORTH);
    private static final VoxelShape HEAD_EAST = VoxelShapes.func_197872_a((VoxelShape)ExternalStorageBlock.func_208617_a((double)14.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0), (VoxelShape)HOLDER_EAST);
    private static final VoxelShape HEAD_SOUTH = VoxelShapes.func_197872_a((VoxelShape)ExternalStorageBlock.func_208617_a((double)3.0, (double)3.0, (double)14.0, (double)13.0, (double)13.0, (double)16.0), (VoxelShape)HOLDER_SOUTH);
    private static final VoxelShape HEAD_WEST = VoxelShapes.func_197872_a((VoxelShape)ExternalStorageBlock.func_208617_a((double)0.0, (double)3.0, (double)3.0, (double)2.0, (double)13.0, (double)13.0), (VoxelShape)HOLDER_WEST);
    private static final VoxelShape HEAD_UP = VoxelShapes.func_197872_a((VoxelShape)ExternalStorageBlock.func_208617_a((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), (VoxelShape)HOLDER_UP);
    private static final VoxelShape HEAD_DOWN = VoxelShapes.func_197872_a((VoxelShape)ExternalStorageBlock.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0), (VoxelShape)HOLDER_DOWN);

    public ExternalStorageBlock() {
        super(BlockUtils.DEFAULT_GLASS_PROPERTIES);
        this.setRegistryName("refinedstorage", "external_storage");
    }

    @Override
    public BlockDirection getDirection() {
        return BlockDirection.ANY;
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        VoxelShape shape = super.func_220053_a(state, world, pos, ctx);
        shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)this.getHeadShape(state));
        return shape;
    }

    private VoxelShape getHeadShape(BlockState state) {
        Direction direction = (Direction)state.func_177229_b((IProperty)this.getDirection().getProperty());
        if (direction == Direction.NORTH) {
            return HEAD_NORTH;
        }
        if (direction == Direction.EAST) {
            return HEAD_EAST;
        }
        if (direction == Direction.SOUTH) {
            return HEAD_SOUTH;
        }
        if (direction == Direction.WEST) {
            return HEAD_WEST;
        }
        if (direction == Direction.UP) {
            return HEAD_UP;
        }
        if (direction == Direction.DOWN) {
            return HEAD_DOWN;
        }
        return VoxelShapes.func_197880_a();
    }

    @Override
    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ExternalStorageTile();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (!world.field_72995_K && CollisionUtils.isInBounds(this.getHeadShape(state), pos, hit.func_216347_e())) {
            return NetworkUtils.attemptModify(world, pos, hit.func_216354_b(), player, () -> NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), new PositionalTileContainerProvider<ExternalStorageTile>((ITextComponent)new TranslationTextComponent("gui.refinedstorage.external_storage", new Object[0]), (tile, windowId, inventory, p) -> new ExternalStorageContainer((ExternalStorageTile)tile, player, windowId), pos), (BlockPos)pos));
        }
        return ActionResultType.SUCCESS;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        INetworkNode node;
        super.func_220069_a(state, world, pos, block, fromPos, isMoving);
        if (!world.field_72995_K && (node = NetworkUtils.getNodeFromTile(world.func_175625_s(pos))) instanceof ExternalStorageNetworkNode && node.getNetwork() != null && fromPos.equals((Object)pos.func_177972_a(((ExternalStorageNetworkNode)node).getDirection()))) {
            ((ExternalStorageNetworkNode)node).updateStorage(node.getNetwork(), InvalidateCause.NEIGHBOR_CHANGED);
        }
    }
}

