/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.oddities.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import vazkii.arl.util.ClientTicker;
import vazkii.quark.base.network.QuarkNetwork;
import vazkii.quark.base.network.message.MatrixEnchanterOperationMessage;
import vazkii.quark.oddities.client.screen.MatrixEnchantingPieceList;
import vazkii.quark.oddities.client.screen.MatrixEnchantingPlusButton;
import vazkii.quark.oddities.container.EnchantmentMatrix;
import vazkii.quark.oddities.container.MatrixEnchantingContainer;
import vazkii.quark.oddities.module.MatrixEnchantingModule;
import vazkii.quark.oddities.tile.MatrixEnchantingTableTileEntity;

public class MatrixEnchantingScreen
extends ContainerScreen<MatrixEnchantingContainer> {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("quark", "textures/misc/matrix_enchanting.png");
    protected final PlayerInventory playerInv;
    protected final MatrixEnchantingTableTileEntity enchanter;
    protected Button plusButton;
    protected MatrixEnchantingPieceList pieceList;
    protected EnchantmentMatrix.Piece hoveredPiece;
    protected int selectedPiece = -1;
    protected int gridHoverX;
    protected int gridHoverY;
    protected List<Integer> listPieces = null;

    public MatrixEnchantingScreen(MatrixEnchantingContainer container, PlayerInventory inventory, ITextComponent component) {
        super((Container)container, inventory, component);
        this.playerInv = inventory;
        this.enchanter = container.enchanter;
    }

    public void init(Minecraft mc, int x, int y) {
        super.init(mc, x, y);
        this.selectedPiece = -1;
        this.plusButton = new MatrixEnchantingPlusButton(this.field_147003_i + 86, this.field_147009_r + 63, this::add);
        this.addButton((Widget)this.plusButton);
        this.pieceList = new MatrixEnchantingPieceList(this, 28, 64, this.field_147009_r + 11, this.field_147009_r + 75, 22);
        this.pieceList.setLeftPos(this.field_147003_i + 139);
        this.children.add(this.pieceList);
        this.updateButtonStatus();
        this.pieceList.refresh();
    }

    public void tick() {
        super.tick();
        this.updateButtonStatus();
        if (this.enchanter.matrix == null) {
            this.selectedPiece = -1;
            this.pieceList.refresh();
        }
        if (this.enchanter.clientMatrixDirty) {
            this.pieceList.refresh();
            this.enchanter.clientMatrixDirty = false;
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        Minecraft mc = this.getMinecraft();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.func_110434_K().func_110577_a(BACKGROUND);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.blit(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.enchanter.charge > 0 && MatrixEnchantingModule.chargePerLapis > 0) {
            int maxHeight = 18;
            int barHeight = (int)((float)this.enchanter.charge / (float)MatrixEnchantingModule.chargePerLapis * (float)maxHeight);
            this.blit(i + 7, j + 32 + maxHeight - barHeight, 50, 176 + maxHeight - barHeight, 4, barHeight);
        }
        this.pieceList.render(mouseX, mouseY, partialTicks);
        if (this.enchanter.matrix != null && this.enchanter.matrix.canGeneratePiece(this.enchanter.bookshelfPower, this.enchanter.enchantability)) {
            int x = i + 74;
            int y = j + 58;
            int xpCost = this.enchanter.matrix.getNewPiecePrice();
            int xpMin = this.enchanter.matrix.getMinXpLevel(this.enchanter.bookshelfPower);
            boolean has = this.enchanter.matrix.validateXp((PlayerEntity)mc.field_71439_g, this.enchanter.bookshelfPower);
            this.blit(x, y, 0, this.field_147000_g, 10, 10);
            String text = String.valueOf(xpCost);
            if (!has && mc.field_71439_g.field_71068_ca < xpMin) {
                this.font.func_175063_a("!", (float)(x + 6), (float)(y + 3), 0xFF0000);
                text = I18n.func_135052_a((String)"quark.gui.enchanting.min", (Object[])new Object[]{xpMin});
            }
            this.font.func_211126_b(text, (float)((x -= this.font.func_78256_a(text) - 5) - 1), (float)(y += 3), 0);
            this.font.func_211126_b(text, (float)(x + 1), (float)y, 0);
            this.font.func_211126_b(text, (float)x, (float)(y + 1), 0);
            this.font.func_211126_b(text, (float)x, (float)(y - 1), 0);
            this.font.func_211126_b(text, (float)x, (float)y, has ? 0xC8FF8F : 0xFF8F8F);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.font.func_211126_b(this.enchanter.func_145748_c_().func_150261_e(), 12.0f, 5.0f, 0x404040);
        this.font.func_211126_b(this.playerInv.func_145748_c_().func_150261_e(), 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
        if (this.enchanter.matrix != null) {
            boolean needsRefresh = this.listPieces == null;
            this.listPieces = this.enchanter.matrix.benchedPieces;
            if (needsRefresh) {
                this.pieceList.refresh();
            }
            this.renderMatrixGrid(this.enchanter.matrix);
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        if (this.enchanter.matrix != null) {
            RenderHelper.func_74518_a();
        }
        if (this.hoveredPiece != null) {
            EnchantmentMatrix.Piece p;
            int max;
            LinkedList<String> tooltip = new LinkedList<String>();
            tooltip.add(TextFormatting.AQUA + this.hoveredPiece.enchant.func_200305_d(this.hoveredPiece.level).func_150254_d().replaceAll("\\u00A7.", ""));
            if (this.hoveredPiece.influence > 0) {
                tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"quark.gui.enchanting.influence", (Object[])new Object[]{(int)((double)this.hoveredPiece.influence * MatrixEnchantingModule.influencePower * 100.0)}));
            }
            if ((max = this.hoveredPiece.getMaxXP()) > 0) {
                tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"quark.gui.enchanting.upgrade", (Object[])new Object[]{this.hoveredPiece.xp, max}));
            }
            if (this.gridHoverX == -1) {
                tooltip.add("");
                tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"quark.gui.enchanting.left_click", (Object[])new Object[0]));
                tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"quark.gui.enchanting.right_click", (Object[])new Object[0]));
            } else if (this.selectedPiece != -1 && (p = this.getPiece(this.selectedPiece)) != null && p.enchant == this.hoveredPiece.enchant && this.hoveredPiece.level < this.hoveredPiece.enchant.func_77325_b()) {
                tooltip.add("");
                tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"quark.gui.enchanting.merge", (Object[])new Object[0]));
            }
            this.renderTooltip(tooltip, mouseX, mouseY);
        } else {
            this.func_191948_b(mouseX, mouseY);
        }
    }

    public void func_212927_b(double mouseX, double mouseY) {
        int gridMouseX = (int)(mouseX - (double)this.field_147003_i - 86.0);
        int gridMouseY = (int)(mouseY - (double)this.field_147009_r - 11.0);
        this.gridHoverX = gridMouseX < 0 ? -1 : gridMouseX / 10;
        int n = this.gridHoverY = gridMouseY < 0 ? -1 : gridMouseY / 10;
        if (this.gridHoverX < 0 || this.gridHoverX > 4 || this.gridHoverY < 0 || this.gridHoverY > 4) {
            this.gridHoverX = -1;
            this.gridHoverY = -1;
            this.hoveredPiece = null;
        } else if (this.enchanter.matrix != null) {
            int hover = this.enchanter.matrix.matrix[this.gridHoverX][this.gridHoverY];
            this.hoveredPiece = this.getPiece(hover);
        }
        super.func_212927_b(mouseX, mouseY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        if (this.enchanter.matrix == null) {
            return true;
        }
        if (mouseButton == 0 && this.gridHoverX != -1) {
            int hover = this.enchanter.matrix.matrix[this.gridHoverX][this.gridHoverY];
            if (this.selectedPiece != -1) {
                if (hover == -1) {
                    this.place(this.selectedPiece, this.gridHoverX, this.gridHoverY);
                } else {
                    this.merge(this.selectedPiece);
                }
            } else {
                this.remove(hover);
                if (!MatrixEnchantingScreen.hasShiftDown()) {
                    this.selectedPiece = hover;
                }
            }
        } else if (mouseButton == 1 && this.selectedPiece != -1) {
            this.rotate(this.selectedPiece);
        }
        return true;
    }

    protected void func_184098_a(Slot slotIn, int slotId, int mouseButton, ClickType type) {
        super.func_184098_a(slotIn, slotId, mouseButton, type);
    }

    private void renderMatrixGrid(EnchantmentMatrix matrix) {
        EnchantmentMatrix.Piece piece;
        Minecraft mc = this.getMinecraft();
        mc.func_110434_K().func_110577_a(BACKGROUND);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)86.0f, (float)11.0f, (float)0.0f);
        for (int i : matrix.placedPieces) {
            EnchantmentMatrix.Piece piece2 = this.getPiece(i);
            if (piece2 == null) continue;
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)(piece2.x * 10), (float)(piece2.y * 10), (float)0.0f);
            this.renderPiece(piece2, 1.0f);
            RenderSystem.popMatrix();
        }
        if (this.selectedPiece != -1 && this.gridHoverX != -1 && (piece = this.getPiece(this.selectedPiece)) != null && (this.hoveredPiece == null || piece.enchant != this.hoveredPiece.enchant || this.hoveredPiece.level >= this.hoveredPiece.enchant.func_77325_b())) {
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)(this.gridHoverX * 10), (float)(this.gridHoverY * 10), (float)0.0f);
            float a = 0.2f;
            if (matrix.canPlace(piece, this.gridHoverX, this.gridHoverY)) {
                a = (float)((Math.sin((double)ClientTicker.total * 0.2) + 1.0) * 0.4 + 0.4);
            }
            this.renderPiece(piece, a);
            RenderSystem.popMatrix();
        }
        if (this.hoveredPiece == null && this.gridHoverX != -1) {
            this.renderHover(this.gridHoverX, this.gridHoverY);
        }
        RenderSystem.popMatrix();
    }

    protected void renderPiece(EnchantmentMatrix.Piece piece, float a) {
        float r = (float)(piece.color >> 16 & 0xFF) / 255.0f;
        float g = (float)(piece.color >> 8 & 0xFF) / 255.0f;
        float b = (float)(piece.color & 0xFF) / 255.0f;
        boolean hovered = this.hoveredPiece == piece;
        for (int[] block : piece.blocks) {
            this.renderBlock(block[0], block[1], piece.type, r, g, b, a, hovered);
        }
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderBlock(int x, int y, int type, float r, float g, float b, float a, boolean hovered) {
        RenderSystem.color4f((float)r, (float)g, (float)b, (float)a);
        this.blit(x * 10, y * 10, 11 + type * 10, this.field_147000_g, 10, 10);
        if (hovered) {
            this.renderHover(x, y);
        }
    }

    private void renderHover(int x, int y) {
        MatrixEnchantingScreen.fill((int)(x * 10), (int)(y * 10), (int)(x * 10 + 10), (int)(y * 10 + 10), (int)0x66FFFFFF);
    }

    public void add(Button button) {
        this.send(0, 0, 0, 0);
    }

    public void place(int id, int x, int y) {
        this.send(1, id, x, y);
        this.selectedPiece = -1;
        this.click();
    }

    public void remove(int id) {
        this.send(2, id, 0, 0);
    }

    public void rotate(int id) {
        this.send(3, id, 0, 0);
    }

    public void merge(int id) {
        int hover = this.enchanter.matrix.matrix[this.gridHoverX][this.gridHoverY];
        EnchantmentMatrix.Piece p = this.getPiece(hover);
        EnchantmentMatrix.Piece p1 = this.getPiece(this.selectedPiece);
        if (p != null && p1 != null && p.enchant == p1.enchant && p.level < p.enchant.func_77325_b()) {
            this.send(4, hover, id, 0);
            this.selectedPiece = -1;
            this.click();
        }
    }

    private void send(int operation, int arg0, int arg1, int arg2) {
        System.out.println("send");
        MatrixEnchanterOperationMessage message = new MatrixEnchanterOperationMessage(operation, arg0, arg1, arg2);
        QuarkNetwork.sendToServer(message);
    }

    private void click() {
        this.getMinecraft().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }

    private void updateButtonStatus() {
        this.plusButton.active = this.enchanter.matrix != null && this.enchanter.charge > 0 && this.enchanter.matrix.validateXp((PlayerEntity)this.getMinecraft().field_71439_g, this.enchanter.bookshelfPower) && this.enchanter.matrix.canGeneratePiece(this.enchanter.bookshelfPower, this.enchanter.enchantability);
    }

    protected EnchantmentMatrix.Piece getPiece(int id) {
        EnchantmentMatrix matrix = this.enchanter.matrix;
        if (matrix != null) {
            return matrix.pieces.get(id);
        }
        return null;
    }
}

