/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.item;

import cofh.lib.capability.templates.AOEMiningItem;
import cofh.lib.util.constants.ToolTypes;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.PickaxeItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class HammerItem
extends PickaxeItem {
    private static float DEFAULT_ATTACK_DAMAGE = 4.0f;
    private static float DEFAULT_ATTACK_SPEED = -3.4f;
    private static int DEFAULT_BASE_AREA = 1;
    private int radius;

    public HammerItem(IItemTier tier, float attackDamageIn, float attackSpeedIn, int radius, Item.Properties builder) {
        super(tier, (int)attackDamageIn, attackSpeedIn, builder.addToolType(ToolTypes.HAMMER, tier.func_200925_d()));
        this.radius = radius;
    }

    public HammerItem(IItemTier tier, float attackDamageIn, float attackSpeedIn, Item.Properties builder) {
        this(tier, attackDamageIn, attackSpeedIn, DEFAULT_BASE_AREA, builder.addToolType(ToolTypes.HAMMER, tier.func_200925_d()));
    }

    public HammerItem(IItemTier tier, float attackDamageIn, Item.Properties builder) {
        this(tier, attackDamageIn, DEFAULT_ATTACK_SPEED, DEFAULT_BASE_AREA, builder.addToolType(ToolTypes.HAMMER, tier.func_200925_d()));
    }

    public HammerItem(IItemTier tier, Item.Properties builder) {
        this(tier, DEFAULT_ATTACK_DAMAGE, DEFAULT_ATTACK_SPEED, DEFAULT_BASE_AREA, builder.addToolType(ToolTypes.HAMMER, tier.func_200925_d()));
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return true;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new AOEMiningItem(this.radius, AOEMiningItem.Type.HAMMER);
    }
}

