/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.fluid;

import cofh.lib.fluid.IFluidContainerItem;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class FluidContainerItemWrapper
implements IFluidHandlerItem,
ICapabilityProvider {
    private final LazyOptional<IFluidHandlerItem> holder = LazyOptional.of(() -> this);
    final ItemStack container;
    final IFluidContainerItem item;

    public FluidContainerItemWrapper(ItemStack containerIn, IFluidContainerItem itemIn) {
        this.container = containerIn;
        this.item = itemIn;
    }

    @Nonnull
    public ItemStack getContainer() {
        return this.container;
    }

    public int getTanks() {
        return 1;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return this.item.getFluid(this.container);
    }

    public int getTankCapacity(int tank) {
        return this.item.getCapacity(this.container);
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack resource) {
        return this.item.isFluidValid(this.container, resource);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.item.fill(this.container, resource, action);
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!resource.isFluidEqual(this.getFluidInTank(0))) {
            return FluidStack.EMPTY;
        }
        return this.item.drain(this.container, resource.getAmount(), action);
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return this.item.drain(this.container, maxDrain, action);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY.orEmpty(cap, this.holder);
    }
}

