/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.block.crops;

import cofh.lib.block.crops.CropsBlockCoFH;
import cofh.lib.util.Utils;
import cofh.lib.util.constants.Constants;
import cofh.lib.util.helpers.MathHelper;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IntegerProperty;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.PlantType;

public class CropsBlockTall
extends CropsBlockCoFH {
    protected int splitAge = 4;
    protected int splitOffset = this.getSplitAge() + this.getMaximumAge() - this.getHarvestAge();

    public CropsBlockTall(Block.Properties builder, PlantType type, int growLight, float growMod) {
        super(builder, type, growLight, growMod);
    }

    public CropsBlockTall(Block.Properties builder, int growLight, float growMod) {
        super(builder, growLight, growMod);
    }

    public CropsBlockTall(Block.Properties builder) {
        super(builder);
    }

    protected boolean isTop(BlockState state) {
        return this.func_185527_x(state) > this.getMaximumAge();
    }

    protected int getSplitAge() {
        return this.splitAge;
    }

    protected int getSplitOffset() {
        return this.splitOffset;
    }

    @Override
    public IntegerProperty func_185524_e() {
        return Constants.AGE_TALL;
    }

    @Override
    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (!worldIn.isAreaLoaded(pos, 1) || this.isTop(state)) {
            return;
        }
        BlockPos above = pos.func_177984_a();
        if (worldIn.func_180495_p(above).func_177230_c() != this && !worldIn.func_175623_d(above)) {
            return;
        }
        if (worldIn.func_226659_b_(above, 0) >= this.growLight && !this.canHarvest(state)) {
            int age = this.func_185527_x(state);
            float growthChance = MathHelper.maxF(CropsBlockTall.func_180672_a((Block)this, (IBlockReader)worldIn, (BlockPos)pos) * this.growMod, 0.1f);
            if (ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (random.nextInt((int)(25.0f / growthChance) + 1) == 0 ? 1 : 0) != 0)) {
                int newAge = age + 1 > this.getMaximumAge() ? this.getHarvestAge() : age + 1;
                worldIn.func_180501_a(pos, this.func_185528_e(newAge), 2);
                if (newAge >= this.getSplitAge()) {
                    worldIn.func_180501_a(pos.func_177984_a(), this.func_185528_e(newAge + this.getSplitOffset()), 2);
                }
                ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
            }
        }
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return super.func_196260_a(state, worldIn, pos) && worldIn.func_175623_d(pos.func_177984_a());
    }

    @Override
    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        if (this.canHarvest(state)) {
            return;
        }
        if (this.isTop(state)) {
            int boost;
            int age = this.func_185527_x(state) - this.getSplitOffset();
            int newAge = age + (boost = this.func_185529_b((World)worldIn)) > this.getMaximumAge() ? this.getHarvestAge() : age + boost;
            worldIn.func_180501_a(pos, this.func_185528_e(newAge + this.getSplitOffset()), 2);
            worldIn.func_180501_a(pos.func_177977_b(), this.func_185528_e(newAge), 2);
        } else {
            int boost;
            BlockPos above = pos.func_177984_a();
            if (worldIn.func_180495_p(above).func_177230_c() != this && !worldIn.func_175623_d(above)) {
                return;
            }
            int age = this.func_185527_x(state);
            int newAge = age + (boost = this.func_185529_b((World)worldIn)) > this.getMaximumAge() ? this.getHarvestAge() : age + boost;
            worldIn.func_180501_a(pos, this.func_185528_e(newAge), 2);
            if (newAge >= this.getSplitAge()) {
                worldIn.func_180501_a(above, this.func_185528_e(newAge + this.getSplitOffset()), 2);
            }
        }
    }

    @Override
    public boolean canHarvest(BlockState state) {
        return this.func_185527_x(state) == this.getHarvestAge() + (this.isTop(state) ? this.getSplitOffset() : 0);
    }

    @Override
    public boolean harvest(World world, BlockPos pos, BlockState state, int fortune) {
        if (!this.canHarvest(state)) {
            return false;
        }
        if (Utils.isClientWorld(world)) {
            return true;
        }
        if (this.getPostHarvestAge() >= 0) {
            Utils.dropItemStackIntoWorldWithRandomness(new ItemStack(this.getCropItem(), 2 + MathHelper.binomialDist(fortune, 0.5)), world, pos);
            if (this.isTop(state)) {
                world.func_180501_a(pos, this.func_185528_e(this.getPostHarvestAge() + this.getSplitOffset()), 2);
                world.func_180501_a(pos.func_177977_b(), this.func_185528_e(this.getPostHarvestAge()), 2);
                Utils.dropItemStackIntoWorldWithRandomness(new ItemStack(this.getCropItem(), 2 + MathHelper.binomialDist(fortune, 0.5)), world, pos.func_177977_b());
            } else {
                world.func_180501_a(pos, this.func_185528_e(this.getPostHarvestAge()), 2);
                world.func_180501_a(pos.func_177984_a(), this.func_185528_e(this.getPostHarvestAge() + this.getSplitOffset()), 2);
                Utils.dropItemStackIntoWorldWithRandomness(new ItemStack(this.getCropItem(), 2 + MathHelper.binomialDist(fortune, 0.5)), world, pos.func_177984_a());
            }
        } else {
            world.func_175655_b(pos, true);
            world.func_175655_b(this.isTop(state) ? pos.func_177977_b() : pos.func_177984_a(), true);
        }
        return true;
    }
}

