/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.command;

import cofh.lib.util.Utils;
import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class SubCommandZap {
    public static int permissionLevel = 2;

    static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"zap").requires(source -> source.func_197034_c(permissionLevel))).executes(context -> SubCommandZap.zapEntities((CommandSource)context.getSource(), (Collection<? extends Entity>)ImmutableList.of((Object)((CommandSource)context.getSource()).func_197027_g())))).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197093_b()).executes(context -> SubCommandZap.zapEntities((CommandSource)context.getSource(), EntityArgument.func_197097_b((CommandContext)context, (String)"targets"))));
    }

    private static int zapEntities(CommandSource source, Collection<? extends Entity> targets) {
        int zappedEntities = 0;
        ServerPlayerEntity caster = source.func_197022_f() instanceof ServerPlayerEntity ? (ServerPlayerEntity)source.func_197022_f() : null;
        for (Entity entity : targets) {
            if (!SubCommandZap.createLightningBolt(entity.field_70170_p, entity.func_180425_c(), caster)) continue;
            ++zappedEntities;
        }
        if (targets.size() == 1) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.cofh.zap.success.single", new Object[]{targets.iterator().next().func_145748_c_()}), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.cofh.zap.success.multiple", new Object[]{targets.size()}), true);
        }
        return zappedEntities;
    }

    private static boolean createLightningBolt(World world, BlockPos pos, ServerPlayerEntity caster) {
        if (world.func_226660_f_(pos)) {
            if (Utils.isServerWorld(world)) {
                LightningBoltEntity bolt = new LightningBoltEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, false);
                bolt.func_204809_d(caster);
                ((ServerWorld)world).func_217468_a(bolt);
            }
            return true;
        }
        return false;
    }
}

