/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.gui.element;

import cofh.core.client.gui.IGuiAccess;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public abstract class ElementBase {
    public static final BooleanSupplier TRUE = () -> true;
    public static final BooleanSupplier FALSE = () -> false;
    protected BooleanSupplier enabled = TRUE;
    protected BooleanSupplier visible = TRUE;
    protected final IGuiAccess gui;
    protected ResourceLocation texture;
    protected String name = "";
    protected int posX;
    protected int posY;
    protected int width;
    protected int height;
    protected int texW = 256;
    protected int texH = 256;

    public ElementBase(IGuiAccess gui) {
        this.gui = gui;
    }

    public ElementBase(IGuiAccess gui, int posX, int posY) {
        this.gui = gui;
        this.posX = posX;
        this.posY = posY;
    }

    public ElementBase(IGuiAccess gui, int posX, int posY, int width, int height) {
        this.gui = gui;
        this.posX = posX;
        this.posY = posY;
        this.width = width;
        this.height = height;
    }

    public void drawBackground(int mouseX, int mouseY) {
    }

    public void drawForeground(int mouseX, int mouseY) {
    }

    public void addTooltip(List<ITextComponent> tooltipList, int mouseX, int mouseY) {
    }

    public void update(int mouseX, int mouseY) {
    }

    public boolean intersectsWith(double mouseX, double mouseY) {
        return mouseX >= (double)this.posX && mouseX < (double)(this.posX + this.width) && mouseY >= (double)this.posY && mouseY < (double)(this.posY + this.height);
    }

    public final ElementBase setEnabled(boolean enabled) {
        this.enabled = enabled ? TRUE : FALSE;
        return this;
    }

    public final ElementBase setVisible(boolean visible) {
        this.visible = visible ? TRUE : FALSE;
        return this;
    }

    public final ElementBase setEnabled(BooleanSupplier enabled) {
        this.enabled = enabled;
        return this;
    }

    public final ElementBase setVisible(BooleanSupplier visible) {
        this.visible = visible;
        return this;
    }

    public ElementBase setPosition(int posX, int posY) {
        this.posX = posX;
        this.posY = posY;
        return this;
    }

    public final ElementBase setSize(int width, int height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public final ElementBase setTexture(String texture, int texW, int texH) {
        this.texture = new ResourceLocation(texture);
        this.texW = texW;
        this.texH = texH;
        return this;
    }

    public final ElementBase setName(String name) {
        this.name = name;
        return this;
    }

    public final boolean enabled() {
        return this.enabled.getAsBoolean();
    }

    public final boolean visible() {
        return this.visible.getAsBoolean();
    }

    public final String name() {
        return this.name;
    }

    public int posX() {
        return this.posX;
    }

    public int posY() {
        return this.posY;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public final int guiTop() {
        return this.gui.getGuiTop();
    }

    public final int guiLeft() {
        return this.gui.getGuiLeft();
    }

    public void drawCenteredString(String text, int x, int y, int color) {
        this.gui.getFontRenderer().func_175063_a(text, (float)(x - (this.gui.getFontRenderer().func_78256_a(text) >> 1)), (float)y, color);
    }

    public void drawSizedRect(int x, int y, int width, int height, int color) {
        this.gui.drawSizedRect(x, y, width, height, color);
    }

    public void drawColoredModalRect(int x, int y, int width, int height, int color) {
        this.gui.drawColoredModalRect(x, y, width, height, color);
    }

    public void drawTexturedModalRect(int x, int y, int u, int v, int width, int height) {
        this.gui.drawTexturedModalRect(x, y, u, v, width, height, this.texW, this.texH);
    }

    public FontRenderer getFontRenderer() {
        return this.gui.getFontRenderer();
    }

    public boolean keyTyped(int keyCode, int scanCode) {
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        return false;
    }

    public void mouseReleased(double mouseX, double mouseY) {
    }

    public boolean mouseWheel(double mouseX, double mouseY, double movement) {
        return false;
    }
}

