/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.boss.dragon.EnderDragonPartEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChunkDataPacket;
import net.minecraft.network.play.server.SMountEntityPacket;
import net.minecraft.network.play.server.SSetPassengersPacket;
import net.minecraft.network.play.server.SUpdateChunkPositionPacket;
import net.minecraft.network.play.server.SUpdateLightPacket;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.CSVWriter;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.Util;
import net.minecraft.util.concurrent.DelegatedTaskExecutor;
import net.minecraft.util.concurrent.ITaskExecutor;
import net.minecraft.util.concurrent.ThreadTaskExecutor;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.palette.UpgradeData;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.world.GameRules;
import net.minecraft.world.TrackedEntity;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkPrimerWrapper;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.ChunkTaskPriorityQueue;
import net.minecraft.world.chunk.ChunkTaskPriorityQueueSorter;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.IChunkLightProvider;
import net.minecraft.world.chunk.PlayerGenerationTracker;
import net.minecraft.world.chunk.listener.IChunkStatusListener;
import net.minecraft.world.chunk.storage.ChunkLoader;
import net.minecraft.world.chunk.storage.ChunkSerializer;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.ServerWorldLightManager;
import net.minecraft.world.server.TicketManager;
import net.minecraft.world.server.TicketType;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.SessionLockException;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkManager
extends ChunkLoader
implements ChunkHolder.IPlayerProvider {
    private static final Logger field_219250_d = LogManager.getLogger();
    public static final int field_219249_a = 33 + ChunkStatus.func_222600_b();
    private final Long2ObjectLinkedOpenHashMap<ChunkHolder> field_219251_e = new Long2ObjectLinkedOpenHashMap();
    private volatile Long2ObjectLinkedOpenHashMap<ChunkHolder> field_219252_f = this.field_219251_e.clone();
    private final Long2ObjectLinkedOpenHashMap<ChunkHolder> field_219253_g = new Long2ObjectLinkedOpenHashMap();
    private final LongSet field_219254_h = new LongOpenHashSet();
    private final ServerWorld field_219255_i;
    private final ServerWorldLightManager field_219256_j;
    private final ThreadTaskExecutor<Runnable> field_219257_k;
    private final ChunkGenerator<?> field_219258_l;
    private final Supplier<DimensionSavedDataManager> field_219259_m;
    private final PointOfInterestManager field_219260_n;
    private final LongSet field_219261_o = new LongOpenHashSet();
    private boolean field_219262_p;
    private final ChunkTaskPriorityQueueSorter field_219263_q;
    private final ITaskExecutor<ChunkTaskPriorityQueueSorter.FunctionEntry<Runnable>> field_219264_r;
    private final ITaskExecutor<ChunkTaskPriorityQueueSorter.FunctionEntry<Runnable>> field_219265_s;
    private final IChunkStatusListener field_219266_t;
    private final ProxyTicketManager field_219267_u;
    private final AtomicInteger field_219268_v = new AtomicInteger();
    private final TemplateManager field_219269_w;
    private final File field_219270_x;
    private final PlayerGenerationTracker field_219271_y = new PlayerGenerationTracker();
    private final Int2ObjectMap<EntityTracker> field_219272_z = new Int2ObjectOpenHashMap();
    private final Queue<Runnable> field_223181_A = Queues.newConcurrentLinkedQueue();
    private int field_219247_A;

    public ChunkManager(ServerWorld serverWorld, File file, DataFixer dataFixer, TemplateManager templateManager, Executor executor, ThreadTaskExecutor<Runnable> threadTaskExecutor, IChunkLightProvider iChunkLightProvider, ChunkGenerator<?> chunkGenerator, IChunkStatusListener iChunkStatusListener, Supplier<DimensionSavedDataManager> supplier, int n) {
        super(new File(serverWorld.func_201675_m().func_186058_p().func_212679_a(file), "region"), dataFixer);
        this.field_219269_w = templateManager;
        this.field_219270_x = serverWorld.func_201675_m().func_186058_p().func_212679_a(file);
        this.field_219255_i = serverWorld;
        this.field_219258_l = chunkGenerator;
        this.field_219257_k = threadTaskExecutor;
        DelegatedTaskExecutor<Runnable> delegatedTaskExecutor = DelegatedTaskExecutor.func_213144_a(executor, "worldgen");
        ITaskExecutor<Runnable> \u26032 = ITaskExecutor.func_213140_a("main", threadTaskExecutor::func_212871_a_);
        this.field_219266_t = iChunkStatusListener;
        \u2603 = DelegatedTaskExecutor.func_213144_a(executor, "light");
        this.field_219263_q = new ChunkTaskPriorityQueueSorter((List<ITaskExecutor<?>>)ImmutableList.of(delegatedTaskExecutor, \u26032, \u2603), executor, Integer.MAX_VALUE);
        this.field_219264_r = this.field_219263_q.func_219087_a(delegatedTaskExecutor, false);
        this.field_219265_s = this.field_219263_q.func_219087_a(\u26032, false);
        this.field_219256_j = new ServerWorldLightManager(iChunkLightProvider, this, this.field_219255_i.func_201675_m().func_191066_m(), \u2603, this.field_219263_q.func_219087_a(\u2603, false));
        this.field_219267_u = new ProxyTicketManager(executor, threadTaskExecutor);
        this.field_219259_m = supplier;
        this.field_219260_n = new PointOfInterestManager(new File(this.field_219270_x, "poi"), dataFixer);
        this.func_219175_a(n);
    }

    private static double func_219217_a(ChunkPos chunkPos, Entity entity) {
        double d = chunkPos.field_77276_a * 16 + 8;
        \u2603 = chunkPos.field_77275_b * 16 + 8;
        \u2603 = d - entity.func_226277_ct_();
        \u2603 = \u2603 - entity.func_226281_cx_();
        return \u2603 * \u2603 + \u2603 * \u2603;
    }

    private static int func_219215_b(ChunkPos chunkPos, ServerPlayerEntity serverPlayerEntity, boolean bl) {
        int \u26033;
        int \u26032;
        if (bl) {
            SectionPos sectionPos = serverPlayerEntity.func_213842_M();
            \u26032 = sectionPos.func_218149_a();
            \u26033 = sectionPos.func_218148_c();
        } else {
            \u26032 = MathHelper.func_76128_c(serverPlayerEntity.func_226277_ct_() / 16.0);
            \u26033 = MathHelper.func_76128_c(serverPlayerEntity.func_226281_cx_() / 16.0);
        }
        return ChunkManager.func_219232_a(chunkPos, \u26032, \u26033);
    }

    private static int func_219232_a(ChunkPos chunkPos, int n, int n2) {
        \u2603 = chunkPos.field_77276_a - n;
        \u2603 = chunkPos.field_77275_b - n2;
        return Math.max(Math.abs(\u2603), Math.abs(\u2603));
    }

    protected ServerWorldLightManager func_219207_a() {
        return this.field_219256_j;
    }

    @Nullable
    protected ChunkHolder func_219220_a(long l) {
        return (ChunkHolder)this.field_219251_e.get(l);
    }

    @Nullable
    protected ChunkHolder func_219219_b(long l) {
        return (ChunkHolder)this.field_219252_f.get(l);
    }

    protected IntSupplier func_219191_c(long l) {
        return () -> {
            ChunkHolder chunkHolder = this.func_219219_b(l);
            if (chunkHolder == null) {
                return ChunkTaskPriorityQueue.field_219419_a - 1;
            }
            return Math.min(chunkHolder.func_219281_j(), ChunkTaskPriorityQueue.field_219419_a - 1);
        };
    }

    private CompletableFuture<Either<List<IChunk>, ChunkHolder.IChunkLoadingError>> func_219236_a(ChunkPos chunkPos, final int n, IntFunction<ChunkStatus> intFunction) {
        ArrayList arrayList = Lists.newArrayList();
        final int \u26032 = chunkPos.field_77276_a;
        final int \u26033 = chunkPos.field_77275_b;
        for (int i = -n; i <= n; ++i) {
            for (\u2603 = -n; \u2603 <= n; ++\u2603) {
                \u2603 = Math.max(Math.abs(\u2603), Math.abs(i));
                final ChunkPos chunkPos2 = new ChunkPos(\u26032 + \u2603, \u26033 + i);
                long \u26034 = chunkPos2.func_201841_a();
                ChunkHolder \u26035 = this.func_219220_a(\u26034);
                if (\u26035 == null) {
                    return CompletableFuture.completedFuture(Either.right((Object)new ChunkHolder.IChunkLoadingError(){

                        public String toString() {
                            return "Unloaded " + chunkPos2.toString();
                        }
                    }));
                }
                ChunkStatus \u26036 = intFunction.apply(\u2603);
                CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>> \u26037 = \u26035.func_219276_a(\u26036, this);
                arrayList.add(\u26037);
            }
        }
        CompletableFuture completableFuture = Util.func_215079_b(arrayList);
        return completableFuture.thenApply(list -> {
            ArrayList arrayList = Lists.newArrayList();
            int \u26032 = 0;
            for (final Either either : list) {
                Optional optional = either.left();
                if (!optional.isPresent()) {
                    final int n4 = \u26032;
                    return Either.right((Object)new ChunkHolder.IChunkLoadingError(){

                        public String toString() {
                            return "Unloaded " + new ChunkPos(\u26032 + n4 % (n * 2 + 1), \u26033 + n4 / (n * 2 + 1)) + " " + ((ChunkHolder.IChunkLoadingError)either.right().get()).toString();
                        }
                    });
                }
                arrayList.add(optional.get());
                ++\u26032;
            }
            return Either.left((Object)arrayList);
        });
    }

    public CompletableFuture<Either<Chunk, ChunkHolder.IChunkLoadingError>> func_219188_b(ChunkPos chunkPos) {
        return this.func_219236_a(chunkPos, 2, n -> ChunkStatus.field_222617_m).thenApplyAsync(either -> either.mapLeft(list -> (Chunk)list.get(list.size() / 2)), (Executor)this.field_219257_k);
    }

    @Nullable
    private ChunkHolder func_219213_a(long l, int n, @Nullable ChunkHolder chunkHolder2, int n2) {
        ChunkHolder chunkHolder2;
        if (n2 > field_219249_a && n > field_219249_a) {
            return chunkHolder2;
        }
        if (chunkHolder2 != null) {
            chunkHolder2.func_219292_a(n);
        }
        if (chunkHolder2 != null) {
            if (n > field_219249_a) {
                this.field_219261_o.add(l);
            } else {
                this.field_219261_o.remove(l);
            }
        }
        if (n <= field_219249_a && chunkHolder2 == null) {
            chunkHolder2 = (ChunkHolder)this.field_219253_g.remove(l);
            if (chunkHolder2 != null) {
                chunkHolder2.func_219292_a(n);
            } else {
                chunkHolder2 = new ChunkHolder(new ChunkPos(l), n, this.field_219256_j, this.field_219263_q, this);
            }
            this.field_219251_e.put(l, (Object)chunkHolder2);
            this.field_219262_p = true;
        }
        return chunkHolder2;
    }

    @Override
    public void close() throws IOException {
        try {
            this.field_219263_q.close();
            this.field_219260_n.close();
        }
        finally {
            super.close();
        }
    }

    protected void func_219177_a(boolean bl) {
        if (bl) {
            List list = this.field_219252_f.values().stream().filter(ChunkHolder::func_219289_k).peek(ChunkHolder::func_219303_l).collect(Collectors.toList());
            MutableBoolean \u26032 = new MutableBoolean();
            do {
                \u26032.setFalse();
                list.stream().map(chunkHolder -> {
                    CompletableFuture<IChunk> completableFuture;
                    do {
                        completableFuture = chunkHolder.func_219302_f();
                        this.field_219257_k.func_213161_c(completableFuture::isDone);
                    } while (completableFuture != chunkHolder.func_219302_f());
                    return completableFuture.join();
                }).filter(iChunk -> iChunk instanceof ChunkPrimerWrapper || iChunk instanceof Chunk).filter(this::func_219229_a).forEach(iChunk -> \u26032.setTrue());
            } while (\u26032.isTrue());
            this.func_223155_b(() -> true);
            this.func_227079_i_();
            field_219250_d.info("ThreadedAnvilChunkStorage ({}): All chunks are saved", (Object)this.field_219270_x.getName());
        } else {
            this.field_219252_f.values().stream().filter(ChunkHolder::func_219289_k).forEach(chunkHolder -> {
                IChunk iChunk = chunkHolder.func_219302_f().getNow(null);
                if (iChunk instanceof ChunkPrimerWrapper || iChunk instanceof Chunk) {
                    this.func_219229_a(iChunk);
                    chunkHolder.func_219303_l();
                }
            });
        }
    }

    protected void func_219204_a(BooleanSupplier booleanSupplier) {
        IProfiler iProfiler = this.field_219255_i.func_217381_Z();
        iProfiler.func_76320_a("poi");
        this.field_219260_n.func_219115_a(booleanSupplier);
        iProfiler.func_219895_b("chunk_unload");
        if (!this.field_219255_i.func_217402_u()) {
            this.func_223155_b(booleanSupplier);
        }
        iProfiler.func_76319_b();
    }

    private void func_223155_b(BooleanSupplier booleanSupplier) {
        LongIterator longIterator = this.field_219261_o.iterator();
        int \u26032 = 0;
        while (longIterator.hasNext() && (booleanSupplier.getAsBoolean() || \u26032 < 200 || this.field_219261_o.size() > 2000)) {
            long l = longIterator.nextLong();
            ChunkHolder \u26033 = (ChunkHolder)this.field_219251_e.remove(l);
            if (\u26033 != null) {
                this.field_219253_g.put(l, (Object)\u26033);
                this.field_219262_p = true;
                ++\u26032;
                this.func_219212_a(l, \u26033);
            }
            longIterator.remove();
        }
        while ((booleanSupplier.getAsBoolean() || this.field_223181_A.size() > 2000) && (\u2603 = this.field_223181_A.poll()) != null) {
            \u2603.run();
        }
    }

    private void func_219212_a(long l, ChunkHolder chunkHolder) {
        CompletableFuture<IChunk> completableFuture = chunkHolder.func_219302_f();
        ((CompletableFuture)completableFuture.thenAcceptAsync(iChunk2 -> {
            CompletableFuture<IChunk> completableFuture2 = chunkHolder.func_219302_f();
            if (completableFuture2 != completableFuture) {
                this.func_219212_a(l, chunkHolder);
                return;
            }
            if (this.field_219253_g.remove(l, (Object)chunkHolder) && iChunk2 != null) {
                IChunk iChunk2;
                if (iChunk2 instanceof Chunk) {
                    ((Chunk)iChunk2).func_177417_c(false);
                }
                this.func_219229_a((IChunk)iChunk2);
                if (this.field_219254_h.remove(l) && iChunk2 instanceof Chunk) {
                    Chunk chunk = (Chunk)iChunk2;
                    this.field_219255_i.func_217466_a(chunk);
                }
                this.field_219256_j.func_215581_a(iChunk2.func_76632_l());
                this.field_219256_j.func_215588_z_();
                this.field_219266_t.func_219508_a(iChunk2.func_76632_l(), null);
            }
        }, this.field_223181_A::add)).whenComplete((void_, throwable) -> {
            if (throwable != null) {
                field_219250_d.error("Failed to save chunk " + chunkHolder.func_219277_h(), throwable);
            }
        });
    }

    protected boolean func_219245_b() {
        if (!this.field_219262_p) {
            return false;
        }
        this.field_219252_f = this.field_219251_e.clone();
        this.field_219262_p = false;
        return true;
    }

    public CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>> func_219244_a(ChunkHolder chunkHolder, ChunkStatus chunkStatus) {
        ChunkPos chunkPos = chunkHolder.func_219277_h();
        if (chunkStatus == ChunkStatus.field_223226_a_) {
            return this.func_223172_f(chunkPos);
        }
        CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>> \u26032 = chunkHolder.func_219276_a(chunkStatus.func_222593_e(), this);
        return \u26032.thenComposeAsync(either -> {
            ChunkHolder chunkHolder2;
            Optional optional = either.left();
            if (!optional.isPresent()) {
                return CompletableFuture.completedFuture(either);
            }
            if (chunkStatus == ChunkStatus.field_222614_j) {
                this.field_219267_u.func_219356_a(TicketType.field_219492_e, chunkPos, 33 + ChunkStatus.func_222599_a(ChunkStatus.field_222613_i), chunkPos);
            }
            if ((\u2603 = (IChunk)optional.get()).func_201589_g().func_209003_a(chunkStatus)) {
                CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>> completableFuture = chunkStatus == ChunkStatus.field_222614_j ? this.func_223156_b(chunkHolder, chunkStatus) : chunkStatus.func_223201_a(this.field_219255_i, this.field_219269_w, this.field_219256_j, iChunk -> this.func_219200_b(chunkHolder), \u2603);
                this.field_219266_t.func_219508_a(chunkPos, chunkStatus);
                return completableFuture;
            }
            return this.func_223156_b(chunkHolder, chunkStatus);
        }, (Executor)this.field_219257_k);
    }

    private CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>> func_223172_f(ChunkPos chunkPos) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                this.field_219255_i.func_217381_Z().func_230035_c_("chunkLoad");
                CompoundNBT compoundNBT = this.func_219178_f(chunkPos);
                if (compoundNBT != null) {
                    ChunkPos chunkPos2;
                    boolean bl = \u2603 = compoundNBT.func_150297_b("Level", 10) && compoundNBT.func_74775_l("Level").func_150297_b("Status", 8);
                    if (\u2603) {
                        ChunkPrimer chunkPrimer = ChunkSerializer.func_222656_a(this.field_219255_i, this.field_219269_w, this.field_219260_n, chunkPos, compoundNBT);
                        chunkPrimer.func_177432_b(this.field_219255_i.func_82737_E());
                        return Either.left((Object)chunkPrimer);
                    }
                    field_219250_d.error("Chunk file at {} is missing level data, skipping", (Object)chunkPos);
                }
            }
            catch (ReportedException reportedException) {
                Throwable throwable = reportedException.getCause();
                if (throwable instanceof IOException) {
                    field_219250_d.error("Couldn't load chunk {}", (Object)chunkPos, (Object)throwable);
                }
                throw reportedException;
            }
            catch (Exception exception) {
                field_219250_d.error("Couldn't load chunk {}", (Object)chunkPos, (Object)exception);
            }
            return Either.left((Object)new ChunkPrimer(chunkPos, UpgradeData.field_196994_a));
        }, this.field_219257_k);
    }

    private CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>> func_223156_b(ChunkHolder chunkHolder, ChunkStatus chunkStatus) {
        ChunkPos chunkPos = chunkHolder.func_219277_h();
        CompletableFuture<Either<List<IChunk>, ChunkHolder.IChunkLoadingError>> \u26032 = this.func_219236_a(chunkPos, chunkStatus.func_202128_c(), n -> this.func_219205_a(chunkStatus, n));
        this.field_219255_i.func_217381_Z().func_230036_c_(() -> "chunkGenerate " + chunkStatus.func_222596_d());
        return \u26032.thenComposeAsync(either -> (CompletableFuture)either.map(list -> {
            try {
                CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>> completableFuture = chunkStatus.func_223198_a(this.field_219255_i, this.field_219258_l, this.field_219269_w, this.field_219256_j, iChunk -> this.func_219200_b(chunkHolder), (List<IChunk>)list);
                this.field_219266_t.func_219508_a(chunkPos, chunkStatus);
                return completableFuture;
            }
            catch (Exception exception) {
                CrashReport crashReport = CrashReport.func_85055_a(exception, "Exception generating new chunk");
                CrashReportCategory \u26032 = crashReport.func_85058_a("Chunk to be generated");
                \u26032.func_71507_a("Location", String.format("%d,%d", chunkPos.field_77276_a, chunkPos.field_77275_b));
                \u26032.func_71507_a("Position hash", ChunkPos.func_77272_a(chunkPos.field_77276_a, chunkPos.field_77275_b));
                \u26032.func_71507_a("Generator", this.field_219258_l);
                throw new ReportedException(crashReport);
            }
        }, iChunkLoadingError -> {
            this.func_219209_c(chunkPos);
            return CompletableFuture.completedFuture(Either.right((Object)iChunkLoadingError));
        }), runnable -> this.field_219264_r.func_212871_a_(ChunkTaskPriorityQueueSorter.func_219081_a(chunkHolder, runnable)));
    }

    protected void func_219209_c(ChunkPos chunkPos) {
        this.field_219257_k.func_212871_a_(Util.func_215075_a(() -> this.field_219267_u.func_219345_b(TicketType.field_219492_e, chunkPos, 33 + ChunkStatus.func_222599_a(ChunkStatus.field_222613_i), chunkPos), () -> "release light ticket " + chunkPos));
    }

    private ChunkStatus func_219205_a(ChunkStatus chunkStatus, int n) {
        ChunkStatus chunkStatus2 = n == 0 ? chunkStatus.func_222593_e() : ChunkStatus.func_222581_a(ChunkStatus.func_222599_a(chunkStatus) + n);
        return chunkStatus2;
    }

    private CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>> func_219200_b(ChunkHolder chunkHolder) {
        CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>> completableFuture = chunkHolder.func_219301_a(ChunkStatus.field_222617_m.func_222593_e());
        return completableFuture.thenApplyAsync(either -> {
            ChunkStatus chunkStatus = ChunkHolder.func_219278_b(chunkHolder.func_219299_i());
            if (!chunkStatus.func_209003_a(ChunkStatus.field_222617_m)) {
                return ChunkHolder.field_219306_a;
            }
            return either.mapLeft(iChunk2 -> {
                Chunk \u26032;
                ChunkPos chunkPos = chunkHolder.func_219277_h();
                if (iChunk2 instanceof ChunkPrimerWrapper) {
                    \u26032 = ((ChunkPrimerWrapper)iChunk2).func_217336_u();
                } else {
                    IChunk iChunk2;
                    \u26032 = new Chunk(this.field_219255_i, (ChunkPrimer)iChunk2);
                    chunkHolder.func_219294_a(new ChunkPrimerWrapper(\u26032));
                }
                \u26032.func_217314_a(() -> ChunkHolder.func_219286_c(chunkHolder.func_219299_i()));
                \u26032.func_217318_w();
                if (this.field_219254_h.add(chunkPos.func_201841_a())) {
                    \u26032.func_177417_c(true);
                    this.field_219255_i.func_147448_a(\u26032.func_177434_r().values());
                    Iterable \u26033 = null;
                    for (ClassInheritanceMultiMap<Entity> classInheritanceMultiMap : \u26032.func_177429_s()) {
                        for (Entity entity : classInheritanceMultiMap) {
                            if (entity instanceof PlayerEntity || this.field_219255_i.func_217440_f(entity)) continue;
                            if (\u26033 == null) {
                                \u26033 = Lists.newArrayList((Object[])new Entity[]{entity});
                                continue;
                            }
                            \u26033.add(entity);
                        }
                    }
                    if (\u26033 != null) {
                        \u26033.forEach(\u26032::func_76622_b);
                    }
                }
                return \u26032;
            });
        }, runnable -> this.field_219265_s.func_212871_a_(ChunkTaskPriorityQueueSorter.func_219069_a(runnable, chunkHolder.func_219277_h().func_201841_a(), chunkHolder::func_219299_i)));
    }

    public CompletableFuture<Either<Chunk, ChunkHolder.IChunkLoadingError>> func_219179_a(ChunkHolder chunkHolder) {
        ChunkPos chunkPos = chunkHolder.func_219277_h();
        CompletableFuture<Either<List<IChunk>, ChunkHolder.IChunkLoadingError>> \u26032 = this.func_219236_a(chunkPos, 1, n -> ChunkStatus.field_222617_m);
        CompletionStage \u26033 = \u26032.thenApplyAsync(either -> either.flatMap(list -> {
            Chunk chunk = (Chunk)list.get(list.size() / 2);
            chunk.func_201595_A();
            return Either.left((Object)chunk);
        }), runnable -> this.field_219265_s.func_212871_a_(ChunkTaskPriorityQueueSorter.func_219081_a(chunkHolder, runnable)));
        ((CompletableFuture)\u26033).thenAcceptAsync(either -> either.mapLeft(chunk -> {
            this.field_219268_v.getAndIncrement();
            IPacket[] iPacketArray = new IPacket[2];
            this.func_219097_a(chunkPos, false).forEach(serverPlayerEntity -> this.func_219180_a((ServerPlayerEntity)serverPlayerEntity, iPacketArray, (Chunk)chunk));
            return Either.left((Object)chunk);
        }), runnable -> this.field_219265_s.func_212871_a_(ChunkTaskPriorityQueueSorter.func_219081_a(chunkHolder, runnable)));
        return \u26033;
    }

    public CompletableFuture<Either<Chunk, ChunkHolder.IChunkLoadingError>> func_222961_b(ChunkHolder chunkHolder) {
        return chunkHolder.func_219276_a(ChunkStatus.field_222617_m, this).thenApplyAsync(either -> either.mapLeft(iChunk -> {
            Chunk chunk = (Chunk)iChunk;
            chunk.func_222879_B();
            return chunk;
        }), runnable -> this.field_219265_s.func_212871_a_(ChunkTaskPriorityQueueSorter.func_219081_a(chunkHolder, runnable)));
    }

    public int func_219174_c() {
        return this.field_219268_v.get();
    }

    private boolean func_219229_a(IChunk iChunk2) {
        this.field_219260_n.func_219112_a(iChunk2.func_76632_l());
        if (!iChunk2.func_201593_f()) {
            return false;
        }
        try {
            this.field_219255_i.func_217437_v();
        }
        catch (SessionLockException sessionLockException) {
            field_219250_d.error("Couldn't save chunk; already in use by another instance of Minecraft?", (Throwable)sessionLockException);
            return false;
        }
        iChunk2.func_177432_b(this.field_219255_i.func_82737_E());
        iChunk2.func_177427_f(false);
        ChunkPos chunkPos = iChunk2.func_76632_l();
        try {
            IChunk iChunk2;
            CompoundNBT \u26032;
            ChunkStatus chunkStatus = iChunk2.func_201589_g();
            if (chunkStatus.func_202129_d() != ChunkStatus.Type.LEVELCHUNK) {
                \u26032 = this.func_219178_f(chunkPos);
                if (\u26032 != null && ChunkSerializer.func_222651_a(\u26032) == ChunkStatus.Type.LEVELCHUNK) {
                    return false;
                }
                if (chunkStatus == ChunkStatus.field_223226_a_ && iChunk2.func_201609_c().values().stream().noneMatch(StructureStart::func_75069_d)) {
                    return false;
                }
            }
            this.field_219255_i.func_217381_Z().func_230035_c_("chunkSave");
            \u26032 = ChunkSerializer.func_222645_a(this.field_219255_i, iChunk2);
            this.func_219100_a(chunkPos, \u26032);
            return true;
        }
        catch (Exception exception) {
            field_219250_d.error("Failed to save chunk {},{}", (Object)chunkPos.field_77276_a, (Object)chunkPos.field_77275_b, (Object)exception);
            return false;
        }
    }

    protected void func_219175_a(int n) {
        \u2603 = MathHelper.func_76125_a(n + 1, 3, 33);
        if (\u2603 != this.field_219247_A) {
            \u2603 = this.field_219247_A;
            this.field_219247_A = \u2603;
            this.field_219267_u.func_219354_b(this.field_219247_A);
            for (ChunkHolder chunkHolder : this.field_219251_e.values()) {
                ChunkPos chunkPos = chunkHolder.func_219277_h();
                IPacket[] \u26032 = new IPacket[2];
                this.func_219097_a(chunkPos, false).forEach(serverPlayerEntity -> {
                    int n2 = ChunkManager.func_219215_b(chunkPos, serverPlayerEntity, true);
                    boolean \u26032 = n2 <= \u2603;
                    boolean \u26033 = n2 <= this.field_219247_A;
                    this.func_219199_a((ServerPlayerEntity)serverPlayerEntity, chunkPos, \u26032, \u26032, \u26033);
                });
            }
        }
    }

    protected void func_219199_a(ServerPlayerEntity serverPlayerEntity, ChunkPos chunkPos, IPacket<?>[] iPacketArray, boolean bl, boolean bl22) {
        boolean bl22;
        if (serverPlayerEntity.field_70170_p != this.field_219255_i) {
            return;
        }
        if (bl22 && !bl && (\u2603 = this.func_219219_b(chunkPos.func_201841_a())) != null) {
            Chunk chunk = \u2603.func_219298_c();
            if (chunk != null) {
                this.func_219180_a(serverPlayerEntity, iPacketArray, chunk);
            }
            DebugPacketSender.func_218802_a(this.field_219255_i, chunkPos);
        }
        if (!bl22 && bl) {
            serverPlayerEntity.func_213845_a(chunkPos);
        }
    }

    public int func_219194_d() {
        return this.field_219252_f.size();
    }

    protected ProxyTicketManager func_219246_e() {
        return this.field_219267_u;
    }

    protected Iterable<ChunkHolder> func_223491_f() {
        return Iterables.unmodifiableIterable((Iterable)this.field_219252_f.values());
    }

    void func_225406_a(Writer writer) throws IOException {
        CSVWriter cSVWriter = CSVWriter.func_225428_a().func_225423_a("x").func_225423_a("z").func_225423_a("level").func_225423_a("in_memory").func_225423_a("status").func_225423_a("full_status").func_225423_a("accessible_ready").func_225423_a("ticking_ready").func_225423_a("entity_ticking_ready").func_225423_a("ticket").func_225423_a("spawning").func_225423_a("entity_count").func_225423_a("block_entity_count").func_225422_a(writer);
        for (Long2ObjectMap.Entry entry : this.field_219252_f.long2ObjectEntrySet()) {
            ChunkPos chunkPos = new ChunkPos(entry.getLongKey());
            ChunkHolder \u26032 = (ChunkHolder)entry.getValue();
            Optional<IChunk> \u26033 = Optional.ofNullable(\u26032.func_219287_e());
            Optional<Object> \u26034 = \u26033.flatMap(iChunk -> iChunk instanceof Chunk ? Optional.of((Chunk)iChunk) : Optional.empty());
            cSVWriter.func_225426_a(chunkPos.field_77276_a, chunkPos.field_77275_b, \u26032.func_219299_i(), \u26033.isPresent(), \u26033.map(IChunk::func_201589_g).orElse(null), \u26034.map(Chunk::func_217321_u).orElse(null), ChunkManager.func_225402_a(\u26032.func_223492_c()), ChunkManager.func_225402_a(\u26032.func_219296_a()), ChunkManager.func_225402_a(\u26032.func_219297_b()), this.field_219267_u.func_225413_c(entry.getLongKey()), !this.func_219243_d(chunkPos), \u26034.map(chunk -> Stream.of(chunk.func_177429_s()).mapToInt(ClassInheritanceMultiMap::size).sum()).orElse(0), \u26034.map(chunk -> chunk.func_177434_r().size()).orElse(0));
        }
    }

    private static String func_225402_a(CompletableFuture<Either<Chunk, ChunkHolder.IChunkLoadingError>> completableFuture) {
        try {
            Either either = completableFuture.getNow(null);
            if (either != null) {
                return (String)either.map(chunk -> "done", iChunkLoadingError -> "unloaded");
            }
            return "not completed";
        }
        catch (CompletionException completionException) {
            return "failed " + completionException.getCause().getMessage();
        }
        catch (CancellationException cancellationException) {
            return "cancelled";
        }
    }

    @Nullable
    private CompoundNBT func_219178_f(ChunkPos chunkPos) throws IOException {
        CompoundNBT compoundNBT = this.func_227078_e_(chunkPos);
        if (compoundNBT == null) {
            return null;
        }
        return this.func_219166_a(this.field_219255_i.func_201675_m().func_186058_p(), this.field_219259_m, compoundNBT);
    }

    boolean func_219243_d(ChunkPos chunkPos) {
        long l = chunkPos.func_201841_a();
        if (!this.field_219267_u.func_223494_d(l)) {
            return true;
        }
        return this.field_219271_y.func_219444_a(l).noneMatch(serverPlayerEntity -> !serverPlayerEntity.func_175149_v() && ChunkManager.func_219217_a(chunkPos, serverPlayerEntity) < 16384.0);
    }

    private boolean func_219187_b(ServerPlayerEntity serverPlayerEntity) {
        return serverPlayerEntity.func_175149_v() && !this.field_219255_i.func_82736_K().func_223586_b(GameRules.field_223613_p);
    }

    void func_219234_a(ServerPlayerEntity serverPlayerEntity, boolean bl) {
        \u2603 = this.func_219187_b(serverPlayerEntity);
        \u2603 = this.field_219271_y.func_219448_c(serverPlayerEntity);
        int n = MathHelper.func_76128_c(serverPlayerEntity.func_226277_ct_()) >> 4;
        \u2603 = MathHelper.func_76128_c(serverPlayerEntity.func_226281_cx_()) >> 4;
        if (bl) {
            this.field_219271_y.func_219442_a(ChunkPos.func_77272_a(n, \u2603), serverPlayerEntity, \u2603);
            this.func_223489_c(serverPlayerEntity);
            if (!\u2603) {
                this.field_219267_u.func_219341_a(SectionPos.func_218157_a(serverPlayerEntity), serverPlayerEntity);
            }
        } else {
            SectionPos sectionPos = serverPlayerEntity.func_213842_M();
            this.field_219271_y.func_219443_a(sectionPos.func_218155_u().func_201841_a(), serverPlayerEntity);
            if (!\u2603) {
                this.field_219267_u.func_219367_b(sectionPos, serverPlayerEntity);
            }
        }
        for (int i = n - this.field_219247_A; i <= n + this.field_219247_A; ++i) {
            for (\u2603 = \u2603 - this.field_219247_A; \u2603 <= \u2603 + this.field_219247_A; ++\u2603) {
                ChunkPos chunkPos = new ChunkPos(i, \u2603);
                this.func_219199_a(serverPlayerEntity, chunkPos, new IPacket[2], !bl, bl);
            }
        }
    }

    private SectionPos func_223489_c(ServerPlayerEntity serverPlayerEntity) {
        SectionPos sectionPos = SectionPos.func_218157_a(serverPlayerEntity);
        serverPlayerEntity.func_213850_a(sectionPos);
        serverPlayerEntity.field_71135_a.func_147359_a(new SUpdateChunkPositionPacket(sectionPos.func_218149_a(), sectionPos.func_218148_c()));
        return sectionPos;
    }

    public void func_219183_a(ServerPlayerEntity serverPlayerEntity2) {
        ServerPlayerEntity serverPlayerEntity2;
        for (EntityTracker entityTracker : this.field_219272_z.values()) {
            if (entityTracker.field_219403_c == serverPlayerEntity2) {
                entityTracker.func_219397_a(this.field_219255_i.func_217369_A());
                continue;
            }
            entityTracker.func_219400_b(serverPlayerEntity2);
        }
        int \u26032 = MathHelper.func_76128_c(serverPlayerEntity2.func_226277_ct_()) >> 4;
        int \u26033 = MathHelper.func_76128_c(serverPlayerEntity2.func_226281_cx_()) >> 4;
        SectionPos \u26034 = serverPlayerEntity2.func_213842_M();
        SectionPos \u26035 = SectionPos.func_218157_a(serverPlayerEntity2);
        long \u26036 = \u26034.func_218155_u().func_201841_a();
        long \u26037 = \u26035.func_218155_u().func_201841_a();
        boolean \u26038 = this.field_219271_y.func_225419_d(serverPlayerEntity2);
        boolean \u26039 = this.func_219187_b(serverPlayerEntity2);
        boolean bl = \u2603 = \u26034.func_218146_v() != \u26035.func_218146_v();
        if (\u2603 || \u26038 != \u26039) {
            this.func_223489_c(serverPlayerEntity2);
            if (!\u26038) {
                this.field_219267_u.func_219367_b(\u26034, serverPlayerEntity2);
            }
            if (!\u26039) {
                this.field_219267_u.func_219341_a(\u26035, serverPlayerEntity2);
            }
            if (!\u26038 && \u26039) {
                this.field_219271_y.func_219446_a(serverPlayerEntity2);
            }
            if (\u26038 && !\u26039) {
                this.field_219271_y.func_219447_b(serverPlayerEntity2);
            }
            if (\u26036 != \u26037) {
                this.field_219271_y.func_219445_a(\u26036, \u26037, serverPlayerEntity2);
            }
        }
        int \u260310 = \u26034.func_218149_a();
        int \u260311 = \u26034.func_218148_c();
        if (Math.abs(\u260310 - \u26032) <= this.field_219247_A * 2 && Math.abs(\u260311 - \u26033) <= this.field_219247_A * 2) {
            int n = Math.min(\u26032, \u260310) - this.field_219247_A;
            \u2603 = Math.min(\u26033, \u260311) - this.field_219247_A;
            \u2603 = Math.max(\u26032, \u260310) + this.field_219247_A;
            \u2603 = Math.max(\u26033, \u260311) + this.field_219247_A;
            for (\u2603 = n; \u2603 <= \u2603; ++\u2603) {
                for (\u2603 = \u2603; \u2603 <= \u2603; ++\u2603) {
                    ChunkPos chunkPos = new ChunkPos(\u2603, \u2603);
                    boolean \u260312 = ChunkManager.func_219232_a(chunkPos, \u260310, \u260311) <= this.field_219247_A;
                    boolean \u260313 = ChunkManager.func_219232_a(chunkPos, \u26032, \u26033) <= this.field_219247_A;
                    this.func_219199_a(serverPlayerEntity2, chunkPos, new IPacket[2], \u260312, \u260313);
                }
            }
        } else {
            boolean \u260315;
            boolean \u260314;
            ChunkPos chunkPos;
            int n;
            for (n = \u260310 - this.field_219247_A; n <= \u260310 + this.field_219247_A; ++n) {
                for (\u2603 = \u260311 - this.field_219247_A; \u2603 <= \u260311 + this.field_219247_A; ++\u2603) {
                    chunkPos = new ChunkPos(n, \u2603);
                    \u260314 = true;
                    \u260315 = false;
                    this.func_219199_a(serverPlayerEntity2, chunkPos, new IPacket[2], true, false);
                }
            }
            for (n = \u26032 - this.field_219247_A; n <= \u26032 + this.field_219247_A; ++n) {
                for (\u2603 = \u26033 - this.field_219247_A; \u2603 <= \u26033 + this.field_219247_A; ++\u2603) {
                    chunkPos = new ChunkPos(n, \u2603);
                    \u260314 = false;
                    \u260315 = true;
                    this.func_219199_a(serverPlayerEntity2, chunkPos, new IPacket[2], false, true);
                }
            }
        }
    }

    @Override
    public Stream<ServerPlayerEntity> func_219097_a(ChunkPos chunkPos, boolean bl) {
        return this.field_219271_y.func_219444_a(chunkPos.func_201841_a()).filter(serverPlayerEntity -> {
            int n = ChunkManager.func_219215_b(chunkPos, serverPlayerEntity, true);
            if (n > this.field_219247_A) {
                return false;
            }
            return !bl || n == this.field_219247_A;
        });
    }

    protected void func_219210_a(Entity entity) {
        if (entity instanceof EnderDragonPartEntity) {
            return;
        }
        if (entity instanceof LightningBoltEntity) {
            return;
        }
        EntityType<?> entityType = entity.func_200600_R();
        int \u26032 = entityType.func_220345_k() * 16;
        int \u26033 = entityType.func_220332_l();
        if (this.field_219272_z.containsKey(entity.func_145782_y())) {
            throw Util.func_229757_c_(new IllegalStateException("Entity is already tracked!"));
        }
        EntityTracker \u26034 = new EntityTracker(entity, \u26032, \u26033, entityType.func_220340_m());
        this.field_219272_z.put(entity.func_145782_y(), (Object)\u26034);
        \u26034.func_219397_a(this.field_219255_i.func_217369_A());
        if (entity instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverPlayerEntity = (ServerPlayerEntity)entity;
            this.func_219234_a(serverPlayerEntity, true);
            for (EntityTracker entityTracker : this.field_219272_z.values()) {
                if (entityTracker.field_219403_c == serverPlayerEntity) continue;
                entityTracker.func_219400_b(serverPlayerEntity);
            }
        }
    }

    protected void func_219231_b(Entity entity) {
        Object object;
        if (entity instanceof ServerPlayerEntity) {
            object = (ServerPlayerEntity)entity;
            this.func_219234_a((ServerPlayerEntity)object, false);
            for (EntityTracker entityTracker : this.field_219272_z.values()) {
                entityTracker.func_219399_a((ServerPlayerEntity)object);
            }
        }
        if ((object = (EntityTracker)this.field_219272_z.remove(entity.func_145782_y())) != null) {
            ((EntityTracker)object).func_219396_a();
        }
    }

    protected void func_219169_g() {
        ArrayList arrayList = Lists.newArrayList();
        List<ServerPlayerEntity> \u26032 = this.field_219255_i.func_217369_A();
        for (EntityTracker entityTracker2 : this.field_219272_z.values()) {
            EntityTracker entityTracker2;
            SectionPos sectionPos = entityTracker2.field_219405_e;
            if (!Objects.equals(sectionPos, \u2603 = SectionPos.func_218157_a(entityTracker2.field_219403_c))) {
                entityTracker2.func_219397_a(\u26032);
                Entity entity = entityTracker2.field_219403_c;
                if (entity instanceof ServerPlayerEntity) {
                    arrayList.add((ServerPlayerEntity)entity);
                }
                entityTracker2.field_219405_e = \u2603;
            }
            entityTracker2.field_219402_b.func_219453_a();
        }
        if (!arrayList.isEmpty()) {
            for (EntityTracker entityTracker2 : this.field_219272_z.values()) {
                entityTracker2.func_219397_a(arrayList);
            }
        }
    }

    protected void func_219222_a(Entity entity, IPacket<?> iPacket) {
        EntityTracker entityTracker = (EntityTracker)this.field_219272_z.get(entity.func_145782_y());
        if (entityTracker != null) {
            entityTracker.func_219391_a(iPacket);
        }
    }

    protected void func_219225_b(Entity entity, IPacket<?> iPacket) {
        EntityTracker entityTracker = (EntityTracker)this.field_219272_z.get(entity.func_145782_y());
        if (entityTracker != null) {
            entityTracker.func_219392_b(iPacket);
        }
    }

    private void func_219180_a(ServerPlayerEntity serverPlayerEntity, IPacket<?>[] iPacketArray, Chunk chunk) {
        ArrayList arrayList;
        if (iPacketArray[0] == null) {
            iPacketArray[0] = new SChunkDataPacket(chunk, 65535);
            iPacketArray[1] = new SUpdateLightPacket(chunk.func_76632_l(), this.field_219256_j);
        }
        serverPlayerEntity.func_213844_a(chunk.func_76632_l(), iPacketArray[0], iPacketArray[1]);
        DebugPacketSender.func_218802_a(this.field_219255_i, chunk.func_76632_l());
        ArrayList arrayList2 = Lists.newArrayList();
        arrayList = Lists.newArrayList();
        for (Object object : this.field_219272_z.values()) {
            Entity entity = ((EntityTracker)object).field_219403_c;
            if (entity == serverPlayerEntity || entity.field_70176_ah != chunk.func_76632_l().field_77276_a || entity.field_70164_aj != chunk.func_76632_l().field_77275_b) continue;
            ((EntityTracker)object).func_219400_b(serverPlayerEntity);
            if (entity instanceof MobEntity && ((MobEntity)entity).func_110166_bE() != null) {
                arrayList2.add(entity);
            }
            if (entity.func_184188_bt().isEmpty()) continue;
            arrayList.add(entity);
        }
        if (!arrayList2.isEmpty()) {
            for (Object object : arrayList2) {
                serverPlayerEntity.field_71135_a.func_147359_a(new SMountEntityPacket((Entity)object, ((MobEntity)object).func_110166_bE()));
            }
        }
        if (!arrayList.isEmpty()) {
            for (Object object : arrayList) {
                serverPlayerEntity.field_71135_a.func_147359_a(new SSetPassengersPacket((Entity)object));
            }
        }
    }

    protected PointOfInterestManager func_219189_h() {
        return this.field_219260_n;
    }

    public CompletableFuture<Void> func_222973_a(Chunk chunk) {
        return this.field_219257_k.func_222817_e(() -> chunk.func_222880_a(this.field_219255_i));
    }

    class EntityTracker {
        private final TrackedEntity field_219402_b;
        private final Entity field_219403_c;
        private final int field_219404_d;
        private SectionPos field_219405_e;
        private final Set<ServerPlayerEntity> field_219406_f = Sets.newHashSet();

        public EntityTracker(Entity entity, int n, int n2, boolean bl) {
            this.field_219402_b = new TrackedEntity(ChunkManager.this.field_219255_i, entity, n2, bl, this::func_219391_a);
            this.field_219403_c = entity;
            this.field_219404_d = n;
            this.field_219405_e = SectionPos.func_218157_a(entity);
        }

        public boolean equals(Object object) {
            if (object instanceof EntityTracker) {
                return ((EntityTracker)object).field_219403_c.func_145782_y() == this.field_219403_c.func_145782_y();
            }
            return false;
        }

        public int hashCode() {
            return this.field_219403_c.func_145782_y();
        }

        public void func_219391_a(IPacket<?> iPacket) {
            for (ServerPlayerEntity serverPlayerEntity : this.field_219406_f) {
                serverPlayerEntity.field_71135_a.func_147359_a(iPacket);
            }
        }

        public void func_219392_b(IPacket<?> iPacket) {
            this.func_219391_a(iPacket);
            if (this.field_219403_c instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)this.field_219403_c).field_71135_a.func_147359_a(iPacket);
            }
        }

        public void func_219396_a() {
            for (ServerPlayerEntity serverPlayerEntity : this.field_219406_f) {
                this.field_219402_b.func_219454_a(serverPlayerEntity);
            }
        }

        public void func_219399_a(ServerPlayerEntity serverPlayerEntity) {
            if (this.field_219406_f.remove(serverPlayerEntity)) {
                this.field_219402_b.func_219454_a(serverPlayerEntity);
            }
        }

        public void func_219400_b(ServerPlayerEntity serverPlayerEntity2) {
            ServerPlayerEntity serverPlayerEntity2;
            if (serverPlayerEntity2 == this.field_219403_c) {
                return;
            }
            Vec3d vec3d = serverPlayerEntity2.func_213303_ch().func_178788_d(this.field_219402_b.func_219456_b());
            int \u26032 = Math.min(this.func_229843_b_(), (ChunkManager.this.field_219247_A - 1) * 16);
            boolean bl = \u2603 = vec3d.field_72450_a >= (double)(-\u26032) && vec3d.field_72450_a <= (double)\u26032 && vec3d.field_72449_c >= (double)(-\u26032) && vec3d.field_72449_c <= (double)\u26032 && this.field_219403_c.func_174827_a(serverPlayerEntity2);
            if (\u2603) {
                boolean bl2 = this.field_219403_c.field_98038_p;
                if (!bl2 && (\u2603 = ChunkManager.this.func_219219_b((\u2603 = new ChunkPos(this.field_219403_c.field_70176_ah, this.field_219403_c.field_70164_aj)).func_201841_a())) != null && \u2603.func_219298_c() != null) {
                    boolean bl3 = bl2 = ChunkManager.func_219215_b(\u2603, serverPlayerEntity2, false) <= ChunkManager.this.field_219247_A;
                }
                if (bl2 && this.field_219406_f.add(serverPlayerEntity2)) {
                    this.field_219402_b.func_219455_b(serverPlayerEntity2);
                }
            } else if (this.field_219406_f.remove(serverPlayerEntity2)) {
                this.field_219402_b.func_219454_a(serverPlayerEntity2);
            }
        }

        private int func_229843_b_() {
            Collection<Entity> collection = this.field_219403_c.func_184182_bu();
            int \u26032 = this.field_219404_d;
            for (Entity entity : collection) {
                int n = entity.func_200600_R().func_220345_k() * 16;
                if (n <= \u26032) continue;
                \u26032 = n;
            }
            return \u26032;
        }

        public void func_219397_a(List<ServerPlayerEntity> list) {
            for (ServerPlayerEntity serverPlayerEntity : list) {
                this.func_219400_b(serverPlayerEntity);
            }
        }
    }

    class ProxyTicketManager
    extends TicketManager {
        protected ProxyTicketManager(Executor executor, Executor executor2) {
            super(executor, executor2);
        }

        @Override
        protected boolean func_219371_a(long l) {
            return ChunkManager.this.field_219261_o.contains(l);
        }

        @Override
        @Nullable
        protected ChunkHolder func_219335_b(long l) {
            return ChunkManager.this.func_219220_a(l);
        }

        @Override
        @Nullable
        protected ChunkHolder func_219372_a(long l, int n, @Nullable ChunkHolder chunkHolder, int n2) {
            return ChunkManager.this.func_219213_a(l, n, chunkHolder, n2);
        }
    }
}

