/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.management;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.authlib.Agent;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.ProfileLookupCallback;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.JSONUtils;
import org.apache.commons.io.IOUtils;

public class PlayerProfileCache {
    public static final SimpleDateFormat field_152659_a = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
    private static boolean field_187322_c;
    private final Map<String, ProfileEntry> field_152661_c = Maps.newHashMap();
    private final Map<UUID, ProfileEntry> field_152662_d = Maps.newHashMap();
    private final Deque<GameProfile> field_152663_e = Lists.newLinkedList();
    private final GameProfileRepository field_187323_g;
    protected final Gson field_152660_b;
    private final File field_152665_g;
    private static final ParameterizedType field_152666_h;

    public PlayerProfileCache(GameProfileRepository gameProfileRepository, File file) {
        this.field_187323_g = gameProfileRepository;
        this.field_152665_g = file;
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeHierarchyAdapter(ProfileEntry.class, (Object)new Serializer());
        this.field_152660_b = gsonBuilder.create();
        this.func_152657_b();
    }

    private static GameProfile func_187319_a(GameProfileRepository gameProfileRepository, String string) {
        final GameProfile[] gameProfileArray = new GameProfile[1];
        ProfileLookupCallback \u26032 = new ProfileLookupCallback(){

            public void onProfileLookupSucceeded(GameProfile gameProfile) {
                gameProfileArray[0] = gameProfile;
            }

            public void onProfileLookupFailed(GameProfile gameProfile, Exception exception) {
                gameProfileArray[0] = null;
            }
        };
        gameProfileRepository.findProfilesByNames(new String[]{string}, Agent.MINECRAFT, \u26032);
        if (!PlayerProfileCache.func_187321_d() && gameProfileArray[0] == null) {
            UUID uUID = PlayerEntity.func_146094_a(new GameProfile(null, string));
            GameProfile \u26033 = new GameProfile(uUID, string);
            \u26032.onProfileLookupSucceeded(\u26033);
        }
        return gameProfileArray[0];
    }

    public static void func_187320_a(boolean bl) {
        field_187322_c = bl;
    }

    private static boolean func_187321_d() {
        return field_187322_c;
    }

    public void func_152649_a(GameProfile gameProfile) {
        this.func_152651_a(gameProfile, null);
    }

    private void func_152651_a(GameProfile gameProfile, Date \u260322) {
        Date \u260322;
        UUID uUID = gameProfile.getId();
        if (\u260322 == null) {
            Object object = Calendar.getInstance();
            ((Calendar)object).setTime(new Date());
            ((Calendar)object).add(2, 1);
            \u260322 = ((Calendar)object).getTime();
        }
        object = new ProfileEntry(gameProfile, \u260322);
        if (this.field_152662_d.containsKey(uUID)) {
            ProfileEntry \u26033 = this.field_152662_d.get(uUID);
            this.field_152661_c.remove(\u26033.func_152668_a().getName().toLowerCase(Locale.ROOT));
            this.field_152663_e.remove(gameProfile);
        }
        this.field_152661_c.put(gameProfile.getName().toLowerCase(Locale.ROOT), (ProfileEntry)object);
        this.field_152662_d.put(uUID, (ProfileEntry)object);
        this.field_152663_e.addFirst(gameProfile);
        this.func_152658_c();
    }

    @Nullable
    public GameProfile func_152655_a(String string) {
        string2 = string.toLowerCase(Locale.ROOT);
        ProfileEntry profileEntry = this.field_152661_c.get(string2);
        if (profileEntry != null && new Date().getTime() >= profileEntry.field_152673_c.getTime()) {
            this.field_152662_d.remove(profileEntry.func_152668_a().getId());
            this.field_152661_c.remove(profileEntry.func_152668_a().getName().toLowerCase(Locale.ROOT));
            this.field_152663_e.remove(profileEntry.func_152668_a());
            profileEntry = null;
        }
        if (profileEntry != null) {
            GameProfile gameProfile = profileEntry.func_152668_a();
            this.field_152663_e.remove(gameProfile);
            this.field_152663_e.addFirst(gameProfile);
        } else {
            String string2;
            GameProfile \u26032 = PlayerProfileCache.func_187319_a(this.field_187323_g, string2);
            if (\u26032 != null) {
                this.func_152649_a(\u26032);
                profileEntry = this.field_152661_c.get(string2);
            }
        }
        this.func_152658_c();
        return profileEntry == null ? null : profileEntry.func_152668_a();
    }

    @Nullable
    public GameProfile func_152652_a(UUID uUID) {
        ProfileEntry profileEntry = this.field_152662_d.get(uUID);
        return profileEntry == null ? null : profileEntry.func_152668_a();
    }

    private ProfileEntry func_152653_b(UUID uUID) {
        ProfileEntry profileEntry = this.field_152662_d.get(uUID);
        if (profileEntry != null) {
            GameProfile gameProfile = profileEntry.func_152668_a();
            this.field_152663_e.remove(gameProfile);
            this.field_152663_e.addFirst(gameProfile);
        }
        return profileEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_152657_b() {
        BufferedReader bufferedReader;
        block5: {
            bufferedReader = null;
            try {
                bufferedReader = Files.newReader((File)this.field_152665_g, (Charset)StandardCharsets.UTF_8);
                List list = (List)JSONUtils.func_193841_a(this.field_152660_b, bufferedReader, field_152666_h);
                this.field_152661_c.clear();
                this.field_152662_d.clear();
                this.field_152663_e.clear();
                if (list == null) break block5;
                for (ProfileEntry profileEntry : Lists.reverse((List)list)) {
                    if (profileEntry == null) continue;
                    this.func_152651_a(profileEntry.func_152668_a(), profileEntry.func_152670_b());
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                IOUtils.closeQuietly(bufferedReader);
            }
            catch (JsonParseException jsonParseException) {
                IOUtils.closeQuietly(bufferedReader);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferedReader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)bufferedReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_152658_c() {
        String string = this.field_152660_b.toJson(this.func_152656_a(1000));
        BufferedWriter \u26032 = null;
        try {
            \u26032 = Files.newWriter((File)this.field_152665_g, (Charset)StandardCharsets.UTF_8);
            \u26032.write(string);
        }
        catch (FileNotFoundException \u26033) {
            IOUtils.closeQuietly(\u26032);
            return;
        }
        catch (IOException \u26034) {
            IOUtils.closeQuietly(\u26032);
            return;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(\u26032);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)\u26032);
    }

    private List<ProfileEntry> func_152656_a(int n) {
        ArrayList arrayList = Lists.newArrayList();
        \u2603 = Lists.newArrayList((Iterator)Iterators.limit(this.field_152663_e.iterator(), (int)n));
        for (GameProfile gameProfile : \u2603) {
            ProfileEntry profileEntry = this.func_152653_b(gameProfile.getId());
            if (profileEntry == null) continue;
            arrayList.add(profileEntry);
        }
        return arrayList;
    }

    static {
        field_152666_h = new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return new Type[]{ProfileEntry.class};
            }

            @Override
            public Type getRawType() {
                return List.class;
            }

            @Override
            public Type getOwnerType() {
                return null;
            }
        };
    }

    class ProfileEntry {
        private final GameProfile field_152672_b;
        private final Date field_152673_c;

        private ProfileEntry(GameProfile gameProfile, Date date) {
            this.field_152672_b = gameProfile;
            this.field_152673_c = date;
        }

        public GameProfile func_152668_a() {
            return this.field_152672_b;
        }

        public Date func_152670_b() {
            return this.field_152673_c;
        }
    }

    class Serializer
    implements JsonDeserializer<ProfileEntry>,
    JsonSerializer<ProfileEntry> {
        private Serializer() {
        }

        public JsonElement serialize(ProfileEntry profileEntry, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("name", profileEntry.func_152668_a().getName());
            UUID \u26032 = profileEntry.func_152668_a().getId();
            jsonObject.addProperty("uuid", \u26032 == null ? "" : \u26032.toString());
            jsonObject.addProperty("expiresOn", field_152659_a.format(profileEntry.func_152670_b()));
            return jsonObject;
        }

        public ProfileEntry deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            if (jsonElement.isJsonObject()) {
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                JsonElement \u26032 = jsonObject.get("name");
                JsonElement \u26033 = jsonObject.get("uuid");
                JsonElement \u26034 = jsonObject.get("expiresOn");
                if (\u26032 == null || \u26033 == null) {
                    return null;
                }
                String \u26035 = \u26033.getAsString();
                String \u26036 = \u26032.getAsString();
                Date \u26037 = null;
                if (\u26034 != null) {
                    try {
                        \u26037 = field_152659_a.parse(\u26034.getAsString());
                    }
                    catch (ParseException parseException) {
                        \u26037 = null;
                    }
                }
                if (\u26036 == null || \u26035 == null) {
                    return null;
                }
                try {
                    UUID uUID = UUID.fromString(\u26035);
                }
                catch (Throwable throwable) {
                    return null;
                }
                return new ProfileEntry(new GameProfile(uUID, \u26036), \u26037);
            }
            return null;
        }

        public /* synthetic */ JsonElement serialize(Object object, Type type, JsonSerializationContext jsonSerializationContext) {
            return this.serialize((ProfileEntry)object, type, jsonSerializationContext);
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.deserialize(jsonElement, type, jsonDeserializationContext);
        }
    }
}

