/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.resources.FolderPack;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePack;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VanillaPack
implements IResourcePack {
    public static Path field_199754_a;
    private static final Logger field_195784_b;
    public static Class<?> field_211688_b;
    private static final Map<ResourcePackType, FileSystem> field_217810_e;
    public final Set<String> field_195783_a;

    public VanillaPack(String ... stringArray) {
        this.field_195783_a = ImmutableSet.copyOf((Object[])stringArray);
    }

    public InputStream func_195763_b(String string) throws IOException {
        if (string.contains("/") || string.contains("\\")) {
            throw new IllegalArgumentException("Root resources can only be filenames, not paths (no / allowed!)");
        }
        if (field_199754_a != null && Files.exists(\u2603 = field_199754_a.resolve(string), new LinkOption[0])) {
            return Files.newInputStream(\u2603, new OpenOption[0]);
        }
        return this.func_200010_a(string);
    }

    @Override
    public InputStream func_195761_a(ResourcePackType resourcePackType, ResourceLocation resourceLocation) throws IOException {
        InputStream inputStream = this.func_195782_c(resourcePackType, resourceLocation);
        if (inputStream != null) {
            return inputStream;
        }
        throw new FileNotFoundException(resourceLocation.func_110623_a());
    }

    @Override
    public Collection<ResourceLocation> func_225637_a_(ResourcePackType resourcePackType2, String string, String string2, int n, Predicate<String> predicate) {
        URI \u26033;
        Enumeration<URL> \u26032;
        HashSet hashSet = Sets.newHashSet();
        if (field_199754_a != null) {
            try {
                VanillaPack.func_229867_a_(hashSet, n, string, field_199754_a.resolve(resourcePackType2.func_198956_a()), string2, predicate);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (resourcePackType2 == ResourcePackType.CLIENT_RESOURCES) {
                \u26032 = null;
                try {
                    \u26032 = field_211688_b.getClassLoader().getResources(resourcePackType2.func_198956_a() + "/");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                while (\u26032 != null && \u26032.hasMoreElements()) {
                    try {
                        \u26033 = ((URL)\u26032.nextElement()).toURI();
                        if (!"file".equals(\u26033.getScheme())) continue;
                        VanillaPack.func_229867_a_(hashSet, n, string, Paths.get(\u26033), string2, predicate);
                    }
                    catch (IOException | URISyntaxException exception) {}
                }
            }
        }
        try {
            ResourcePackType resourcePackType2;
            \u26032 = VanillaPack.class.getResource("/" + resourcePackType2.func_198956_a() + "/.mcassetsroot");
            if (\u26032 == null) {
                field_195784_b.error("Couldn't find .mcassetsroot, cannot load vanilla resources");
                return hashSet;
            }
            \u26033 = ((URL)((Object)\u26032)).toURI();
            if ("file".equals(\u26033.getScheme())) {
                URL uRL = new URL(((URL)((Object)\u26032)).toString().substring(0, ((URL)((Object)\u26032)).toString().length() - ".mcassetsroot".length()));
                Path \u26034 = Paths.get(uRL.toURI());
                VanillaPack.func_229867_a_(hashSet, n, string, \u26034, string2, predicate);
            } else if ("jar".equals(\u26033.getScheme())) {
                Path \u26035 = field_217810_e.get((Object)resourcePackType2).getPath("/" + resourcePackType2.func_198956_a(), new String[0]);
                VanillaPack.func_229867_a_(hashSet, n, "minecraft", \u26035, string2, predicate);
            } else {
                field_195784_b.error("Unsupported scheme {} trying to list vanilla resources (NYI?)", (Object)\u26033);
            }
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {
        }
        catch (IOException | URISyntaxException exception) {
            field_195784_b.error("Couldn't get a list of all vanilla resources", (Throwable)exception);
        }
        return hashSet;
    }

    private static void func_229867_a_(Collection<ResourceLocation> collection, int n, String string, Path path3, String string2, Predicate<String> predicate) throws IOException {
        Path path4 = path3.resolve(string);
        try (Stream<Path> \u26032 = Files.walk(path4.resolve(string2), n, new FileVisitOption[0]);){
            \u26032.filter(path -> !path.endsWith(".mcmeta") && Files.isRegularFile(path, new LinkOption[0]) && predicate.test(path.getFileName().toString())).map(path2 -> new ResourceLocation(string, path4.relativize((Path)path2).toString().replaceAll("\\\\", "/"))).forEach(collection::add);
        }
    }

    @Nullable
    protected InputStream func_195782_c(ResourcePackType resourcePackType, ResourceLocation resourceLocation) {
        String string = VanillaPack.func_223458_d(resourcePackType, resourceLocation);
        if (field_199754_a != null && Files.exists((Path)(object = field_199754_a.resolve(resourcePackType.func_198956_a() + "/" + resourceLocation.func_110624_b() + "/" + resourceLocation.func_110623_a())), new LinkOption[0])) {
            try {
                return Files.newInputStream((Path)object, new OpenOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            Object object = VanillaPack.class.getResource(string);
            if (VanillaPack.func_223459_a(string, (URL)object)) {
                return ((URL)object).openStream();
            }
        }
        catch (IOException iOException) {
            return VanillaPack.class.getResourceAsStream(string);
        }
        return null;
    }

    private static String func_223458_d(ResourcePackType resourcePackType, ResourceLocation resourceLocation) {
        return "/" + resourcePackType.func_198956_a() + "/" + resourceLocation.func_110624_b() + "/" + resourceLocation.func_110623_a();
    }

    private static boolean func_223459_a(String string, @Nullable URL uRL) throws IOException {
        return uRL != null && (uRL.getProtocol().equals("jar") || FolderPack.func_195777_a(new File(uRL.getFile()), string));
    }

    @Nullable
    protected InputStream func_200010_a(String string) {
        return VanillaPack.class.getResourceAsStream("/" + string);
    }

    @Override
    public boolean func_195764_b(ResourcePackType resourcePackType, ResourceLocation resourceLocation) {
        String string = VanillaPack.func_223458_d(resourcePackType, resourceLocation);
        if (field_199754_a != null && Files.exists((Path)(object = field_199754_a.resolve(resourcePackType.func_198956_a() + "/" + resourceLocation.func_110624_b() + "/" + resourceLocation.func_110623_a())), new LinkOption[0])) {
            return true;
        }
        try {
            Object object = VanillaPack.class.getResource(string);
            return VanillaPack.func_223459_a(string, (URL)object);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public Set<String> func_195759_a(ResourcePackType resourcePackType) {
        return this.field_195783_a;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public <T> T func_195760_a(IMetadataSectionSerializer<T> iMetadataSectionSerializer) throws IOException {
        try (InputStream inputStream = this.func_195763_b("pack.mcmeta");){
            T t = ResourcePack.func_195770_a(iMetadataSectionSerializer, inputStream);
            return t;
        }
        catch (FileNotFoundException | RuntimeException exception) {
            return null;
        }
    }

    @Override
    public String func_195762_a() {
        return "Default";
    }

    @Override
    public void close() {
    }

    static {
        field_195784_b = LogManager.getLogger();
        field_217810_e = Util.func_200696_a(Maps.newHashMap(), hashMap2 -> {
            Class<VanillaPack> clazz = VanillaPack.class;
            synchronized (VanillaPack.class) {
                for (ResourcePackType resourcePackType : ResourcePackType.values()) {
                    URL uRL = VanillaPack.class.getResource("/" + resourcePackType.func_198956_a() + "/.mcassetsroot");
                    try {
                        HashMap hashMap2;
                        FileSystem fileSystem;
                        URI uRI = uRL.toURI();
                        if (!"jar".equals(uRI.getScheme())) continue;
                        try {
                            fileSystem = FileSystems.getFileSystem(uRI);
                        }
                        catch (FileSystemNotFoundException fileSystemNotFoundException) {
                            fileSystem = FileSystems.newFileSystem(uRI, Collections.emptyMap());
                        }
                        hashMap2.put(resourcePackType, fileSystem);
                    }
                    catch (IOException | URISyntaxException exception) {
                        field_195784_b.error("Couldn't get a list of all vanilla resources", (Throwable)exception);
                    }
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        });
    }
}

