/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.monster.ZombiePigmanEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class PigEntity
extends AnimalEntity {
    private static final DataParameter<Boolean> field_184763_bv = EntityDataManager.func_187226_a(PigEntity.class, DataSerializers.field_187198_h);
    private static final DataParameter<Integer> field_191520_bx = EntityDataManager.func_187226_a(PigEntity.class, DataSerializers.field_187192_b);
    private static final Ingredient field_184764_bw = Ingredient.func_199804_a(Items.field_151172_bF, Items.field_151174_bG, Items.field_185164_cV);
    private boolean field_184765_bx;
    private int field_184766_bz;
    private int field_184767_bA;

    public PigEntity(EntityType<? extends PigEntity> entityType, World world) {
        super((EntityType<? extends AnimalEntity>)entityType, world);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, new SwimGoal(this));
        this.field_70714_bg.func_75776_a(1, new PanicGoal(this, 1.25));
        this.field_70714_bg.func_75776_a(3, new BreedGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(4, new TemptGoal((CreatureEntity)this, 1.2, Ingredient.func_199804_a(Items.field_151146_bM), false));
        this.field_70714_bg.func_75776_a(4, new TemptGoal((CreatureEntity)this, 1.2, false, field_184764_bw));
        this.field_70714_bg.func_75776_a(5, new FollowParentGoal(this, 1.1));
        this.field_70714_bg.func_75776_a(6, new WaterAvoidingRandomWalkingGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(7, new LookAtGoal(this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, new LookRandomlyGoal(this));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    @Override
    @Nullable
    public Entity func_184179_bs() {
        if (this.func_184188_bt().isEmpty()) {
            return null;
        }
        return this.func_184188_bt().get(0);
    }

    @Override
    public boolean func_82171_bF() {
        Entity entity = this.func_184179_bs();
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity \u26032 = (PlayerEntity)entity;
        return \u26032.func_184614_ca().func_77973_b() == Items.field_151146_bM || \u26032.func_184592_cb().func_77973_b() == Items.field_151146_bM;
    }

    @Override
    public void func_184206_a(DataParameter<?> dataParameter) {
        if (field_191520_bx.equals(dataParameter) && this.field_70170_p.field_72995_K) {
            this.field_184765_bx = true;
            this.field_184766_bz = 0;
            this.field_184767_bA = this.field_70180_af.func_187225_a(field_191520_bx);
        }
        super.func_184206_a(dataParameter);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184763_bv, false);
        this.field_70180_af.func_187214_a(field_191520_bx, 0);
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        compoundNBT.func_74757_a("Saddle", this.func_70901_n());
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
        this.func_70900_e(compoundNBT.func_74767_n("Saddle"));
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187697_dL;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_187703_dN;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187700_dM;
    }

    @Override
    protected void func_180429_a(BlockPos blockPos, BlockState blockState) {
        this.func_184185_a(SoundEvents.field_187709_dP, 0.15f, 1.0f);
    }

    @Override
    public boolean func_184645_a(PlayerEntity playerEntity, Hand hand) {
        if (!super.func_184645_a(playerEntity, hand)) {
            ItemStack itemStack = playerEntity.func_184586_b(hand);
            if (itemStack.func_77973_b() == Items.field_151057_cb) {
                itemStack.func_111282_a(playerEntity, this, hand);
                return true;
            }
            if (this.func_70901_n() && !this.func_184207_aI()) {
                if (!this.field_70170_p.field_72995_K) {
                    playerEntity.func_184220_m(this);
                }
                return true;
            }
            return itemStack.func_77973_b() == Items.field_151141_av && itemStack.func_111282_a(playerEntity, this, hand);
        }
        return true;
    }

    @Override
    protected void func_213337_cE() {
        super.func_213337_cE();
        if (this.func_70901_n()) {
            this.func_199703_a(Items.field_151141_av);
        }
    }

    public boolean func_70901_n() {
        return this.field_70180_af.func_187225_a(field_184763_bv);
    }

    public void func_70900_e(boolean bl) {
        if (bl) {
            this.field_70180_af.func_187227_b(field_184763_bv, true);
        } else {
            this.field_70180_af.func_187227_b(field_184763_bv, false);
        }
    }

    @Override
    public void func_70077_a(LightningBoltEntity lightningBoltEntity) {
        ZombiePigmanEntity zombiePigmanEntity = EntityType.field_200785_Y.func_200721_a(this.field_70170_p);
        zombiePigmanEntity.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack(Items.field_151010_B));
        zombiePigmanEntity.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
        zombiePigmanEntity.func_94061_f(this.func_175446_cd());
        if (this.func_145818_k_()) {
            zombiePigmanEntity.func_200203_b(this.func_200201_e());
            zombiePigmanEntity.func_174805_g(this.func_174833_aM());
        }
        this.field_70170_p.func_217376_c(zombiePigmanEntity);
        this.func_70106_y();
    }

    @Override
    public void func_213352_e(Vec3d vec3d) {
        if (!this.func_70089_S()) {
            return;
        }
        Entity entity = \u2603 = this.func_184188_bt().isEmpty() ? null : this.func_184188_bt().get(0);
        if (!this.func_184207_aI() || !this.func_82171_bF()) {
            this.field_70138_W = 0.5f;
            this.field_70747_aH = 0.02f;
            super.func_213352_e(vec3d);
            return;
        }
        this.field_70126_B = this.field_70177_z = \u2603.field_70177_z;
        this.field_70125_A = \u2603.field_70125_A * 0.5f;
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
        this.field_70761_aq = this.field_70177_z;
        this.field_70759_as = this.field_70177_z;
        this.field_70138_W = 1.0f;
        this.field_70747_aH = this.func_70689_ay() * 0.1f;
        if (this.field_184765_bx && this.field_184766_bz++ > this.field_184767_bA) {
            this.field_184765_bx = false;
        }
        if (this.func_184186_bw()) {
            float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 0.225f;
            if (this.field_184765_bx) {
                f += f * 1.15f * MathHelper.func_76126_a((float)this.field_184766_bz / (float)this.field_184767_bA * (float)Math.PI);
            }
            this.func_70659_e(f);
            super.func_213352_e(new Vec3d(0.0, 0.0, 1.0));
            this.field_70716_bi = 0;
        } else {
            this.func_213317_d(Vec3d.field_186680_a);
        }
        this.field_184618_aE = this.field_70721_aZ;
        double d = this.func_226277_ct_() - this.field_70169_q;
        \u2603 = this.func_226281_cx_() - this.field_70166_s;
        float \u26032 = MathHelper.func_76133_a(d * d + \u2603 * \u2603) * 4.0f;
        if (\u26032 > 1.0f) {
            \u26032 = 1.0f;
        }
        this.field_70721_aZ += (\u26032 - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    public boolean func_184762_da() {
        if (this.field_184765_bx) {
            return false;
        }
        this.field_184765_bx = true;
        this.field_184766_bz = 0;
        this.field_184767_bA = this.func_70681_au().nextInt(841) + 140;
        this.func_184212_Q().func_187227_b(field_191520_bx, this.field_184767_bA);
        return true;
    }

    @Override
    public PigEntity func_90011_a(AgeableEntity ageableEntity) {
        return EntityType.field_200784_X.func_200721_a(this.field_70170_p);
    }

    @Override
    public boolean func_70877_b(ItemStack itemStack) {
        return field_184764_bw.test(itemStack);
    }

    @Override
    public /* synthetic */ AgeableEntity func_90011_a(AgeableEntity ageableEntity) {
        return this.func_90011_a(ageableEntity);
    }
}

