/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SwordItem;
import net.minecraft.item.ToolItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.util.FakeCreeper;
import stepsword.mahoutsukai.util.FakeSkeleton;
import stepsword.mahoutsukai.util.FakeSpider;

public class GateWeaponProjectileEntity
extends ArrowEntity
implements IProjectile {
    public static final String entityName = "gate_weapon_projectile_entity";
    private static final DataParameter<ItemStack> ITEM = EntityDataManager.func_187226_a(GateWeaponProjectileEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<Float> PROGRESS = EntityDataManager.func_187226_a(GateWeaponProjectileEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private float progress = 0.0f;
    public float lastProgress = 0.0f;

    public GateWeaponProjectileEntity(FMLPlayMessages.SpawnEntity packet, World worldIn) {
        super(ModEntities.GATE_WEAPON_PROJECTILE, worldIn);
        this.field_70158_ak = true;
    }

    public GateWeaponProjectileEntity(World worldIn) {
        super(ModEntities.GATE_WEAPON_PROJECTILE, worldIn);
        this.field_70158_ak = true;
        this.setStack(new ItemStack((IItemProvider)Items.field_151040_l));
    }

    public GateWeaponProjectileEntity(World worldIn, double x, double y, double z, ItemStack stack, Entity e) {
        this(worldIn);
        this.field_70158_ak = true;
        this.func_70107_b(x, y, z);
        this.setStack(stack);
        this.field_70251_a = AbstractArrowEntity.PickupStatus.DISALLOWED;
        this.func_212361_a(e);
    }

    public GateWeaponProjectileEntity(EntityType entityEntityType, World world) {
        super(entityEntityType, world);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(ITEM, (Object)new ItemStack((IItemProvider)Items.field_151040_l));
        this.func_184212_Q().func_187214_a(PROGRESS, (Object)Float.valueOf(0.0f));
        super.func_70088_a();
    }

    public void func_213281_b(CompoundNBT nbt) {
        if (this.getStack() != null) {
            nbt.func_218657_a("stackNBT", (INBT)this.getStack().serializeNBT());
        }
        nbt.func_74776_a("progress", this.progress);
        super.func_213281_b(nbt);
    }

    public void func_70037_a(CompoundNBT nbt) {
        if (nbt.func_74764_b("stackNBT")) {
            ItemStack stack = ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)nbt.func_74781_a("stackNBT")));
            stack.func_190920_e(1);
            this.setStack(stack);
        }
        this.progress = nbt.func_74760_g("progress");
        super.func_70037_a(nbt);
    }

    protected ItemStack func_184550_j() {
        return this.getStack();
    }

    public float getProgress() {
        return this.progress;
    }

    public void setProgress(float v) {
        this.progress = v;
    }

    protected void func_213868_a(EntityRayTraceResult result) {
        double d = this.func_213322_ci().func_72433_c();
        double damage = MathHelper.func_76143_f((double)d);
        Entity entity = result.func_216348_a();
        if (this.field_70170_p instanceof ServerWorld) {
            FakePlayer fake_player = new FakePlayer((ServerWorld)this.field_70170_p, new GameProfile(UUID.randomUUID(), "faker"));
            fake_player.func_184611_a(Hand.MAIN_HAND, this.func_184550_j());
            fake_player.func_110140_aT().func_111147_b(this.func_184550_j().func_111283_C(EquipmentSlotType.MAINHAND));
            FakeSkeleton target1 = new FakeSkeleton(this.field_70170_p);
            FakeCreeper target2 = new FakeCreeper(this.field_70170_p);
            FakeSpider target3 = new FakeSpider(this.field_70170_p);
            int initial = 5000000;
            target1.h = initial;
            target2.h = initial;
            target3.h = initial;
            try {
                ObfuscationReflectionHelper.setPrivateValue(LivingEntity.class, (Object)fake_player, (Object)1000, (String)"field_184617_aD");
            }
            catch (Exception e) {
                try {
                    ObfuscationReflectionHelper.setPrivateValue(LivingEntity.class, (Object)fake_player, (Object)1000, (String)"ticksSinceLastSwing");
                }
                catch (Exception e2) {
                    System.out.println(e2.toString());
                }
            }
            fake_player.func_71059_n((Entity)target1);
            try {
                ObfuscationReflectionHelper.setPrivateValue(LivingEntity.class, (Object)fake_player, (Object)1000, (String)"field_184617_aD");
            }
            catch (Exception e) {
                try {
                    ObfuscationReflectionHelper.setPrivateValue(LivingEntity.class, (Object)fake_player, (Object)1000, (String)"ticksSinceLastSwing");
                }
                catch (Exception e2) {
                    System.out.println(e2.toString());
                }
            }
            fake_player.func_71059_n((Entity)target2);
            try {
                ObfuscationReflectionHelper.setPrivateValue(LivingEntity.class, (Object)fake_player, (Object)1000, (String)"field_184617_aD");
            }
            catch (Exception e) {
                try {
                    ObfuscationReflectionHelper.setPrivateValue(LivingEntity.class, (Object)fake_player, (Object)1000, (String)"ticksSinceLastSwing");
                }
                catch (Exception e2) {
                    System.out.println(e2.toString());
                }
            }
            fake_player.func_71059_n((Entity)target3);
            damage += (double)Math.min((float)initial - target1.h, Math.min((float)initial - target2.h, (float)initial - target3.h));
        }
        damage += 3.0;
        Item item = this.func_184550_j().func_77973_b();
        if (item instanceof SwordItem) {
            damage += (double)((SwordItem)item).func_200894_d() + 3.0;
        } else if (item instanceof ToolItem) {
            damage += 1.0;
        }
        DamageSource damagesource = this.field_70250_c == null ? DamageSource.func_76353_a((AbstractArrowEntity)this, (Entity)this) : DamageSource.func_76353_a((AbstractArrowEntity)this, (Entity)this.field_70170_p.func_217371_b(this.field_70250_c));
        if (entity.func_70097_a(damagesource, (float)damage)) {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                this.func_184548_a(livingEntity);
                PlayerEntity shooter = null;
                if (this.field_70250_c != null) {
                    shooter = this.field_70170_p.func_217371_b(this.field_70250_c);
                }
                if (shooter != null && entity != shooter && livingEntity instanceof PlayerEntity && shooter instanceof ServerPlayerEntity) {
                    ((ServerPlayerEntity)shooter).field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(6, 0.0f));
                }
            }
            this.func_184185_a(SoundEvents.field_187731_t, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
        } else {
            this.func_213317_d(this.func_213322_ci().func_186678_a((double)-0.1f));
            this.field_70177_z += 180.0f;
            this.field_70126_B += 180.0f;
        }
    }

    public void func_70071_h_() {
        this.lastProgress = this.getProgress();
        float progressCap = this.getProgressCap();
        if (this.getProgress() > progressCap) {
            super.func_70071_h_();
        } else {
            if (this.field_70254_i) {
                this.setProgress(this.getProgressCap() + 1.0f);
            }
            float speed = this.getProgressSpeed();
            this.setProgress(this.getProgress() + progressCap / speed);
            Vec3d z = this.func_213322_ci();
            z = z.func_72432_b().func_186678_a((double)(progressCap / speed));
            z = z.func_178787_e(this.func_174791_d());
            this.func_70107_b(z.field_72450_a, z.field_72448_b, z.field_72449_c);
        }
    }

    public void func_70100_b_(PlayerEntity player) {
    }

    public ItemStack getStack() {
        return (ItemStack)this.func_184212_Q().func_187225_a(ITEM);
    }

    public void setStack(ItemStack stack) {
        this.func_184212_Q().func_187227_b(ITEM, (Object)stack);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public AxisAlignedBB func_184177_bl() {
        return new AxisAlignedBB(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public void setProgress() {
        this.setProgress(this.progress);
    }

    public float getProgressCap() {
        return 4.0f;
    }

    public float getProgressSpeed() {
        return (float)MTConfig.TREASURY_PROJECTION_SPEED;
    }
}

