/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.effects.projection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.capability.worldsave.MahouSavedData;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.dimensions.ModDimensions;
import stepsword.mahoutsukai.effects.projection.ProjectionSpellEffect;
import stepsword.mahoutsukai.entity.WeaponProjectileEntity;
import stepsword.mahoutsukai.util.MahouTsukaiTeleporter;
import stepsword.mahoutsukai.util.Utils;

public class RealityMarbleSpellEffect {
    public static final int distance = 3000;
    public static Random random = new Random(53L);

    public static LivingEntity getEnemy(PlayerEntity player) {
        Entity e = ProjectionSpellEffect.playerLook((LivingEntity)player, MTConfig.GLOBAL_LOOK_RANGE, player.field_70170_p, ProjectionSpellEffect.getProjectionLookPredicate());
        if (e instanceof LivingEntity) {
            return (LivingEntity)e;
        }
        return null;
    }

    public static BlockPos getRealityMarbleSpawn(World world, UUID uuid) {
        MahouSavedData save = new MahouSavedData(world);
        BlockPos pos = save.getPlayerSpawn(uuid);
        if (pos == null) {
            pos = RealityMarbleSpellEffect.generateRealityMarbleSpawn(world, save, uuid);
        }
        return pos;
    }

    public static BlockPos generateRealityMarbleSpawn(World world, MahouSavedData save, UUID uuid) {
        HashMap<UUID, BlockPos> spawns = save.getAllSpawns();
        int maxX = 0;
        int maxZ = 0;
        if (spawns != null) {
            BlockPos pos;
            for (UUID tmp : spawns.keySet()) {
                pos = spawns.get(tmp);
                if (pos.func_177958_n() > maxX) {
                    maxX = pos.func_177958_n();
                }
                if (pos.func_177952_p() <= maxZ) continue;
                maxZ = pos.func_177952_p();
            }
            if (Math.random() < 0.5) {
                maxX += 3000;
            } else {
                maxZ += 3000;
            }
            pos = new BlockPos(maxX, 120, maxZ);
            save.changePlayerSpawn(uuid, pos);
            return pos;
        }
        return null;
    }

    public static boolean goToMarble(PlayerEntity user) {
        IMahou casterMahou = Utils.getPlayerMahou((LivingEntity)user);
        if (casterMahou != null) {
            BlockPos pos;
            boolean inmarble = user.field_70170_p.field_73011_w.func_186058_p().getRegistryName().equals((Object)ModDimensions.MARBLE_TYPE);
            if (user.field_71093_bK == null || inmarble) {
                casterMahou.setPlayerOldDimension(DimensionType.field_223227_a_.getRegistryName().toString());
            } else {
                casterMahou.setPlayerOldDimension(user.field_71093_bK.getRegistryName().toString());
            }
            if (user.field_71093_bK != null && !inmarble) {
                casterMahou.setPlayerSavedSpawn(user.func_180425_c());
            }
            if (casterMahou.getPlayerMarbleSpawn() == null) {
                casterMahou.setPlayerMarbleSpawn(RealityMarbleSpellEffect.getRealityMarbleSpawn(user.field_70170_p, user.func_110124_au()));
            }
            if ((pos = casterMahou.getPlayerMarbleSpawn()) == null) {
                return false;
            }
            LivingEntity e = RealityMarbleSpellEffect.getEnemy(user);
            PlayerManaManager.updateClientMahou((ServerPlayerEntity)user, casterMahou);
            MahouTsukaiTeleporter.teleport((Entity)user, DimensionType.func_193417_a((ResourceLocation)ModDimensions.MARBLE_TYPE), new BlockPos(pos.func_177958_n(), 120, pos.func_177952_p()));
            if (e != null) {
                IMahou enemyMahou;
                if (e instanceof ServerPlayerEntity && !inmarble && (enemyMahou = Utils.getPlayerMahou(e)) != null) {
                    enemyMahou.setPlayerOldDimension(e.field_71093_bK.getRegistryName().toString());
                    enemyMahou.setPlayerSavedSpawn(user.func_180425_c());
                    PlayerManaManager.updateClientMahou((ServerPlayerEntity)e, enemyMahou);
                    enemyMahou.setEnemy(user.func_110124_au());
                }
                casterMahou.setEnemy(e.func_110124_au());
                MahouTsukaiTeleporter.teleport((Entity)e, DimensionType.func_193417_a((ResourceLocation)ModDimensions.MARBLE_TYPE), new BlockPos(pos.func_177958_n() + 20, 120, pos.func_177952_p()));
            }
        }
        return true;
    }

    public static void spawnSwords(BlockPos userSpawn, World world, IChunk chunk, int size_count, int distance) {
        int startZ;
        int endZ;
        int startX;
        int endX;
        if (random == null) {
            random = new Random(42L);
        }
        int ux = endX = (startX = userSpawn.func_177958_n());
        int uz = endZ = (startZ = userSpawn.func_177952_p());
        int y = 100;
        startZ -= (size_count + 1) * distance - random.nextInt(distance);
        endX += (size_count + 1) * distance + random.nextInt(distance);
        endZ += (size_count + 1) * distance + random.nextInt(distance);
        ArrayList<WeaponProjectileEntity> spawns = new ArrayList<WeaponProjectileEntity>();
        for (int i = startX -= (size_count + 1) * distance - random.nextInt(distance); i <= endX; i += distance) {
            for (int j = startZ; j <= endZ; j += distance) {
                boolean inrange;
                boolean bl = inrange = i <= chunk.func_76632_l().func_180332_e() && i >= chunk.func_76632_l().func_180334_c() && j <= chunk.func_76632_l().func_180330_f() && j >= chunk.func_76632_l().func_180333_d();
                if (MTConfig.MARBLE_SWORD_SPAWN_LIST.size() <= 0 || !inrange) continue;
                double rand = random.nextDouble();
                String name = MTConfig.MARBLE_SWORD_SPAWN_LIST.get(random.nextInt(MTConfig.MARBLE_SWORD_SPAWN_LIST.size()));
                Item item = RealityMarbleSpellEffect.getItemFromName(name);
                if (item == null) {
                    System.out.println("No item with name " + name + " found.");
                    continue;
                }
                ItemStack stack = new ItemStack((IItemProvider)item);
                if (0.6 < rand && rand < 0.8) {
                    stack.func_77966_a(Enchantments.field_185302_k, 2);
                } else if (rand >= 0.8) {
                    stack.func_77966_a(Enchantments.field_180313_o, 2);
                }
                stack.func_196085_b(stack.func_77958_k() - MTConfig.MARBLE_DIMENSION_DURABILITY);
                WeaponProjectileEntity wpe = new WeaponProjectileEntity(world, i, y, j, stack);
                double velx = i < ux ? -0.6 : 0.6;
                double velz = j < uz ? -0.6 : 0.6;
                wpe.func_213293_j(random.nextDouble() * velx, -2.0, random.nextDouble() * velz);
                if (!(random.nextDouble() < MTConfig.MARBLE_DIMENSION_SPAWN_CHANCE)) continue;
                spawns.add(wpe);
            }
        }
        spawns.forEach(weapon -> world.func_73046_m().execute(() -> chunk.func_76612_a((Entity)weapon)));
    }

    public static Item getItemFromName(String s) {
        Item ret = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(s));
        return ret;
    }

    public static void realityMarbleChunkUnload(ChunkEvent.Unload event) {
        IWorld world = event.getChunk().getWorldForge();
        if (world != null && !world.func_201670_d() && world.func_201675_m().func_186058_p().getRegistryName().equals((Object)ModDimensions.MARBLE_TYPE)) {
            IChunk c = event.getChunk();
            ArrayList lst = new ArrayList();
            if (c instanceof Chunk) {
                ClassInheritanceMultiMap[] es = ((Chunk)c).func_177429_s();
                for (int i = 0; i < es.length; ++i) {
                    es[i].forEach(ent -> {
                        if (ent instanceof WeaponProjectileEntity && ent.func_70089_S()) {
                            ent.func_70106_y();
                        }
                    });
                }
            }
        }
    }

    public static void realityMarbleChunkLoad(ChunkEvent.Load event) {
        IWorld world = event.getChunk().getWorldForge();
        if (world != null && !world.func_201670_d() && world.func_201675_m().func_186058_p().getRegistryName().equals((Object)ModDimensions.MARBLE_TYPE)) {
            IChunk c = event.getChunk();
            int x = c.func_76632_l().field_77276_a * 16 + 8;
            int z = c.func_76632_l().field_77275_b * 16 + 8;
            int y = 100;
            RealityMarbleSpellEffect.spawnSwords(new BlockPos(x, y, z), c.getWorldForge().func_201672_e(), c, 1, MTConfig.MARBLE_DIMENSION_SPAWN_RATE);
        }
    }

    public static boolean realityMarbleLivingFall(LivingFallEvent event) {
        boolean ret = false;
        if (!event.getEntityLiving().field_70170_p.field_72995_K && event.getEntityLiving().field_71093_bK.getRegistryName().equals((Object)ModDimensions.MARBLE_TYPE)) {
            ret = true;
        }
        return ret;
    }

    public static void realityMarbleLivingHurt(Entity e) {
        if (e instanceof PlayerEntity && !e.field_70170_p.field_72995_K && e.field_71093_bK.getRegistryName().equals((Object)ModDimensions.MARBLE_TYPE)) {
            if (Utils.getPlayerMahou((LivingEntity)((PlayerEntity)e)) != null) {
                final IMahou mahou = Utils.getPlayerMahou((LivingEntity)((PlayerEntity)e));
                if (mahou != null) {
                    if (mahou.getEnemy() != null && e.field_70170_p.func_217371_b(mahou.getEnemy()) == null) {
                        boolean flag = true;
                        double range = 500.0;
                        List lst = e.field_70170_p.func_175647_a(LivingEntity.class, new AxisAlignedBB(e.func_180425_c().func_177963_a(-range, -range, -range), e.func_180425_c().func_177963_a(range, range, range)), (Predicate)new com.google.common.base.Predicate<LivingEntity>(){

                            public boolean apply(@Nullable LivingEntity e) {
                                return e != null && e.func_110124_au().equals(mahou.getEnemy());
                            }
                        });
                        flag = lst.isEmpty();
                        if (flag) {
                            mahou.setEnemy(null);
                        }
                    }
                    if (mahou.getEnemy() == null) {
                        BlockPos pos = mahou.getPlayerSavedSpawn();
                        String dimension = mahou.getPlayerOldDimension().equals(ModDimensions.MARBLE_TYPE.toString()) ? DimensionType.field_223227_a_.getRegistryName().toString() : mahou.getPlayerOldDimension();
                        MahouTsukaiTeleporter.teleport(e, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), DimensionType.func_193417_a((ResourceLocation)new ResourceLocation(dimension)));
                    }
                }
            } else {
                BlockPos bed = ((PlayerEntity)e).func_180470_cg();
                MahouTsukaiTeleporter.teleport(e, bed.func_177958_n(), bed.func_177956_o(), bed.func_177952_p(), ((PlayerEntity)e).getSpawnDimension());
            }
        }
    }
}

