/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.effects.displacement;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.util.MahouTsukaiTeleporter;
import stepsword.mahoutsukai.util.Utils;

public class ProtectiveDisplacementSpellEffect {
    public static boolean addProtectionToUser(PlayerEntity player) {
        IMahou mahou;
        if (player != null && (mahou = Utils.getPlayerMahou((LivingEntity)player)) != null) {
            mahou.setProtectiveDisplacement(mahou.getProtectiveDisplacement() + 5);
            return true;
        }
        return false;
    }

    public static boolean protectiveDisplacementProjectileImpact(ProjectileImpactEvent event) {
        int protD;
        PlayerEntity player;
        IMahou mahou;
        if (!event.getEntity().field_70170_p.field_72995_K && event.getRayTraceResult() != null && event.getRayTraceResult() instanceof EntityRayTraceResult && ((EntityRayTraceResult)event.getRayTraceResult()).func_216348_a() instanceof PlayerEntity && (mahou = Utils.getPlayerMahou((LivingEntity)(player = (PlayerEntity)((EntityRayTraceResult)event.getRayTraceResult()).func_216348_a()))) != null && (protD = mahou.getProtectiveDisplacement()) > 0) {
            for (int i = 0; i < 256 && !ProtectiveDisplacementSpellEffect.teleportRandomly(player, player.field_70170_p); ++i) {
            }
            mahou.setProtectiveDisplacement(protD - 1);
            return true;
        }
        return false;
    }

    protected static boolean teleportRandomly(PlayerEntity player, World world) {
        Random rand = player.func_70681_au();
        double d0 = player.func_226277_ct_() + (rand.nextDouble() - 0.5) * 64.0;
        double d1 = player.func_226278_cu_() + (double)(rand.nextInt(64) - 32);
        double d2 = player.func_226281_cx_() + (rand.nextDouble() - 0.5) * 64.0;
        return ProtectiveDisplacementSpellEffect.teleportTo(d0, d1, d2, player, world);
    }

    private static boolean teleportTo(double x, double y, double z, PlayerEntity player, World world) {
        boolean flag = ProtectiveDisplacementSpellEffect.attemptTeleport(x, y, z, player, world);
        if (flag) {
            world.func_184148_a(null, player.field_70169_q, player.field_70167_r, player.field_70166_s, SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f);
            player.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        }
        return flag;
    }

    public static boolean attemptTeleport(double x, double y, double z, PlayerEntity player, World world) {
        double d0 = x;
        double d1 = y;
        double d2 = z;
        BlockPos bp = new BlockPos(d0, d1, d2);
        BlockState b = world.func_180495_p(bp);
        BlockState b1 = world.func_180495_p(bp.func_177982_a(0, 1, 0));
        BlockState b2 = world.func_180495_p(bp.func_177982_a(0, 2, 0));
        if (Utils.isBlockAir(world, bp.func_177982_a(0, 1, 0)) && Utils.isBlockAir(world, bp.func_177982_a(0, 2, 0)) && !Utils.isBlockAir(world, bp)) {
            MahouTsukaiTeleporter.teleport((Entity)player, d0, d1 + 1.0, d2, player.field_71093_bK);
            return true;
        }
        return false;
    }
}

