/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ModuleTools {
    public static boolean hasModuleTarget(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return false;
        }
        return stack.func_77978_p().func_74764_b("monitorx");
    }

    public static void setPositionInModule(ItemStack stack, DimensionType dimension, BlockPos pos, String name) {
        CompoundNBT tag = stack.func_196082_o();
        if (dimension != null) {
            tag.func_74778_a("monitordim", dimension.getRegistryName().toString());
        }
        if (name != null) {
            tag.func_74778_a("monitorname", name);
        }
        tag.func_74768_a("monitorx", pos.func_177958_n());
        tag.func_74768_a("monitory", pos.func_177956_o());
        tag.func_74768_a("monitorz", pos.func_177952_p());
    }

    public static void clearPositionInModule(ItemStack stack) {
        CompoundNBT tag = stack.func_196082_o();
        tag.func_82580_o("monitordim");
        tag.func_82580_o("monitorx");
        tag.func_82580_o("monitory");
        tag.func_82580_o("monitorz");
        tag.func_82580_o("monitorname");
    }

    public static BlockPos getPositionFromModule(ItemStack stack) {
        CompoundNBT tag = stack.func_196082_o();
        int monitorx = tag.func_74762_e("monitorx");
        int monitory = tag.func_74762_e("monitory");
        int monitorz = tag.func_74762_e("monitorz");
        return new BlockPos(monitorx, monitory, monitorz);
    }

    public static DimensionType getDimensionFromModule(ItemStack stack) {
        CompoundNBT tag = stack.func_196082_o();
        if (tag.func_74764_b("monitordim")) {
            String monitordim = tag.func_74779_i("monitordim");
            return DimensionType.func_193417_a((ResourceLocation)new ResourceLocation(monitordim));
        }
        return null;
    }

    public static String getTargetString(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null && tag.func_74764_b("monitorx")) {
            int monitorx = tag.func_74762_e("monitorx");
            int monitory = tag.func_74762_e("monitory");
            int monitorz = tag.func_74762_e("monitorz");
            String monitorname = tag.func_74779_i("monitorname");
            String monitordim = tag.func_74779_i("monitordim");
            if (!monitordim.isEmpty()) {
                return monitorname + " (at " + monitorx + "," + monitory + "," + monitorz + ", " + monitordim + ")";
            }
            return monitorname + " (at " + monitorx + "," + monitory + "," + monitorz + ")";
        }
        return "<unset>";
    }

    public static boolean installModule(PlayerEntity player, ItemStack heldItem, Hand hand, BlockPos pos, int start, int stop) {
        World world = player.func_130014_f_();
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            return false;
        }
        return (Boolean)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(inventory -> {
            for (int i = start; i <= stop; ++i) {
                if (!inventory.getStackInSlot(i).func_190926_b()) continue;
                ItemStack copy = heldItem.func_77946_l();
                copy.func_190920_e(1);
                if (!(inventory instanceof IItemHandlerModifiable)) {
                    throw new IllegalStateException("Not an IItemHandlerModifiable!");
                }
                ((IItemHandlerModifiable)inventory).setStackInSlot(i, copy);
                heldItem.func_190918_g(1);
                if (heldItem.func_190926_b()) {
                    player.func_184611_a(hand, ItemStack.field_190927_a);
                }
                if (world.field_72995_K) {
                    player.func_146105_b((ITextComponent)new StringTextComponent("Installed module"), false);
                }
                return true;
            }
            return false;
        }).orElse((Object)false);
    }
}

