/*
 * Decompiled with CFR 0.152.
 */
package traverse.rockcandy.items;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import traverse.rockcandy.items.BaseUsableGem;
import traverse.rockcandy.registry.ModItems;

public class ItemCandyDispenser
extends BaseUsableGem {
    public ItemCandyDispenser() {
        super("candy_dispenser", 50);
    }

    public UseAction func_77661_b(ItemStack p_77661_1_) {
        return UseAction.EAT;
    }

    public int func_77626_a(ItemStack p_77626_1_) {
        return 8;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (stack.func_77952_i() != stack.func_77958_k() - 1 && playerIn.func_71024_bL().func_75121_c()) {
            playerIn.func_184598_c(handIn);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entityLiving) {
        if (entityLiving instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entityLiving;
            player.func_71024_bL().func_75122_a(3, 0.3f);
            worldIn.func_184148_a(null, (double)player.func_180425_c().func_177958_n(), (double)player.func_180425_c().func_177956_o(), (double)player.func_180425_c().func_177952_p(), SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.9f);
            stack.func_222118_a(1, (LivingEntity)player, entity -> {});
        }
        return stack;
    }

    public void func_77663_a(ItemStack itemStack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (worldIn.func_201670_d()) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entityIn;
        for (int i = 0; player.field_71071_by.func_70302_i_() > i; ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_77973_b() != this || !(stack.func_77973_b() instanceof BaseUsableGem) || !this.isActive(stack)) continue;
            this.absorbCandy(stack, (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null));
        }
    }

    public void absorbCandy(ItemStack rockStack, IItemHandler inventory) {
        int damage = rockStack.func_77952_i();
        if (damage != 0) {
            for (int i = 0; inventory.getSlots() > i; ++i) {
                ItemStack candyStack;
                ItemStack stack = inventory.getStackInSlot(i);
                if (stack.func_77973_b() == ModItems.RAW_CANDY) {
                    candyStack = inventory.extractItem(i, 1, false);
                    this.setDamage(rockStack, damage - candyStack.func_190916_E());
                    return;
                }
                if (stack.func_77973_b() != ModItems.HARDEN_CANDY) continue;
                candyStack = inventory.extractItem(i, 1, false);
                this.setDamage(rockStack, damage - candyStack.func_190916_E() - 3);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new StringTextComponent(stack.func_77958_k() - stack.func_77973_b().getDamage(stack) + "/" + stack.func_77958_k() + " Charges"));
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }
}

