/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.generators;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.state.IProperty;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.IGeneratedBlockstate;

public final class MultiPartBlockStateBuilder
implements IGeneratedBlockstate {
    private final List<PartBuilder> parts = new ArrayList<PartBuilder>();
    private final Block owner;

    public MultiPartBlockStateBuilder(Block owner) {
        this.owner = owner;
    }

    public ConfiguredModel.Builder<PartBuilder> part() {
        return ConfiguredModel.builder(this);
    }

    MultiPartBlockStateBuilder addPart(PartBuilder part) {
        this.parts.add(part);
        return this;
    }

    @Override
    public JsonObject toJson() {
        JsonArray variants = new JsonArray();
        for (PartBuilder part : this.parts) {
            variants.add((JsonElement)part.toJson());
        }
        JsonObject main = new JsonObject();
        main.add("multipart", (JsonElement)variants);
        return main;
    }

    public class PartBuilder {
        public BlockStateProvider.ConfiguredModelList models;
        public boolean useOr;
        public final Multimap<IProperty<?>, Comparable<?>> conditions = HashMultimap.create();

        PartBuilder(BlockStateProvider.ConfiguredModelList models) {
            this.models = models;
        }

        public PartBuilder useOr() {
            this.useOr = true;
            return this;
        }

        @SafeVarargs
        public final <T extends Comparable<T>> PartBuilder condition(IProperty<T> prop, T ... values) {
            Preconditions.checkNotNull(prop, (Object)"Property must not be null");
            Preconditions.checkNotNull(values, (Object)"Value list must not be null");
            Preconditions.checkArgument((values.length > 0 ? 1 : 0) != 0, (Object)"Value list must not be empty");
            Preconditions.checkArgument((!this.conditions.containsKey(prop) ? 1 : 0) != 0, (String)"Cannot set condition for property \"%s\" more than once", (Object)prop.func_177701_a());
            Preconditions.checkArgument((boolean)this.canApplyTo(MultiPartBlockStateBuilder.this.owner), (String)"IProperty %s is not valid for the block %s", prop, (Object)MultiPartBlockStateBuilder.this.owner);
            this.conditions.putAll(prop, Arrays.asList(values));
            return this;
        }

        public MultiPartBlockStateBuilder end() {
            return MultiPartBlockStateBuilder.this;
        }

        JsonObject toJson() {
            JsonObject out = new JsonObject();
            if (!this.conditions.isEmpty()) {
                JsonObject when = new JsonObject();
                for (Map.Entry e : this.conditions.asMap().entrySet()) {
                    StringBuilder activeString = new StringBuilder();
                    for (Comparable val : (Collection)e.getValue()) {
                        if (activeString.length() > 0) {
                            activeString.append("|");
                        }
                        activeString.append(((IProperty)e.getKey()).func_177702_a(val));
                    }
                    when.addProperty(((IProperty)e.getKey()).func_177701_a(), activeString.toString());
                }
                if (this.useOr) {
                    JsonObject innerWhen = when;
                    when = new JsonObject();
                    when.add("OR", (JsonElement)innerWhen);
                }
                out.add("when", (JsonElement)when);
            }
            out.add("apply", this.models.toJSON());
            return out;
        }

        public boolean canApplyTo(Block b) {
            return b.func_176194_O().func_177623_d().containsAll(this.conditions.keySet());
        }
    }
}

