/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.loot.condition;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraftforge.common.BiomeDictionary;

public class CheckBiomeTag
implements ILootCondition {
    public static final Serializer SERIALIZER = new Serializer();
    private final BiomeDictionary.Type biomeType;

    public CheckBiomeTag(BiomeDictionary.Type type) {
        this.biomeType = type;
    }

    public boolean test(LootContext ctx) {
        Biome biome;
        BlockPos pos = (BlockPos)ctx.func_216031_c(LootParameters.field_216286_f);
        if (pos != null && (biome = ctx.func_202879_g().func_226691_t_(pos)) != null) {
            return BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)this.biomeType);
        }
        return false;
    }

    static class Serializer
    extends ILootCondition.AbstractSerializer<CheckBiomeTag> {
        Serializer() {
            super(new ResourceLocation("bookshelf", "check_biome_tag"), CheckBiomeTag.class);
        }

        public void serialize(JsonObject json, CheckBiomeTag value, JsonSerializationContext context) {
            json.addProperty("tag", value.biomeType.getName());
        }

        public CheckBiomeTag deserialize(JsonObject json, JsonDeserializationContext context) {
            BiomeDictionary.Type tag = BiomeDictionary.Type.getType((String)JSONUtils.func_151200_h((JsonObject)json, (String)"tag"), (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
            return new CheckBiomeTag(tag);
        }
    }
}

