/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.container;

import javax.annotation.Nullable;
import net.blay09.mods.refinedrelocation.api.RefinedRelocationAPI;
import net.blay09.mods.refinedrelocation.api.container.IContainerMessage;
import net.blay09.mods.refinedrelocation.api.container.IContainerReturnable;
import net.blay09.mods.refinedrelocation.api.container.ReturnCallback;
import net.blay09.mods.refinedrelocation.container.FilterContainer;
import net.blay09.mods.refinedrelocation.container.ModContainers;
import net.blay09.mods.refinedrelocation.filter.NameFilter;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class NameFilterContainer
extends FilterContainer
implements IContainerReturnable {
    public static final String KEY_VALUE = "Value";
    private final PlayerEntity player;
    private final TileEntity tileEntity;
    private final NameFilter filter;
    private final int rootFilterIndex;
    private String lastValue = "";
    private boolean guiNeedsUpdate;
    private ReturnCallback returnCallback;

    public NameFilterContainer(int windowId, PlayerInventory playerInventory, TileEntity tileEntity, int rootFilterIndex, NameFilter filter) {
        super(ModContainers.nameFilter, windowId);
        this.player = playerInventory.field_70458_d;
        this.tileEntity = tileEntity;
        this.rootFilterIndex = rootFilterIndex;
        this.filter = filter;
        this.addPlayerInventory(playerInventory, 8, 128);
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (!this.lastValue.equals(this.filter.getValue())) {
            RefinedRelocationAPI.syncContainerValue(KEY_VALUE, this.filter.getValue(), (Iterable<IContainerListener>)this.field_75149_d);
            RefinedRelocationAPI.updateFilterPreview(this.player, this.tileEntity, this.filter);
            this.lastValue = this.filter.getValue();
        }
    }

    @Override
    public void receivedMessageClient(IContainerMessage message) {
        if (message.getKey().equals(KEY_VALUE)) {
            this.filter.setValue(message.getStringValue());
            this.markGuiNeedsUpdate(true);
        }
    }

    @Override
    public void receivedMessageServer(IContainerMessage message) {
        if (message.getKey().equals(KEY_VALUE)) {
            this.filter.setValue(message.getStringValue());
            this.tileEntity.func_70296_d();
            this.lastValue = this.filter.getValue();
            RefinedRelocationAPI.updateFilterPreview(this.player, this.tileEntity, this.filter);
        }
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, PlayerEntity player) {
        ItemStack itemStack = super.func_184996_a(slotId, dragType, clickTypeIn, player);
        RefinedRelocationAPI.updateFilterPreview(player, this.tileEntity, this.filter);
        return itemStack;
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack itemStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            itemStack = slotStack.func_77946_l();
            if (index < 27 ? !this.func_75135_a(slotStack, 27, this.field_75151_b.size(), true) : !this.func_75135_a(slotStack, 0, 27, false)) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemStack;
    }

    public void sendValueToServer(String value) {
        RefinedRelocationAPI.sendContainerMessageToServer(KEY_VALUE, value);
    }

    public String getValue() {
        return this.filter.getValue();
    }

    public void markGuiNeedsUpdate(boolean dirty) {
        this.guiNeedsUpdate = dirty;
    }

    public boolean doesGuiNeedUpdate() {
        return this.guiNeedsUpdate;
    }

    @Override
    public TileEntity getTileEntity() {
        return this.tileEntity;
    }

    @Override
    public void setReturnCallback(@Nullable ReturnCallback callback) {
        this.returnCallback = callback;
    }

    @Override
    @Nullable
    public ReturnCallback getReturnCallback() {
        return this.returnCallback;
    }

    @Override
    public int getRootFilterIndex() {
        return this.rootFilterIndex;
    }
}

