/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.block;

import javax.annotation.Nullable;
import net.blay09.mods.refinedrelocation.api.Capabilities;
import net.blay09.mods.refinedrelocation.tile.TileSortingConnector;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class SortingConnectorBlock
extends ContainerBlock {
    public static final String name = "sorting_connector";
    public static final ResourceLocation registryName = new ResourceLocation("refinedrelocation", "sorting_connector");
    private static final VoxelShape CENTER_SHAPE = Block.func_208617_a((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    private static final VoxelShape[] FACING_SHAPES = new VoxelShape[]{Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)5.0, (double)11.0), Block.func_208617_a((double)5.0, (double)11.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0), Block.func_208617_a((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)5.0), Block.func_208617_a((double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0, (double)16.0), Block.func_208617_a((double)0.0, (double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0), Block.func_208617_a((double)11.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0)};
    private static final BooleanProperty DOWN = BooleanProperty.func_177716_a((String)"down");
    private static final BooleanProperty UP = BooleanProperty.func_177716_a((String)"up");
    private static final BooleanProperty NORTH = BooleanProperty.func_177716_a((String)"north");
    private static final BooleanProperty SOUTH = BooleanProperty.func_177716_a((String)"south");
    private static final BooleanProperty WEST = BooleanProperty.func_177716_a((String)"west");
    private static final BooleanProperty EAST = BooleanProperty.func_177716_a((String)"east");
    private static final BooleanProperty CORNER = BooleanProperty.func_177716_a((String)"corner");
    public static final BooleanProperty[] CONNECTIONS = new BooleanProperty[]{DOWN, UP, NORTH, SOUTH, WEST, EAST};

    public SortingConnectorBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_185852_e).func_200943_b(0.3f));
        BlockState state = this.func_176223_P();
        for (BooleanProperty property : CONNECTIONS) {
            state = (BlockState)state.func_206870_a((IProperty)property, (Comparable)Boolean.valueOf(false));
        }
        this.func_180632_j(state);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        VoxelShape boundingBox = CENTER_SHAPE;
        for (int i = 0; i < CONNECTIONS.length; ++i) {
            BooleanProperty property = CONNECTIONS[i];
            if (!((Boolean)state.func_177229_b((IProperty)property)).booleanValue()) continue;
            boundingBox = VoxelShapes.func_197872_a((VoxelShape)boundingBox, (VoxelShape)FACING_SHAPES[i]);
        }
        return boundingBox;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{DOWN, UP, NORTH, SOUTH, WEST, EAST, CORNER});
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean wat) {
        super.func_220069_a(state, world, pos, block, fromPos, wat);
        BlockState newState = this.getConnectionState((IBlockReader)world, pos, state);
        if (newState != state) {
            world.func_180501_a(pos, newState, 3);
        }
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.getConnectionState((IBlockReader)context.func_195991_k(), context.func_195995_a(), this.func_176223_P());
    }

    private BlockState getConnectionState(IBlockReader world, BlockPos pos, BlockState state) {
        Direction.Axis axis = null;
        boolean isCorner = false;
        int connectionCount = 0;
        for (Direction facing : Direction.values()) {
            BlockPos neighbourPos = pos.func_177972_a(facing);
            TileEntity tileEntity = world.func_175625_s(neighbourPos);
            if (tileEntity != null && tileEntity.getCapability(Capabilities.SORTING_GRID_MEMBER, facing.func_176734_d()).isPresent()) {
                state = (BlockState)state.func_206870_a((IProperty)CONNECTIONS[facing.func_176745_a()], (Comparable)Boolean.valueOf(true));
                if (axis != null && axis != facing.func_176740_k()) {
                    isCorner = true;
                }
                axis = facing.func_176740_k();
                ++connectionCount;
                continue;
            }
            state = (BlockState)state.func_206870_a((IProperty)CONNECTIONS[facing.func_176745_a()], (Comparable)Boolean.valueOf(false));
        }
        if (connectionCount == 1) {
            isCorner = true;
        }
        return (BlockState)state.func_206870_a((IProperty)CORNER, (Comparable)Boolean.valueOf(isCorner));
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileSortingConnector();
    }
}

