/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curiousshulkerboxes.common.inventory;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.ShulkerBoxContainer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ShulkerBoxTileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.fml.network.PacketDistributor;
import top.theillusivec4.curios.api.CuriosAPI;
import top.theillusivec4.curiousshulkerboxes.common.capability.CurioShulkerBox;
import top.theillusivec4.curiousshulkerboxes.common.network.NetworkHandler;
import top.theillusivec4.curiousshulkerboxes.common.network.server.SPacketSyncAnimation;

public class CurioShulkerBoxInventory
implements IInventory,
INamedContainerProvider {
    protected NonNullList<ItemStack> items;
    private ItemStack shulkerBox;
    private String identifier;
    private int index;

    public CurioShulkerBoxInventory(ItemStack shulkerBox, String identifier, int index) {
        this.shulkerBox = shulkerBox;
        this.identifier = identifier;
        this.index = index;
        this.items = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_174889_b(@Nonnull PlayerEntity player) {
        if (!player.func_175149_v()) {
            CompoundNBT tag = this.shulkerBox.func_179543_a("BlockEntityTag");
            if (tag != null) {
                if (tag.func_150297_b("LootTable", 8)) {
                    String lootTable = tag.func_74779_i("LootTable");
                    long lootSeed = tag.func_74763_f("LootTableSeed");
                    this.fillWithLoot(new ResourceLocation(lootTable), lootSeed, player);
                } else {
                    this.loadFromNbt(tag);
                }
            }
            CuriosAPI.getCurio((ItemStack)this.shulkerBox).ifPresent(curio -> {
                if (curio instanceof CurioShulkerBox) {
                    ((CurioShulkerBox)curio).setAnimationStatus(ShulkerBoxTileEntity.AnimationStatus.OPENING);
                }
            });
            if (player instanceof ServerPlayerEntity) {
                NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new SPacketSyncAnimation(player.func_145782_y(), this.identifier, this.index, false));
            }
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_191262_fB, SoundCategory.BLOCKS, 0.5f, player.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
    }

    public void func_174886_c(@Nonnull PlayerEntity player) {
        if (!player.func_175149_v()) {
            CompoundNBT nbttagcompound = this.shulkerBox.func_179543_a("BlockEntityTag");
            if (nbttagcompound != null) {
                nbttagcompound.func_82580_o("LootTable");
                nbttagcompound.func_82580_o("LootTableSeed");
                this.saveToNbt(nbttagcompound);
            }
            CuriosAPI.getCurio((ItemStack)this.shulkerBox).ifPresent(curio -> {
                if (curio instanceof CurioShulkerBox) {
                    ((CurioShulkerBox)curio).setAnimationStatus(ShulkerBoxTileEntity.AnimationStatus.CLOSING);
                }
            });
            if (player instanceof ServerPlayerEntity) {
                NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new SPacketSyncAnimation(player.func_145782_y(), this.identifier, this.index, true));
            }
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_191261_fA, SoundCategory.BLOCKS, 0.5f, player.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
    }

    public void loadFromNbt(CompoundNBT compound) {
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (compound.func_150297_b("Items", 9)) {
            ItemStackHelper.func_191283_b((CompoundNBT)compound, this.items);
        }
    }

    public CompoundNBT saveToNbt(CompoundNBT compound) {
        ItemStackHelper.func_191281_a((CompoundNBT)compound, this.items, (boolean)true);
        return compound;
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.items.get(index);
    }

    @Nonnull
    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.items, (int)index, (int)count);
    }

    @Nonnull
    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.items, (int)index);
    }

    public void func_70299_a(int index, @Nullable ItemStack stack) {
        this.items.set(index, (Object)(stack == null ? ItemStack.field_190927_a : stack));
        if (stack != null && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    public void func_70296_d() {
    }

    public boolean func_94041_b(int index, @Nonnull ItemStack stack) {
        return !(Block.func_149634_a((Item)stack.func_77973_b()) instanceof ShulkerBoxBlock);
    }

    public void func_174888_l() {
        this.items.clear();
    }

    public boolean func_70300_a(@Nonnull PlayerEntity player) {
        return true;
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return this.shulkerBox.func_200301_q();
    }

    public void fillWithLoot(ResourceLocation lootTable, long lootTableSeed, PlayerEntity player) {
        if (player.field_70170_p.func_73046_m() != null) {
            LootTable loottable = player.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(lootTable);
            LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)player.field_70170_p).func_216015_a(LootParameters.field_216286_f, (Object)new BlockPos((Vec3i)player.func_180425_c())).func_216016_a(lootTableSeed);
            lootcontext$builder.func_186469_a(player.func_184817_da()).func_216015_a(LootParameters.field_216281_a, (Object)player);
            loottable.func_216118_a((IInventory)this, lootcontext$builder.func_216022_a(LootParameterSets.field_216261_b));
        }
    }

    @Nullable
    public Container createMenu(int i, @Nonnull PlayerInventory playerInventory, @Nonnull PlayerEntity playerEntity) {
        return new ShulkerBoxContainer(i, playerInventory, (IInventory)this);
    }
}

