/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.forge.clothconfig2.gui.entries;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import me.shedaniel.forge.clothconfig2.api.AbstractConfigEntry;
import me.shedaniel.forge.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.forge.clothconfig2.gui.entries.TooltipListEntry;
import me.shedaniel.forge.math.Rectangle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SubCategoryListEntry
extends TooltipListEntry<List<AbstractConfigListEntry>> {
    private static final ResourceLocation CONFIG_TEX = new ResourceLocation("cloth-config2", "textures/gui/cloth_config.png");
    private String categoryName;
    private List<AbstractConfigListEntry> entries;
    private CategoryLabelWidget widget;
    private List<IGuiEventListener> children;
    private boolean expanded;

    @Deprecated
    public SubCategoryListEntry(String categoryName, List<AbstractConfigListEntry> entries, boolean defaultExpanded) {
        super(categoryName, null);
        this.categoryName = categoryName;
        this.entries = entries;
        this.expanded = defaultExpanded;
        this.widget = new CategoryLabelWidget();
        this.children = Lists.newArrayList((Object[])new IGuiEventListener[]{this.widget});
        this.children.addAll(entries);
    }

    @Override
    public boolean isRequiresRestart() {
        for (AbstractConfigListEntry entry : this.entries) {
            if (!entry.isRequiresRestart()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setRequiresRestart(boolean requiresRestart) {
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    @Override
    public List<AbstractConfigListEntry> getValue() {
        return this.entries;
    }

    @Override
    public Optional<List<AbstractConfigListEntry>> getDefaultValue() {
        return Optional.empty();
    }

    @Override
    public void render(int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        super.render(index, y, x, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
        ((CategoryLabelWidget)this.widget).rectangle.x = x - 19;
        ((CategoryLabelWidget)this.widget).rectangle.y = y;
        ((CategoryLabelWidget)this.widget).rectangle.width = entryWidth + 19;
        ((CategoryLabelWidget)this.widget).rectangle.height = 24;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(CONFIG_TEX);
        RenderHelper.func_74518_a();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.blit(x - 15, y + 4, 24, (this.widget.rectangle.contains(mouseX, mouseY) ? 18 : 0) + (this.expanded ? 9 : 0), 9, 9);
        Minecraft.func_71410_x().field_71466_p.func_175063_a(I18n.func_135052_a((String)this.categoryName, (Object[])new Object[0]), (float)x, (float)(y + 5), this.widget.rectangle.contains(mouseX, mouseY) ? -1638890 : -1);
        for (AbstractConfigListEntry entry : this.entries) {
            entry.setParent(this.getParent());
            entry.setScreen(this.getScreen());
        }
        if (this.expanded) {
            int yy = y + 24;
            for (AbstractConfigListEntry entry : this.entries) {
                entry.render(-1, yy, x + 14, entryWidth - 14, entry.getItemHeight(), mouseX, mouseY, isHovered && this.getFocused() == entry, delta);
                yy += entry.getItemHeight();
            }
        }
    }

    @Override
    public void updateSelected(boolean isSelected) {
        for (AbstractConfigListEntry entry : this.entries) {
            entry.updateSelected(this.expanded && isSelected && this.getFocused() == entry);
        }
    }

    @Override
    public void lateRender(int mouseX, int mouseY, float delta) {
        if (this.expanded) {
            for (AbstractConfigListEntry entry : this.entries) {
                entry.lateRender(mouseX, mouseY, delta);
            }
        }
    }

    @Override
    public int getMorePossibleHeight() {
        if (!this.expanded) {
            return -1;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = 24;
        for (AbstractConfigListEntry entry : this.entries) {
            i += entry.getItemHeight();
            if (entry.getMorePossibleHeight() < 0) continue;
            list.add(i + entry.getMorePossibleHeight());
        }
        list.add(i);
        return list.stream().max(Integer::compare).orElse(0) - this.getItemHeight();
    }

    @Override
    public boolean isMouseInside(int mouseX, int mouseY, int x, int y, int entryWidth, int entryHeight) {
        ((CategoryLabelWidget)this.widget).rectangle.x = x - 15;
        ((CategoryLabelWidget)this.widget).rectangle.y = y;
        ((CategoryLabelWidget)this.widget).rectangle.width = entryWidth + 15;
        ((CategoryLabelWidget)this.widget).rectangle.height = 24;
        return this.widget.rectangle.contains(mouseX, mouseY) && this.getParent().isMouseOver(mouseX, mouseY);
    }

    @Override
    public int getItemHeight() {
        if (this.expanded) {
            int i = 24;
            for (AbstractConfigListEntry entry : this.entries) {
                i += entry.getItemHeight();
            }
            return i;
        }
        return 24;
    }

    public List<? extends IGuiEventListener> children() {
        return this.expanded ? this.children : Collections.singletonList(this.widget);
    }

    @Override
    public void save() {
        this.entries.forEach(AbstractConfigEntry::save);
    }

    @Override
    public Optional<String> getError() {
        Object error = null;
        for (AbstractConfigListEntry entry : this.entries) {
            if (!entry.getError().isPresent()) continue;
            if (error != null) {
                return Optional.ofNullable(I18n.func_135052_a((String)"text.cloth-config.multi_error", (Object[])new Object[0]));
            }
            return entry.getError();
        }
        return Optional.ofNullable(error);
    }

    public class CategoryLabelWidget
    implements IGuiEventListener {
        private Rectangle rectangle = new Rectangle();

        public boolean mouseClicked(double double_1, double double_2, int int_1) {
            if (this.rectangle.contains(double_1, double_2)) {
                SubCategoryListEntry.this.expanded = !SubCategoryListEntry.this.expanded;
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                return true;
            }
            return false;
        }
    }
}

