/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.forge.clothconfig2.gui.entries;

import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import me.shedaniel.forge.clothconfig2.gui.entries.TextFieldListEntry;
import me.shedaniel.forge.clothconfig2.gui.widget.ColorDisplayWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.resources.I18n;
import org.apache.commons.lang3.StringUtils;

public class ColorEntry
extends TextFieldListEntry<Integer> {
    private ColorDisplayWidget colorDisplayWidget;
    private Consumer<Integer> saveConsumer;
    private boolean alpha = true;

    @Deprecated
    public ColorEntry(String fieldName, int value, String resetButtonKey, Supplier<Integer> defaultValue, Consumer<Integer> saveConsumer, Supplier<Optional<String[]>> tooltipSupplier, boolean requiresRestart) {
        super(fieldName, 0, resetButtonKey, defaultValue, tooltipSupplier, requiresRestart);
        ColorValue colorValue = this.getColorValue(String.valueOf(value));
        if (colorValue.hasError()) {
            throw new IllegalArgumentException("Invalid Color: " + colorValue.getError().name());
        }
        this.alpha = false;
        this.saveConsumer = saveConsumer;
        this.textFieldWidget.func_146180_a(this.getHexColorString(value));
        this.colorDisplayWidget = new ColorDisplayWidget(0, 0, 20, this.getColorValueColor(this.textFieldWidget.func_146179_b()));
        this.original = value;
        this.resetButton.setOnPress(button -> {
            this.textFieldWidget.func_146180_a(this.getHexColorString((Integer)this.original));
            this.getScreen().setEdited(true, this.isRequiresRestart());
        });
    }

    @Override
    public void render(int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
        super.render(index, y, x, entryWidth, entryHeight, mouseX, mouseY, isSelected, delta);
        this.colorDisplayWidget.y = y;
        ColorValue value = this.getColorValue(this.textFieldWidget.func_146179_b());
        if (!value.hasError()) {
            this.colorDisplayWidget.setColor(this.alpha ? value.getColor() : 0xFF000000 | value.getColor());
        }
        this.colorDisplayWidget.x = Minecraft.func_71410_x().field_71466_p.func_78260_a() ? x + this.resetButton.getWidth() + this.textFieldWidget.getWidth() : this.textFieldWidget.x - 23;
        this.colorDisplayWidget.render(mouseX, mouseY, delta);
    }

    @Override
    protected void textFieldPreRender(TextFieldWidget widget) {
        if (!this.getError().isPresent()) {
            widget.func_146193_g(0xE0E0E0);
        } else {
            widget.func_146193_g(0xFF5555);
        }
    }

    @Override
    public void save() {
        if (this.saveConsumer != null) {
            this.saveConsumer.accept(this.getValue());
        }
    }

    @Override
    protected boolean isMatchDefault(String text) {
        if (!this.getDefaultValue().isPresent()) {
            return false;
        }
        ColorValue colorValue = this.getColorValue(text);
        return colorValue.hasError() && colorValue.color == (Integer)this.getDefaultValue().get();
    }

    @Override
    public Integer getValue() {
        return this.getColorValueColor(this.textFieldWidget.func_146179_b());
    }

    @Deprecated
    public void setValue(int color) {
        this.textFieldWidget.func_146180_a(this.getHexColorString(color));
    }

    @Override
    public Optional<String> getError() {
        ColorValue colorValue = this.getColorValue(this.textFieldWidget.func_146179_b());
        if (colorValue.hasError()) {
            return Optional.of(I18n.func_135052_a((String)("text.cloth-config.error.color." + colorValue.getError().name().toLowerCase(Locale.ROOT)), (Object[])new Object[0]));
        }
        return super.getError();
    }

    public void withAlpha() {
        if (!this.alpha) {
            this.alpha = true;
            this.textFieldWidget.func_146180_a(this.getHexColorString((Integer)this.original));
        }
    }

    public void withoutAlpha() {
        if (this.alpha) {
            this.alpha = false;
            this.textFieldWidget.func_146180_a(this.getHexColorString((Integer)this.original));
        }
    }

    protected String stripHexStarter(String hex) {
        if (hex.startsWith("#")) {
            return hex.substring(1);
        }
        return hex;
    }

    protected boolean isValidColorString(String str) {
        return !this.getColorValue(str).hasError();
    }

    protected int getColorValueColor(String str) {
        return this.getColorValue(str).getColor();
    }

    protected ColorValue getColorValue(String str) {
        try {
            int color;
            if (str.startsWith("#")) {
                String stripHexStarter = this.stripHexStarter(str);
                if (stripHexStarter.length() > 8) {
                    return ColorError.INVALID_COLOR.toValue();
                }
                if (!this.alpha && stripHexStarter.length() > 6) {
                    return ColorError.NO_ALPHA_ALLOWED.toValue();
                }
                color = (int)Long.parseLong(stripHexStarter, 16);
            } else {
                color = (int)Long.parseLong(str);
            }
            int a = color >> 24 & 0xFF;
            if (!this.alpha && a > 0) {
                return ColorError.NO_ALPHA_ALLOWED.toValue();
            }
            if (a < 0 || a > 255) {
                return ColorError.INVALID_ALPHA.toValue();
            }
            int r = color >> 16 & 0xFF;
            if (r < 0 || r > 255) {
                return ColorError.INVALID_RED.toValue();
            }
            int g = color >> 8 & 0xFF;
            if (g < 0 || g > 255) {
                return ColorError.INVALID_GREEN.toValue();
            }
            int b = color & 0xFF;
            if (b < 0 || b > 255) {
                return ColorError.INVALID_BLUE.toValue();
            }
            return new ColorValue(color);
        }
        catch (NumberFormatException e) {
            return ColorError.INVALID_COLOR.toValue();
        }
    }

    protected String getHexColorString(int color) {
        return "#" + StringUtils.leftPad((String)Integer.toHexString(color), (int)(this.alpha ? 8 : 6), (char)'0');
    }

    protected static class ColorValue {
        private int color = -1;
        @Nullable
        private ColorError error = null;

        public ColorValue(int color) {
            this.color = color;
        }

        public ColorValue(ColorError error) {
            this.error = error;
        }

        public int getColor() {
            return this.color;
        }

        @Nullable
        public ColorError getError() {
            return this.error;
        }

        public boolean hasError() {
            return this.getError() != null;
        }
    }

    protected static enum ColorError {
        NO_ALPHA_ALLOWED,
        INVALID_ALPHA,
        INVALID_RED,
        INVALID_GREEN,
        INVALID_BLUE,
        INVALID_COLOR;

        private ColorValue value = new ColorValue(this);

        public ColorValue toValue() {
            return this.value;
        }
    }
}

