/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.network;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenBlock;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenTileEntity;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketModuleUpdate {
    private BlockPos pos;
    private int slotIndex;
    private CompoundNBT tagCompound;

    public void toBytes(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.writeInt(this.slotIndex);
        PacketBuffer buffer = new PacketBuffer((ByteBuf)buf);
        buffer.func_150786_a(this.tagCompound);
    }

    public PacketModuleUpdate() {
    }

    public PacketModuleUpdate(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.slotIndex = buf.readInt();
        PacketBuffer buffer = new PacketBuffer((ByteBuf)buf);
        this.tagCompound = buffer.func_150793_b();
    }

    public PacketModuleUpdate(BlockPos pos, int slotIndex, CompoundNBT tagCompound) {
        this.pos = pos;
        this.slotIndex = slotIndex;
        this.tagCompound = tagCompound;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayerEntity player = ctx.getSender();
            World world = player.func_130014_f_();
            Block block = world.func_180495_p(this.pos).func_177230_c();
            double dist = player.func_110148_a(PlayerEntity.REACH_DISTANCE).func_111126_e() + 3.0;
            if (player.func_70092_e((double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5) >= dist * dist) {
                return;
            }
            if (!(block instanceof ScreenBlock)) {
                Logging.logError((String)"PacketModuleUpdate: Block is not a ScreenBlock!");
                return;
            }
            TileEntity te = world.func_175625_s(this.pos);
            if (!(te instanceof ScreenTileEntity)) {
                Logging.logError((String)"PacketModuleUpdate: TileEntity is not a SimpleScreenTileEntity!");
                return;
            }
            ((ScreenTileEntity)te).updateModuleData(this.slotIndex, this.tagCompound);
        });
        ctx.setPacketHandled(true);
    }
}

