/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.selector.entity;

import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.piece.PieceSelector;
import vazkii.psi.common.core.handler.PlayerDataHandler;
import vazkii.psi.common.core.helpers.SpellHelpers;

public class PieceSelectorTransmission
extends PieceSelector {
    SpellParam<Number> channel;

    public PieceSelectorTransmission(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.channel = new ParamNumber("psi.spellparam.channel", SpellParam.RED, true, true);
        this.addParam(this.channel);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        SpellHelpers.ensurePositiveOrZero(this, this.channel, 0.0);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        int chanel = ((Number)this.getParamValueOrDefault(context, this.channel, 0)).intValue();
        String key = "psi_broadcast_channel:" + chanel;
        PlayerDataHandler.PlayerData data = PlayerDataHandler.get(context.caster);
        if (data.getCustomData().func_74764_b(key)) {
            return data.getCustomData().func_74769_h(key);
        }
        throw new SpellRuntimeException("psi.spellerror.no_message");
    }

    @Override
    public Class<?> getEvaluationType() {
        return Double.class;
    }
}

