/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.api.spell;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockRayTraceResult;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.internal.MathHelper;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.CompiledSpell;
import vazkii.psi.api.spell.ISpellImmune;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellRuntimeException;

public final class SpellContext {
    public static final double MAX_DISTANCE = 32.0;
    public PlayerEntity caster;
    public Entity focalPoint;
    public CompiledSpell cspell;
    public int loopcastIndex = 0;
    public Hand castFrom;
    public ItemStack tool = ItemStack.field_190927_a;
    public BlockRayTraceResult positionBroken;
    public LivingEntity attackedEntity;
    public LivingEntity attackingEntity;
    public double damageTaken;
    public int targetSlot = 1;
    public boolean shiftTargetSlot = true;
    public boolean customTargetSlot = false;
    public final Map<String, Object> customData = new HashMap<String, Object>();
    public final Object[][] evaluatedObjects = new Object[9][9];
    public Stack<CompiledSpell.Action> actions = null;
    public boolean stopped = false;
    public int delay = 0;

    public SpellContext setPlayer(PlayerEntity player) {
        this.caster = player;
        return this.setFocalPoint((Entity)player);
    }

    public SpellContext setFocalPoint(Entity e) {
        this.focalPoint = e;
        return this;
    }

    public SpellContext setCompiledSpell(CompiledSpell spell) {
        this.cspell = spell;
        return this;
    }

    public SpellContext setSpell(Spell spell) {
        this.setCompiledSpell(PsiAPI.internalHandler.getSpellCache().getCompiledSpell(spell));
        return this;
    }

    public SpellContext setLoopcastIndex(int i) {
        this.loopcastIndex = i;
        return this;
    }

    public boolean isValid() {
        return this.cspell != null;
    }

    public boolean shouldSuppressErrors() {
        return this.isValid() && this.cspell.metadata.errorsSuppressed;
    }

    public boolean isInRadius(Vector3 vec) {
        return this.isInRadius(vec.x, vec.y, vec.z);
    }

    public boolean isInRadius(Entity e) {
        if (e == null) {
            return false;
        }
        if (e == this.focalPoint || e == this.caster) {
            return true;
        }
        return this.isInRadius(e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_());
    }

    public boolean isInRadius(double x, double y, double z) {
        return MathHelper.pointDistanceSpace(x, y, z, this.focalPoint.func_226277_ct_(), this.focalPoint.func_226278_cu_(), this.focalPoint.func_226281_cx_()) <= 32.0;
    }

    public void verifyEntity(Entity e) throws SpellRuntimeException {
        if (e == null) {
            throw new SpellRuntimeException("psi.spellerror.nulltarget");
        }
        if (ISpellImmune.isImmune(e)) {
            throw new SpellRuntimeException("psi.spellerror.immunetarget");
        }
    }

    public int getTargetSlot() throws SpellRuntimeException {
        int slot;
        if (this.customTargetSlot) {
            return this.targetSlot % 36;
        }
        if (this.shiftTargetSlot) {
            int cadSlot = PsiAPI.getPlayerCADSlot(this.caster);
            if (cadSlot == -1) {
                throw new SpellRuntimeException("psi.spellerror.nocad");
            }
            slot = (cadSlot + this.targetSlot) % 9;
        } else {
            slot = (this.targetSlot - 1) % 9;
        }
        if (slot < 0) {
            slot = 10 + slot;
        }
        return slot;
    }

    public ItemStack getHarvestTool() throws SpellRuntimeException {
        if (!this.tool.func_190926_b() && !this.tool.func_77973_b().getToolTypes(this.tool).isEmpty()) {
            return this.tool;
        }
        ItemStack cad = PsiAPI.getPlayerCAD(this.caster);
        if (cad.func_190926_b()) {
            throw new SpellRuntimeException("psi.spellerror.nocad");
        }
        return cad;
    }
}

