/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.endermail.entity;

import com.chaosthedude.endermail.EnderMail;
import com.chaosthedude.endermail.blocks.te.LockerTileEntity;
import com.chaosthedude.endermail.blocks.te.PackageTileEntity;
import com.chaosthedude.endermail.config.ConfigHandler;
import com.chaosthedude.endermail.data.LockerWorldData;
import com.chaosthedude.endermail.items.PackageControllerItem;
import com.chaosthedude.endermail.registry.EnderMailBlocks;
import com.chaosthedude.endermail.registry.EnderMailItems;
import com.chaosthedude.endermail.util.ControllerState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class EnderMailmanEntity
extends MonsterEntity {
    public static final String NAME = "ender_mailman";
    private static final DataParameter<Boolean> CARRYING_PACKAGE = EntityDataManager.func_187226_a(EnderMailmanEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private NonNullList<ItemStack> contents = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
    private int lastCreepySound;
    private int timePickedUp;
    private int timeDelivered;
    private boolean isDelivering;
    private BlockPos startingPos;
    private BlockPos deliveryPos;
    private ItemStack packageController;

    public EnderMailmanEntity(EntityType<? extends EnderMailmanEntity> entityType, World world) {
        super(entityType, world);
        this.field_70138_W = 1.0f;
        this.func_184644_a(PathNodeType.WATER, -1.0f);
    }

    public EnderMailmanEntity(EntityType<? extends EnderMailmanEntity> entityType, World world, BlockPos startingPos, BlockPos deliveryPos, String lockerID, ItemStack packageController) {
        super(entityType, world);
        this.packageController = packageController;
        this.func_70107_b((double)startingPos.func_177958_n() + this.getRandomOffset(), startingPos.func_177956_o(), (double)startingPos.func_177952_p() + this.getRandomOffset());
        this.setStartingPos(startingPos);
        this.findDeliveryPos(lockerID, deliveryPos);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CARRYING_PACKAGE, (Object)false);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0, 0.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(10, (Goal)new DeliverGoal(this));
        this.field_70714_bg.func_75776_a(11, (Goal)new TakePackageGoal(this));
        this.field_70714_bg.func_75776_a(12, (Goal)new DieGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg() - 0.25, this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
            }
            if (this.field_70173_aa - this.timeDelivered > 100) {
                this.kill();
            }
        }
        this.field_70703_bu = false;
        super.func_70636_d();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source instanceof IndirectEntityDamageSource) {
            for (int i = 0; i < 64; ++i) {
                if (!this.teleportRandomly()) continue;
                return true;
            }
            return false;
        }
        boolean flag = super.func_70097_a(source, amount);
        if (source.func_76363_c() && this.field_70146_Z.nextInt(10) != 0) {
            this.teleportRandomly();
        }
        return flag;
    }

    protected void func_70619_bc() {
        float f;
        if (this.func_70026_G()) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
        if (this.field_70170_p.func_72935_r() && (f = this.func_70013_c()) > 0.5f && this.field_70170_p.func_175710_j(new BlockPos((Entity)this)) && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f) {
            this.teleportRandomly();
        }
        super.func_70619_bc();
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187529_aS;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187531_aU;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187530_aT;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.contents);
        compound.func_74768_a("StartingX", this.startingPos.func_177958_n());
        compound.func_74768_a("StartingY", this.startingPos.func_177956_o());
        compound.func_74768_a("StartingZ", this.startingPos.func_177952_p());
        compound.func_74768_a("DeliveryX", this.deliveryPos.func_177958_n());
        compound.func_74768_a("DeliveryY", this.deliveryPos.func_177956_o());
        compound.func_74768_a("DeliveryZ", this.deliveryPos.func_177952_p());
        compound.func_74757_a("IsDelivering", this.isDelivering);
        compound.func_74757_a("IsCarryingPackage", this.isCarryingPackage());
    }

    public void func_70020_e(CompoundNBT compound) {
        super.func_70020_e(compound);
        ItemStackHelper.func_191283_b((CompoundNBT)compound, this.contents);
        this.startingPos = new BlockPos(compound.func_74762_e("StartingX"), compound.func_74762_e("StartingY"), compound.func_74762_e("StartingZ"));
        this.deliveryPos = new BlockPos(compound.func_74762_e("DeliveryX"), compound.func_74762_e("DeliveryY"), compound.func_74762_e("DeliveryZ"));
        this.isDelivering = compound.func_74767_n("IsDelivering");
        this.field_70180_af.func_187227_b(CARRYING_PACKAGE, (Object)compound.func_74767_n("IsCarryingPackage"));
    }

    protected void func_213337_cE() {
        super.func_213337_cE();
        for (ItemStack stack : this.contents) {
            this.func_70099_a(stack, 0.0f);
        }
    }

    protected boolean func_225511_J_() {
        return false;
    }

    private boolean teleportTo(double x, double y, double z) {
        boolean canTeleport = this.func_213373_a(x, y, z, false);
        if (canTeleport) {
            this.field_70170_p.func_184148_a((PlayerEntity)null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
            this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        }
        return canTeleport;
    }

    protected boolean teleportRandomly() {
        double x = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        double y = this.func_226278_cu_() + (double)(this.field_70146_Z.nextInt(64) - 32);
        double z = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        return this.teleportTo(x, y, z);
    }

    private boolean canPlacePackage(World world, BlockPos pos) {
        return EnderMailBlocks.PACKAGE.getStampedState().func_196955_c((IWorldReader)world, pos) && world.func_175623_d(pos) && Block.func_220064_c((IBlockReader)world, (BlockPos)pos.func_177977_b());
    }

    private BlockPos findLocker(String lockerID) {
        LockerWorldData data = LockerWorldData.get(this.field_70170_p);
        if (data != null) {
            return data.getLockers().get(lockerID);
        }
        return null;
    }

    private BlockPos findLockerNearPos(BlockPos pos) {
        LockerWorldData data = LockerWorldData.get(this.field_70170_p);
        if (data != null) {
            for (String lockerID : data.getLockers().keySet()) {
                int deltaZ;
                int deltaX;
                int distanceSq;
                BlockPos lockerPos = data.getLockers().get(lockerID);
                if (!((Boolean)ConfigHandler.GENERAL.lockerDeliveryRadiusIgnoresY.get() != false ? (distanceSq = (deltaX = pos.func_177958_n() - lockerPos.func_177958_n()) * deltaX + (deltaZ = pos.func_177952_p() - lockerPos.func_177952_p()) * deltaZ) < (Integer)ConfigHandler.GENERAL.lockerDeliveryRadius.get() * (Integer)ConfigHandler.GENERAL.lockerDeliveryRadius.get() : pos.func_218141_a((Vec3i)lockerPos, (double)((Integer)ConfigHandler.GENERAL.lockerDeliveryRadius.get()).intValue()))) continue;
                return lockerPos;
            }
        }
        return null;
    }

    private int findValidDeliveryHeight(BlockPos pos, int maxHeightDifference) {
        if (pos != null) {
            int downY;
            int startY;
            int upY = startY = pos.func_177956_o() <= 0 ? this.field_70170_p.func_181545_F() : pos.func_177956_o();
            for (downY = startY; !(this.canPlacePackage(this.field_70170_p, new BlockPos(pos.func_177958_n(), upY, pos.func_177952_p())) || this.canPlacePackage(this.field_70170_p, new BlockPos(pos.func_177958_n(), downY, pos.func_177952_p())) || upY >= 255 && downY <= 1 || upY - startY >= maxHeightDifference || startY - downY >= maxHeightDifference); ++upY, --downY) {
            }
            BlockPos upPos = new BlockPos(pos.func_177958_n(), upY, pos.func_177952_p());
            BlockPos downPos = new BlockPos(pos.func_177958_n(), downY, pos.func_177952_p());
            if (upY < 255 && this.canPlacePackage(this.field_70170_p, upPos)) {
                return upY;
            }
            if (downY > 1 && this.canPlacePackage(this.field_70170_p, downPos)) {
                return downY;
            }
        }
        return -1;
    }

    private void findDeliveryPos(String lockerID, BlockPos pos) {
        BlockPos lockerPos;
        if (lockerID != null && !lockerID.isEmpty() && (lockerPos = this.findLocker(lockerID)) != null) {
            this.setDeliveryPos(lockerPos);
            return;
        }
        if (pos != null) {
            BlockPos validLocker = this.findLockerNearPos(pos);
            if (validLocker != null) {
                this.setDeliveryPos(validLocker);
                return;
            }
            int deliveryY = this.findValidDeliveryHeight(pos, 255);
            this.setDeliveryPos(new BlockPos(pos.func_177958_n(), deliveryY, pos.func_177952_p()));
        }
    }

    public void kill() {
        this.func_70097_a(DamageSource.field_76380_i, Float.MAX_VALUE);
    }

    public void setContents(NonNullList<ItemStack> contents) {
        this.contents = contents;
    }

    public NonNullList<ItemStack> getContents() {
        return this.contents;
    }

    public double getDistance(double x, double y, double z) {
        return Math.sqrt(this.func_70092_e(x, y, z));
    }

    public double getDistanceToDelivery() {
        return this.getDistance(this.deliveryPos.func_177958_n(), this.deliveryPos.func_177956_o(), this.deliveryPos.func_177952_p());
    }

    public double getDistanceToStart() {
        return this.getDistance(this.startingPos.func_177958_n(), this.startingPos.func_177956_o(), this.startingPos.func_177952_p());
    }

    public BlockPos getDeliveryPos() {
        return this.deliveryPos;
    }

    public void setDeliveryPos(BlockPos pos) {
        this.deliveryPos = pos;
        this.setDelivering(true);
    }

    public BlockPos getStartingPos() {
        return this.startingPos;
    }

    public void setPackageController(ItemStack packageController) {
        this.packageController = packageController;
    }

    public PackageControllerItem getPackageController() {
        return (PackageControllerItem)this.packageController.func_77973_b();
    }

    public boolean isCarryingPackage() {
        return (Boolean)this.field_70180_af.func_187225_a(CARRYING_PACKAGE);
    }

    public boolean isDelivering() {
        return this.isDelivering;
    }

    public void setCarryingPackage(boolean carrying) {
        this.field_70180_af.func_187227_b(CARRYING_PACKAGE, (Object)carrying);
    }

    public void setDelivering(boolean delivering) {
        this.isDelivering = delivering;
    }

    public boolean shouldDeliverOnGround() {
        return this.canPlacePackage(this.field_70170_p, this.getDeliveryPos());
    }

    public boolean shouldDeliverToLocker() {
        return this.field_70170_p.func_180495_p(this.deliveryPos).func_177230_c() == EnderMailBlocks.LOCKER;
    }

    public void updateTimePickedUp() {
        this.timePickedUp = this.field_70173_aa;
    }

    public int getTimePickedUp() {
        return this.timePickedUp;
    }

    public void updateTimeDelivered() {
        this.timeDelivered = this.field_70173_aa;
    }

    public int getTimeDelivered() {
        return this.timeDelivered;
    }

    public void playEndermanSound() {
        if (this.field_70173_aa >= this.lastCreepySound + 400) {
            this.lastCreepySound = this.field_70173_aa;
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_() + (double)this.func_70047_e(), this.func_226281_cx_(), SoundEvents.field_187533_aW, this.func_184176_by(), 2.5f, 1.0f, false);
            }
        }
    }

    public double getRandomOffset() {
        return this.func_70681_au().nextDouble() * 2.0 * (double)(this.func_70681_au().nextBoolean() ? 1 : -1);
    }

    public void teleportToDeliveryPos() {
        double x = (double)this.getDeliveryPos().func_177958_n() + this.getRandomOffset();
        double y = this.getDeliveryPos().func_177956_o();
        double z = (double)this.getDeliveryPos().func_177952_p() + this.getRandomOffset();
        this.teleportTo(x, y, z);
    }

    public void teleportToStartingPos() {
        double x = (double)this.getStartingPos().func_177958_n() + this.getRandomOffset();
        double y = this.getStartingPos().func_177956_o();
        double z = (double)this.getStartingPos().func_177952_p() + this.getRandomOffset();
        this.teleportTo(x, y, z);
    }

    public boolean isAtStartingPos() {
        return this.func_180425_c() == this.startingPos;
    }

    public void setStartingPos(BlockPos pos) {
        this.startingPos = pos;
    }

    public ItemStack getPackageStack() {
        ItemStack stackPackage = new ItemStack((IItemProvider)EnderMailItems.PACKAGE);
        CompoundNBT stackTag = new CompoundNBT();
        CompoundNBT itemTag = new CompoundNBT();
        if (!this.contents.isEmpty()) {
            itemTag = ItemStackHelper.func_191282_a((CompoundNBT)itemTag, this.contents);
        }
        if (!itemTag.isEmpty()) {
            stackTag.func_218657_a("BlockEntityTag", (INBT)itemTag);
        }
        if (!stackTag.isEmpty()) {
            stackPackage.func_77982_d(stackTag);
        }
        return stackPackage;
    }

    static class DieGoal
    extends Goal {
        private final EnderMailmanEntity enderMailman;

        public DieGoal(EnderMailmanEntity enderMailman) {
            this.enderMailman = enderMailman;
        }

        public boolean func_75250_a() {
            return !this.enderMailman.isDelivering();
        }

        public void func_75246_d() {
            if (this.enderMailman.field_70173_aa - this.enderMailman.getTimeDelivered() >= 100) {
                this.enderMailman.kill();
            }
        }
    }

    static class TakePackageGoal
    extends Goal {
        private final EnderMailmanEntity enderMailman;

        public TakePackageGoal(EnderMailmanEntity enderMailman) {
            this.enderMailman = enderMailman;
        }

        public boolean func_75250_a() {
            return this.enderMailman.isDelivering() && !this.enderMailman.isCarryingPackage();
        }

        public void func_75246_d() {
            TileEntity tileEntity = this.enderMailman.field_70170_p.func_175625_s(this.enderMailman.startingPos);
            if (tileEntity != null && tileEntity instanceof PackageTileEntity) {
                PackageTileEntity tileEntityPackage = (PackageTileEntity)tileEntity;
                this.enderMailman.setContents(tileEntityPackage.getContents());
                this.enderMailman.setCarryingPackage(true);
                this.enderMailman.field_70170_p.func_175656_a(this.enderMailman.startingPos, Blocks.field_150350_a.func_176223_P());
                if (this.enderMailman.getPackageController() != null) {
                    this.enderMailman.getPackageController().setState(this.enderMailman.packageController, ControllerState.DELIVERING);
                }
                this.enderMailman.updateTimePickedUp();
            } else {
                this.enderMailman.setDelivering(false);
            }
        }
    }

    static class DeliverGoal
    extends Goal {
        private final EnderMailmanEntity enderMailman;

        public DeliverGoal(EnderMailmanEntity enderMailman) {
            this.enderMailman = enderMailman;
        }

        public boolean func_75250_a() {
            return this.enderMailman.isDelivering() && this.enderMailman.isCarryingPackage();
        }

        public void func_75246_d() {
            if (this.enderMailman.field_70173_aa - this.enderMailman.getTimePickedUp() >= 100) {
                TileEntity te;
                boolean delivered = false;
                Object deliveredToPos = null;
                if (this.enderMailman.shouldDeliverOnGround()) {
                    this.enderMailman.teleportToDeliveryPos();
                    this.enderMailman.field_70170_p.func_180501_a(this.enderMailman.getDeliveryPos(), EnderMailBlocks.PACKAGE.getRandomlyRotatedStampedState(), 3);
                    this.enderMailman.field_70170_p.func_175690_a(this.enderMailman.getDeliveryPos(), (TileEntity)new PackageTileEntity(this.enderMailman.getContents()));
                    if (this.enderMailman.getPackageController() != null) {
                        this.enderMailman.getPackageController().setState(this.enderMailman.packageController, ControllerState.DELIVERED);
                        this.enderMailman.getPackageController().setDeliveryPos(this.enderMailman.packageController, this.enderMailman.getDeliveryPos());
                    }
                    if (((Boolean)ConfigHandler.GENERAL.logDeliveries.get()).booleanValue()) {
                        EnderMail.logger.info("Delivered package to " + this.enderMailman.getDeliveryPos().func_177958_n() + ", " + this.enderMailman.getDeliveryPos().func_177956_o() + ", " + this.enderMailman.getDeliveryPos().func_177952_p());
                    }
                    delivered = true;
                } else if (this.enderMailman.shouldDeliverToLocker() && (te = this.enderMailman.field_70170_p.func_175625_s(this.enderMailman.getDeliveryPos())) != null && te instanceof LockerTileEntity) {
                    this.enderMailman.teleportToDeliveryPos();
                    LockerTileEntity lockerTe = (LockerTileEntity)te;
                    ItemStack stackPackage = this.enderMailman.getPackageStack();
                    boolean putInLocker = lockerTe.addPackage(stackPackage);
                    if (putInLocker) {
                        if (this.enderMailman.getPackageController() != null) {
                            this.enderMailman.getPackageController().setState(this.enderMailman.packageController, ControllerState.DELIVERED_TO_LOCKER);
                            this.enderMailman.getPackageController().setDeliveryPos(this.enderMailman.packageController, this.enderMailman.getDeliveryPos());
                        }
                        if (((Boolean)ConfigHandler.GENERAL.logDeliveries.get()).booleanValue()) {
                            EnderMail.logger.info("Delivered package to locker " + lockerTe.getLockerID() + " at " + this.enderMailman.getDeliveryPos().func_177958_n() + ", " + this.enderMailman.getDeliveryPos().func_177956_o() + ", " + this.enderMailman.getDeliveryPos().func_177952_p());
                        }
                        delivered = true;
                    } else {
                        int y = -1;
                        ArrayList<Direction> directions = new ArrayList<Direction>(Arrays.asList(Direction.NORTH, Direction.EAST, Direction.WEST, Direction.SOUTH));
                        while (y < 0 && !directions.isEmpty()) {
                            Direction randomDirection = (Direction)directions.get(new Random().nextInt(directions.size()));
                            directions.remove(randomDirection);
                            BlockPos newDeliveryPos = this.enderMailman.getDeliveryPos().func_177972_a(randomDirection);
                            y = this.enderMailman.findValidDeliveryHeight(newDeliveryPos, 8);
                            if (y <= 0) continue;
                            newDeliveryPos = new BlockPos(newDeliveryPos.func_177958_n(), y, newDeliveryPos.func_177952_p());
                            this.enderMailman.field_70170_p.func_180501_a(newDeliveryPos, EnderMailBlocks.PACKAGE.getRandomlyRotatedStampedState(), 3);
                            this.enderMailman.field_70170_p.func_175690_a(newDeliveryPos, (TileEntity)new PackageTileEntity(this.enderMailman.getContents()));
                            if (this.enderMailman.getPackageController() != null) {
                                this.enderMailman.getPackageController().setState(this.enderMailman.packageController, ControllerState.DELIVERED);
                                this.enderMailman.getPackageController().setDeliveryPos(this.enderMailman.packageController, newDeliveryPos);
                            }
                            if (((Boolean)ConfigHandler.GENERAL.logDeliveries.get()).booleanValue()) {
                                EnderMail.logger.info("Delivered package to " + newDeliveryPos.func_177958_n() + ", " + newDeliveryPos.func_177956_o() + ", " + newDeliveryPos.func_177952_p() + " near locker " + lockerTe.getLockerID());
                            }
                            delivered = true;
                        }
                    }
                }
                if (!delivered) {
                    this.enderMailman.teleportToStartingPos();
                    this.enderMailman.field_70170_p.func_180501_a(this.enderMailman.getStartingPos(), EnderMailBlocks.PACKAGE.getRandomlyRotatedStampedState(), 3);
                    this.enderMailman.field_70170_p.func_175690_a(this.enderMailman.getStartingPos(), (TileEntity)new PackageTileEntity(this.enderMailman.getContents()));
                    if (this.enderMailman.getPackageController() != null) {
                        this.enderMailman.getPackageController().setState(this.enderMailman.packageController, ControllerState.UNDELIVERABLE);
                    }
                }
                this.enderMailman.updateTimeDelivered();
                this.enderMailman.setContents((NonNullList<ItemStack>)NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a));
                this.enderMailman.setCarryingPackage(false);
                this.enderMailman.setDelivering(false);
            } else if ((this.enderMailman.field_70173_aa - this.enderMailman.getTimePickedUp()) % 20 == 0) {
                this.enderMailman.teleportRandomly();
            }
        }
    }
}

