/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.endermail.blocks;

import com.chaosthedude.endermail.blocks.te.LockerTileEntity;
import com.chaosthedude.endermail.registry.EnderMailBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class LockerBlock
extends ContainerBlock {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty FILLED = BooleanProperty.func_177716_a((String)"filled");
    public static final String NAME = "locker";
    public static final int INVENTORY_SIZE = 3;
    public static final int MAX_ID_LENGTH = 12;

    public LockerBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(2.0f).func_200947_a(SoundType.field_185852_e));
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a((IProperty)FILLED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{FACING});
        builder.func_206894_a(new IProperty[]{FILLED});
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        if (world.func_201670_d()) {
            return ActionResultType.SUCCESS;
        }
        if (!player.func_213453_ef()) {
            TileEntity te = world.func_175625_s(pos);
            if (te != null && te instanceof LockerTileEntity) {
                LockerTileEntity lockerTe = (LockerTileEntity)te;
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)lockerTe, buf -> buf.func_179255_a(pos).func_180714_a(lockerTe.getLockerID()));
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity tileentity;
        if (stack.func_82837_s() && (tileentity = world.func_175625_s(pos)) instanceof LockerTileEntity) {
            ((LockerTileEntity)tileentity).setLockerID(stack.func_200301_q().func_150254_d());
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public TileEntity func_196283_a_(IBlockReader world) {
        return new LockerTileEntity();
    }

    public static void setFilled(boolean filled, World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == EnderMailBlocks.LOCKER && (((Boolean)state.func_177229_b((IProperty)FILLED)).booleanValue() && !filled || !((Boolean)state.func_177229_b((IProperty)FILLED)).booleanValue() && filled)) {
            TileEntity tileentity = world.func_175625_s(pos);
            world.func_180501_a(pos, (BlockState)((BlockState)EnderMailBlocks.LOCKER.func_176223_P().func_206870_a((IProperty)FACING, state.func_177229_b((IProperty)FACING))).func_206870_a((IProperty)FILLED, (Comparable)Boolean.valueOf(filled)), 3);
            if (tileentity != null) {
                tileentity.func_145829_t();
                world.func_175690_a(pos, tileentity);
            }
        }
    }
}

