/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile;

import com.bluepowermod.block.BlockContainerFacingBase;
import com.bluepowermod.tile.IRotatable;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;

public class TileBase
extends TileEntity
implements IRotatable,
ITickableTileEntity {
    private boolean isRedstonePowered;
    private int outputtingRedstone;
    private int ticker = 0;

    public TileBase(TileEntityType<?> type) {
        super(type);
    }

    public void func_145839_a(CompoundNBT tCompound) {
        super.func_145839_a(tCompound);
        this.isRedstonePowered = tCompound.func_74767_n("isRedstonePowered");
        this.readFromPacketNBT(tCompound);
    }

    public CompoundNBT func_189515_b(CompoundNBT tCompound) {
        super.func_189515_b(tCompound);
        tCompound.func_74757_a("isRedstonePowered", this.isRedstonePowered);
        this.writeToPacketNBT(tCompound);
        return tCompound;
    }

    protected void writeToPacketNBT(CompoundNBT tCompound) {
        tCompound.func_74774_a("outputtingRedstone", (byte)this.outputtingRedstone);
    }

    protected void readFromPacketNBT(CompoundNBT tCompound) {
        this.outputtingRedstone = tCompound.func_74771_c("outputtingRedstone");
        if (this.field_145850_b != null) {
            this.markForRenderUpdate();
        }
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT tCompound = new CompoundNBT();
        this.writeToPacketNBT(tCompound);
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, tCompound);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.readFromPacketNBT(pkt.func_148857_g());
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    protected void sendUpdatePacket() {
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_195593_d(this.field_174879_c, this.func_195044_w().func_177230_c());
        }
    }

    protected void markForRenderUpdate() {
        if (this.field_145850_b != null) {
            this.field_145850_b.func_225319_b(this.field_174879_c, this.func_195044_w(), this.func_195044_w());
        }
    }

    protected void notifyNeighborBlockUpdate() {
    }

    public void onBlockNeighbourChanged() {
        this.checkRedstonePower();
    }

    public void checkRedstonePower() {
        boolean isIndirectlyPowered;
        boolean bl = isIndirectlyPowered = this.func_145831_w().func_175687_A(this.field_174879_c) != 0;
        if (isIndirectlyPowered && !this.getIsRedstonePowered()) {
            this.redstoneChanged(true);
        } else if (this.getIsRedstonePowered() && !isIndirectlyPowered) {
            this.redstoneChanged(false);
        }
    }

    public void setOutputtingRedstone(boolean newValue) {
        this.setOutputtingRedstone(newValue ? 15 : 0);
    }

    public void setOutputtingRedstone(int value) {
        value = Math.max(0, value);
        if (this.outputtingRedstone != (value = Math.min(15, value))) {
            this.outputtingRedstone = value;
            this.notifyNeighborBlockUpdate();
        }
    }

    public int getOutputtingRedstone() {
        return this.outputtingRedstone;
    }

    protected void redstoneChanged(boolean newValue) {
        this.isRedstonePowered = newValue;
    }

    public boolean getIsRedstonePowered() {
        return this.isRedstonePowered;
    }

    public int getTicker() {
        return this.ticker;
    }

    protected void onTileLoaded() {
        if (!this.field_145850_b.field_72995_K) {
            this.onBlockNeighbourChanged();
        }
    }

    public NonNullList<ItemStack> getDrops() {
        return NonNullList.func_191196_a();
    }

    @Override
    public void setFacingDirection(Direction dir) {
        if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() instanceof BlockContainerFacingBase) {
            BlockContainerFacingBase.setState(dir, this.field_145850_b, this.field_174879_c);
            if (this.field_145850_b != null) {
                this.sendUpdatePacket();
                this.notifyNeighborBlockUpdate();
            }
        }
    }

    @Override
    public Direction getFacingDirection() {
        if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() instanceof BlockContainerFacingBase) {
            return (Direction)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockContainerFacingBase.FACING);
        }
        return Direction.UP;
    }

    public boolean canConnectRedstone() {
        return false;
    }

    public void func_73660_a() {
        if (this.ticker == 0) {
            this.onTileLoaded();
        }
        ++this.ticker;
    }
}

