/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.block.worldgen;

import com.bluepowermod.api.misc.MinecraftColor;
import com.bluepowermod.init.BPBlocks;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.StainedGlassBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.projectile.WitherSkullEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;

public class BlockBPGlass
extends StainedGlassBlock {
    private final boolean witherproof;

    public BlockBPGlass(String name, boolean witherproof) {
        super(DyeColor.PURPLE, Block.Properties.func_200945_a((Material)Material.field_151592_s).func_200948_a(5.0f, witherproof ? 2000.0f : 2.0f).func_200947_a(SoundType.field_185853_f).func_226896_b_());
        this.setRegistryName("bluepower", name);
        BPBlocks.blockList.add((Block)this);
        this.witherproof = witherproof;
    }

    public BlockBPGlass(String name) {
        super(DyeColor.LIGHT_GRAY, Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(5.0f).func_200947_a(SoundType.field_185851_d).func_226896_b_());
        this.setRegistryName("bluepower", name);
        BPBlocks.blockList.add((Block)this);
        this.witherproof = false;
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        if (this.witherproof) {
            tooltip.add((ITextComponent)new StringTextComponent(MinecraftColor.RED.getChatColor() + "Witherproof"));
        }
    }

    public boolean canEntityDestroy(BlockState state, IBlockReader world, BlockPos pos, Entity entity) {
        if (this.witherproof) {
            return !(entity instanceof WitherEntity) && !(entity instanceof WitherSkullEntity) && super.canEntityDestroy(state, world, pos, entity);
        }
        return super.canEntityDestroy(state, world, pos, entity);
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        if (!this.witherproof) {
            super.func_180652_a(worldIn, pos, explosionIn);
        }
    }

    public boolean func_149659_a(Explosion explosion) {
        return !this.witherproof && super.func_149659_a(explosion);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        List drops = super.func_220076_a(state, builder);
        drops.add(new ItemStack((IItemProvider)this));
        return drops;
    }
}

