/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.pedestal.wrappers;

import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.util.FakePlayer;
import xreliquary.api.IPedestal;
import xreliquary.api.IPedestalActionItemWrapper;
import xreliquary.reference.Settings;

public class PedestalShearsWrapper
implements IPedestalActionItemWrapper {
    private boolean isShearingBlock = false;
    private BlockPos blockPosBeingSheared;
    private Queue<BlockPos> blockQueue = new ArrayDeque<BlockPos>();

    @Override
    public void update(ItemStack stack, IPedestal pedestal) {
        int shearsRange;
        World world = pedestal.getTheWorld();
        BlockPos pos = pedestal.getBlockPos();
        FakePlayer fakePlayer = pedestal.getFakePlayer();
        if (!this.shearAnimals(stack, world, fakePlayer, pos, shearsRange = ((Integer)Settings.COMMON.blocks.pedestal.shearsWrapperRange.get()).intValue()) && !this.shearBlocks(stack, world, pedestal, fakePlayer, pos, shearsRange)) {
            pedestal.setActionCoolDown(100);
            return;
        }
        if (!this.isShearingBlock) {
            pedestal.setActionCoolDown((Integer)Settings.COMMON.blocks.pedestal.shearsWrapperCooldown.get());
        }
        if (stack.func_190916_E() == 0) {
            pedestal.destroyItem();
        }
    }

    @Override
    public void onRemoved(ItemStack stack, IPedestal pedestal) {
    }

    @Override
    public void stop(ItemStack stack, IPedestal pedestal) {
    }

    private boolean shearBlocks(ItemStack stack, World world, IPedestal pedestal, FakePlayer fakePlayer, BlockPos pos, int shearsRange) {
        if (!this.isShearingBlock) {
            if (this.blockQueue.isEmpty()) {
                this.updateQueue(stack, world, pos, shearsRange);
                if (this.blockQueue.isEmpty()) {
                    return false;
                }
            }
            this.blockPosBeingSheared = this.blockQueue.remove();
            BlockState blockState = world.func_180495_p(this.blockPosBeingSheared);
            if (blockState.func_177230_c() instanceof IShearable && ((IShearable)blockState.func_177230_c()).isShearable(stack, (IWorldReader)world, this.blockPosBeingSheared)) {
                float hardness = blockState.func_185887_b((IBlockReader)world, this.blockPosBeingSheared);
                float digSpeed = stack.func_77973_b().func_150893_a(stack, blockState);
                pedestal.setActionCoolDown((int)(hardness * 1.5f * 20.0f / digSpeed));
                this.isShearingBlock = true;
            }
        } else {
            stack.func_77973_b().onBlockStartBreak(stack, this.blockPosBeingSheared, (PlayerEntity)fakePlayer);
            BlockState blockState = world.func_180495_p(this.blockPosBeingSheared);
            world.func_217377_a(this.blockPosBeingSheared, false);
            Block.func_220054_a((BlockState)blockState, (World)world, (BlockPos)pos, null, (Entity)fakePlayer, (ItemStack)new ItemStack((IItemProvider)Items.field_151097_aZ));
            world.func_217379_c(2001, this.blockPosBeingSheared, Block.func_196246_j((BlockState)blockState));
            this.isShearingBlock = false;
        }
        return true;
    }

    private void updateQueue(ItemStack stack, World world, BlockPos pos, int shearsRange) {
        for (int y = pos.func_177956_o() - shearsRange; y <= pos.func_177956_o() + shearsRange; ++y) {
            for (int x = pos.func_177958_n() - shearsRange; x <= pos.func_177958_n() + shearsRange; ++x) {
                for (int z = pos.func_177952_p() - shearsRange; z <= pos.func_177952_p() + shearsRange; ++z) {
                    BlockPos currentBlockPos = new BlockPos(x, y, z);
                    BlockState blockState = world.func_180495_p(currentBlockPos);
                    if (!(blockState.func_177230_c() instanceof IShearable) || !((IShearable)blockState.func_177230_c()).isShearable(stack, (IWorldReader)world, currentBlockPos)) continue;
                    this.blockQueue.add(currentBlockPos);
                }
            }
        }
    }

    private boolean shearAnimals(ItemStack stack, World world, FakePlayer fakePlayer, BlockPos pos, int shearsRange) {
        List entities = world.func_217357_a(AnimalEntity.class, new AxisAlignedBB((double)(pos.func_177958_n() - shearsRange), (double)(pos.func_177956_o() - shearsRange), (double)(pos.func_177952_p() - shearsRange), (double)(pos.func_177958_n() + shearsRange), (double)(pos.func_177956_o() + shearsRange), (double)(pos.func_177952_p() + shearsRange)));
        for (AnimalEntity animal : entities) {
            if (!(animal instanceof IShearable) || !((IShearable)animal).isShearable(stack, (IWorldReader)world, animal.func_180425_c())) continue;
            fakePlayer.func_184611_a(Hand.MAIN_HAND, stack);
            fakePlayer.func_190775_a((Entity)animal, Hand.MAIN_HAND);
            return true;
        }
        return false;
    }
}

