/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.handler;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Tuple;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xreliquary.client.gui.components.Box;
import xreliquary.client.gui.components.Component;
import xreliquary.client.gui.components.ItemStackPane;
import xreliquary.client.gui.components.TextPane;
import xreliquary.client.gui.hud.ChargePane;
import xreliquary.client.gui.hud.ChargeableItemInfoPane;
import xreliquary.client.gui.hud.CharmPane;
import xreliquary.client.gui.hud.DynamicChargePane;
import xreliquary.client.gui.hud.HUDPosition;
import xreliquary.client.gui.hud.HUDRenderrer;
import xreliquary.client.gui.hud.HandgunPane;
import xreliquary.client.gui.hud.HeroMedallionPane;
import xreliquary.init.ModBlocks;
import xreliquary.init.ModItems;
import xreliquary.items.VoidTearItem;
import xreliquary.items.util.ILeftClickableItem;
import xreliquary.network.LeftClickedItemPacket;
import xreliquary.network.PacketHandler;
import xreliquary.reference.Colors;
import xreliquary.reference.Settings;
import xreliquary.util.InventoryHelper;
import xreliquary.util.LanguageHelper;
import xreliquary.util.NBTHelper;

@Mod.EventBusSubscriber(modid="xreliquary", value={Dist.CLIENT})
public class ClientEventHandler {
    private static final String VOID_TEAR_MODE_TRANSLATION = "item.xreliquary.void_tear.mode.";
    private static final List<Tuple<Component, HUDPosition>> hudComponents = Lists.newArrayList();

    private ClientEventHandler() {
    }

    @SubscribeEvent
    public static void onRenderLiving(RenderLivingEvent.Pre event) {
        if (event.getEntity() instanceof PlayerEntity) {
            boolean handgunInMain;
            PlayerEntity player = (PlayerEntity)event.getEntity();
            boolean handgunInOff = player.func_184586_b(Hand.OFF_HAND).func_77973_b() == ModItems.HANDGUN;
            boolean bl = handgunInMain = player.func_184586_b(Hand.MAIN_HAND).func_77973_b() == ModItems.HANDGUN;
            if (handgunInOff || handgunInMain) {
                ClientEventHandler.setHandgunArmPoses(event, player, handgunInOff, handgunInMain);
            }
        }
    }

    private static void setHandgunArmPoses(RenderLivingEvent.Pre event, PlayerEntity player, boolean handgunInOff, boolean handgunInMain) {
        BipedModel model = (BipedModel)event.getRenderer().func_217764_d();
        if (ClientEventHandler.isHandgunActive(player, handgunInMain, handgunInOff)) {
            Hand hand = ClientEventHandler.getActiveHandgunHand(player, handgunInMain, handgunInOff);
            HandSide primaryHand = player.func_184591_cq();
            if ((hand == Hand.MAIN_HAND && primaryHand == HandSide.RIGHT || hand == Hand.OFF_HAND && primaryHand == HandSide.LEFT) && model.field_187076_m != BipedModel.ArmPose.BOW_AND_ARROW) {
                model.field_187076_m = BipedModel.ArmPose.BOW_AND_ARROW;
            } else if ((hand == Hand.OFF_HAND && primaryHand == HandSide.RIGHT || hand == Hand.MAIN_HAND && primaryHand == HandSide.LEFT) && model.field_187075_l != BipedModel.ArmPose.BOW_AND_ARROW) {
                model.field_187075_l = BipedModel.ArmPose.BOW_AND_ARROW;
            }
        } else {
            if (model.field_187076_m == BipedModel.ArmPose.BOW_AND_ARROW) {
                model.field_187076_m = BipedModel.ArmPose.ITEM;
            }
            if (model.field_187075_l == BipedModel.ArmPose.BOW_AND_ARROW) {
                model.field_187075_l = BipedModel.ArmPose.ITEM;
            }
        }
    }

    private static Hand getActiveHandgunHand(PlayerEntity player, boolean handgunInMain, boolean handgunInOff) {
        boolean offValid;
        if (handgunInMain != handgunInOff) {
            return handgunInMain ? Hand.MAIN_HAND : Hand.OFF_HAND;
        }
        boolean mainValid = ClientEventHandler.isValidTimeFrame(player.field_70170_p, player.func_184614_ca());
        if (mainValid != (offValid = ClientEventHandler.isValidTimeFrame(player.field_70170_p, player.func_184592_cb()))) {
            return mainValid ? Hand.MAIN_HAND : Hand.OFF_HAND;
        }
        return ModItems.HANDGUN.getCooldown(player.func_184614_ca()) < ModItems.HANDGUN.getCooldown(player.func_184592_cb()) ? Hand.MAIN_HAND : Hand.OFF_HAND;
    }

    private static boolean isHandgunActive(PlayerEntity player, boolean handgunInMain, boolean handgunInOff) {
        return handgunInMain && ClientEventHandler.isValidTimeFrame(player.field_70170_p, player.func_184614_ca()) || handgunInOff && ClientEventHandler.isValidTimeFrame(player.field_70170_p, player.func_184592_cb());
    }

    private static boolean isValidTimeFrame(World world, ItemStack handgun) {
        long cooldownTime = ModItems.HANDGUN.getCooldown(handgun) + 5L;
        return cooldownTime - world.func_82737_E() <= (long)ModItems.HANDGUN.func_77626_a(handgun) && cooldownTime >= world.func_82737_E();
    }

    @SubscribeEvent
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r != null || !Minecraft.func_71382_s() || !mc.func_195544_aj() || mc.field_71439_g == null) {
            return;
        }
        if (hudComponents.isEmpty()) {
            ClientEventHandler.initHUDComponents();
        }
        ClientEventHandler.renderHUDComponents();
    }

    @SubscribeEvent
    public static void onMouseLeftClick(InputEvent.MouseInputEvent evt) {
        Minecraft mc = Minecraft.func_71410_x();
        if (evt.getButton() != 0 || evt.getAction() != 1 || mc.field_71462_r != null) {
            return;
        }
        ClientPlayerEntity player = mc.field_71439_g;
        if (player == null) {
            return;
        }
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() instanceof ILeftClickableItem && ((ILeftClickableItem)stack.func_77973_b()).onLeftClickItem(stack, (LivingEntity)player) == ActionResultType.PASS) {
            PacketHandler.sendToServer(new LeftClickedItemPacket());
        }
    }

    private static void renderHUDComponents() {
        for (Tuple<Component, HUDPosition> component : hudComponents) {
            HUDRenderrer.render((Component)component.func_76341_a(), (HUDPosition)((Object)component.func_76340_b()));
        }
    }

    private static void initHUDComponents() {
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new ChargeableItemInfoPane((Item)ModItems.ALKAHESTRY_TOME, (HUDPosition)((Object)Settings.CLIENT.hudPositions.alkahestryTome.get()), new ItemStack((IItemProvider)Items.field_151137_ax), is -> NBTHelper.getInt("charge", is)), Settings.CLIENT.hudPositions.alkahestryTome.get()));
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new ChargeableItemInfoPane((Item)ModItems.DESTRUCTION_CATALYST, (HUDPosition)((Object)Settings.CLIENT.hudPositions.destructionCatalyst.get()), new ItemStack((IItemProvider)Items.field_151016_H), is -> NBTHelper.getInt("gunpowder", is)), Settings.CLIENT.hudPositions.destructionCatalyst.get()));
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new ChargeableItemInfoPane((Item)ModItems.MIDAS_TOUCHSTONE, (HUDPosition)((Object)Settings.CLIENT.hudPositions.midasTouchstone.get()), new ItemStack((IItemProvider)Items.field_151114_aO), is -> NBTHelper.getInt("glowstone", is)), Settings.CLIENT.hudPositions.midasTouchstone.get()));
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new ChargeableItemInfoPane(ModItems.INFERNAL_CHALICE, (HUDPosition)((Object)Settings.CLIENT.hudPositions.infernalChalice.get()), new ItemStack((IItemProvider)Items.field_151129_at), is -> NBTHelper.getInt("fluidStacks", is) / 1000, Colors.get("CC3024")), Settings.CLIENT.hudPositions.infernalChalice.get()));
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new ChargeableItemInfoPane((Item)ModItems.ICE_MAGUS_ROD, (HUDPosition)((Object)Settings.CLIENT.hudPositions.iceMagusRod.get()), new ItemStack((IItemProvider)Items.field_151126_ay), is -> NBTHelper.getInt("snowballs", is)), Settings.CLIENT.hudPositions.iceMagusRod.get()));
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new ChargeableItemInfoPane((Item)ModItems.GLACIAL_STAFF, (HUDPosition)((Object)Settings.CLIENT.hudPositions.glacialStaff.get()), new ItemStack((IItemProvider)Items.field_151126_ay), is -> NBTHelper.getInt("snowballs", is)), Settings.CLIENT.hudPositions.glacialStaff.get()));
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new ChargeableItemInfoPane((Item)ModItems.ENDER_STAFF, (HUDPosition)((Object)Settings.CLIENT.hudPositions.enderStaff.get()), ModItems.ENDER_STAFF::getMode, (Map<String, Component>)ImmutableMap.of((Object)"cast", (Object)new ChargePane(ModItems.ENDER_STAFF, new ItemStack((IItemProvider)Items.field_151079_bi), is -> ModItems.ENDER_STAFF.getPearlCount((ItemStack)is, true)), (Object)"node_warp", (Object)new ChargePane(ModItems.ENDER_STAFF, new ItemStack((IItemProvider)ModBlocks.WRAITH_NODE), is -> ModItems.ENDER_STAFF.getPearlCount((ItemStack)is, true)), (Object)"long_cast", (Object)new ChargePane(ModItems.ENDER_STAFF, new ItemStack((IItemProvider)Items.field_151061_bv), is -> ModItems.ENDER_STAFF.getPearlCount((ItemStack)is, true)))), Settings.CLIENT.hudPositions.enderStaff.get()));
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new ChargeableItemInfoPane((Item)ModItems.PYROMANCER_STAFF, (HUDPosition)((Object)Settings.CLIENT.hudPositions.pyromancerStaff.get()), ModItems.PYROMANCER_STAFF::getMode, (Map<String, Component>)ImmutableMap.of((Object)"blaze", (Object)new ChargePane(ModItems.PYROMANCER_STAFF, new ItemStack((IItemProvider)Items.field_151065_br), is -> ModItems.PYROMANCER_STAFF.getInternalStorageItemCount((ItemStack)is, Items.field_151065_br)), (Object)"charge", (Object)new ChargePane(ModItems.PYROMANCER_STAFF, new ItemStack((IItemProvider)Items.field_151059_bz), is -> ModItems.PYROMANCER_STAFF.getInternalStorageItemCount((ItemStack)is, Items.field_151059_bz)), (Object)"eruption", (Object)Box.createVertical(Box.Alignment.RIGHT, new TextPane("ERUPT"), new ChargePane(ModItems.PYROMANCER_STAFF, new ItemStack((IItemProvider)Items.field_151065_br), is -> ModItems.PYROMANCER_STAFF.getInternalStorageItemCount((ItemStack)is, Items.field_151065_br))), (Object)"flint_and_steel", (Object)new ItemStackPane(Items.field_151033_d))), Settings.CLIENT.hudPositions.pyromancerStaff.get()));
        ChargePane rendingGaleFeatherPane = new ChargePane(ModItems.RENDING_GALE, new ItemStack((IItemProvider)Items.field_151008_G), is -> ModItems.RENDING_GALE.getFeatherCountClient((ItemStack)is, (PlayerEntity)Minecraft.func_71410_x().field_71439_g) / 100);
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new ChargeableItemInfoPane((Item)ModItems.RENDING_GALE, (HUDPosition)((Object)Settings.CLIENT.hudPositions.rendingGale.get()), ModItems.RENDING_GALE::getMode, (Map<String, Component>)ImmutableMap.of((Object)"push", (Object)Box.createVertical(Box.Alignment.RIGHT, new TextPane("PUSH"), rendingGaleFeatherPane), (Object)"pull", (Object)Box.createVertical(Box.Alignment.RIGHT, new TextPane("PULL"), rendingGaleFeatherPane), (Object)"bolt", (Object)Box.createVertical(Box.Alignment.RIGHT, new TextPane("BOLT"), rendingGaleFeatherPane), (Object)"flight", (Object)Box.createVertical(Box.Alignment.RIGHT, new TextPane("FLIGHT"), rendingGaleFeatherPane))), Settings.CLIENT.hudPositions.rendingGale.get()));
        DynamicChargePane contentsPane = new DynamicChargePane(ModItems.VOID_TEAR, is -> ModItems.VOID_TEAR.getContainerItem((ItemStack)is, true), is -> ModItems.VOID_TEAR.getContainerItem((ItemStack)is, true).func_190916_E());
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new ChargeableItemInfoPane((Item)ModItems.VOID_TEAR, (HUDPosition)((Object)Settings.CLIENT.hudPositions.voidTear.get()), is -> ModItems.VOID_TEAR.getMode((ItemStack)is).func_176610_l(), (Map)ImmutableMap.of((Object)VoidTearItem.Mode.FULL_INVENTORY.func_176610_l(), (Object)Box.createVertical(Box.Alignment.RIGHT, new TextPane(LanguageHelper.getLocalization(VOID_TEAR_MODE_TRANSLATION + VoidTearItem.Mode.FULL_INVENTORY.func_176610_l().toLowerCase(), new Object[0])), contentsPane), (Object)VoidTearItem.Mode.NO_REFILL.func_176610_l(), (Object)Box.createVertical(Box.Alignment.RIGHT, new TextPane(LanguageHelper.getLocalization(VOID_TEAR_MODE_TRANSLATION + VoidTearItem.Mode.NO_REFILL.func_176610_l().toLowerCase(), new Object[0])), contentsPane), (Object)VoidTearItem.Mode.ONE_STACK.func_176610_l(), (Object)Box.createVertical(Box.Alignment.RIGHT, new TextPane(LanguageHelper.getLocalization(VOID_TEAR_MODE_TRANSLATION + VoidTearItem.Mode.ONE_STACK.func_176610_l().toLowerCase(), new Object[0])), contentsPane))){

            @Override
            public boolean shouldRender() {
                return !ModItems.VOID_TEAR.isEmpty(InventoryHelper.getCorrectItemFromEitherHand((PlayerEntity)Minecraft.func_71410_x().field_71439_g, ModItems.VOID_TEAR), true);
            }
        }, Settings.CLIENT.hudPositions.voidTear.get()));
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new ChargeableItemInfoPane((Item)ModItems.HARVEST_ROD, (HUDPosition)((Object)Settings.CLIENT.hudPositions.harvestRod.get()), ModItems.HARVEST_ROD::getMode, (Map<String, Component>)ImmutableMap.of((Object)"bone_meal", (Object)new ChargePane(ModItems.HARVEST_ROD, new ItemStack((IItemProvider)Items.field_196106_bc), is -> ModItems.HARVEST_ROD.getBoneMealCount((ItemStack)is, true)), (Object)"hoe", (Object)new ItemStackPane(Items.field_151017_I), (Object)"dynamic", (Object)new DynamicChargePane(ModItems.HARVEST_ROD, is -> ModItems.HARVEST_ROD.getCurrentPlantable((ItemStack)is, true), is -> ModItems.HARVEST_ROD.getPlantableQuantity((ItemStack)is, ModItems.HARVEST_ROD.getCurrentPlantableSlot((ItemStack)is), true)))), Settings.CLIENT.hudPositions.harvestRod.get()));
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new ChargeableItemInfoPane((Item)ModItems.SOJOURNER_STAFF, (HUDPosition)((Object)Settings.CLIENT.hudPositions.sojournerStaff.get()), is -> "dynamic", (Map<String, Component>)ImmutableMap.of((Object)"dynamic", (Object)new DynamicChargePane(ModItems.SOJOURNER_STAFF, ModItems.SOJOURNER_STAFF::getCurrentTorch, ModItems.SOJOURNER_STAFF::getTorchCount))), Settings.CLIENT.hudPositions.sojournerStaff.get()));
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new HeroMedallionPane(), Settings.CLIENT.hudPositions.heroMedallion.get()));
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)Box.createVertical(Box.Alignment.RIGHT, new HandgunPane(Hand.OFF_HAND), new HandgunPane(Hand.MAIN_HAND)), Settings.CLIENT.hudPositions.handgun.get()));
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new CharmPane(), Settings.CLIENT.hudPositions.mobCharm.get()));
    }
}

