/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.inventory;

import info.u_team.useful_railroads.recipe.FuelRecipe;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.IntConsumer;
import java.util.function.Supplier;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandlerModifiable;

public class FuelItemHandler<T extends FuelRecipe>
implements IItemHandlerModifiable {
    private final IRecipeType<T> recipeType;
    private final Supplier<World> worldSupplier;
    private final BooleanSupplier canAddFuel;
    private final IntConsumer fuelAdder;
    private T currentRecipe;
    private ItemStack failedMatch = ItemStack.field_190927_a;

    public FuelItemHandler(IRecipeType<T> recipeType, Supplier<World> worldSupplier, IntConsumer fuelAdder) {
        this(recipeType, worldSupplier, () -> true, fuelAdder);
    }

    public FuelItemHandler(IRecipeType<T> recipeType, Supplier<World> worldSupplier, BooleanSupplier canAddFuel, IntConsumer fuelAdder) {
        this.recipeType = recipeType;
        this.worldSupplier = worldSupplier;
        this.canAddFuel = canAddFuel;
        this.fuelAdder = fuelAdder;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.canAddFuel.getAsBoolean() && this.getRecipe(stack, this.worldSupplier.get()).isPresent();
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        if (!simulate) {
            this.setStackInSlot(slot, stack);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getStackInSlot(int slot) {
        return ItemStack.field_190927_a;
    }

    public int getSlots() {
        return 1;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.field_190927_a;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        World world = this.worldSupplier.get();
        if (!world.field_72995_K) {
            this.getRecipe(stack, world).ifPresent(recipe -> this.fuelAdder.accept(stack.func_190916_E() * recipe.getFuel()));
        }
    }

    private Optional<T> getRecipe(ItemStack stack, World world) {
        Inventory inventory = new Inventory(new ItemStack[]{stack});
        if (stack.func_190926_b() || stack == this.failedMatch) {
            return Optional.empty();
        }
        if (this.currentRecipe != null && ((FuelRecipe)this.currentRecipe).func_77569_a((IInventory)inventory, world)) {
            return Optional.of(this.currentRecipe);
        }
        FuelRecipe recipe = world.func_199532_z().func_215371_a(this.recipeType, (IInventory)inventory, world).orElse(null);
        this.failedMatch = recipe == null ? stack : ItemStack.field_190927_a;
        this.currentRecipe = recipe;
        return Optional.ofNullable(this.currentRecipe);
    }
}

