/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpoles.init;

import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.units.RelatedUnitsInit;
import com.endertech.minecraft.mods.adpoles.blocks.Pole;
import com.endertech.minecraft.mods.adpoles.blocks.PoweredPole;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.EndRodBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.PaneBlock;
import net.minecraft.block.material.Material;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;

public class Poles
extends RelatedUnitsInit<Pole, BuildIn> {
    public Poles(ForgeMod mod) {
        super(mod, BuildIn.class);
    }

    public Pole createDefaultUnitFrom(UnitConfig config, BuildIn e) {
        switch (e) {
            case REDSTONE: {
                e.pole = new PoweredPole(this.getMod(), config, e.props);
                break;
            }
            default: {
                e.pole = new Pole(this.getMod(), config, e.props);
            }
        }
        return e.pole;
    }

    public Pole createCustomUnitFrom(UnitConfig config, String name) {
        return new Pole(this.getMod(), config, (Pole.Properties<?>)((Object)((Pole.Properties)Pole.Properties.withId("").name(name)).speedFactor(0.5f)));
    }

    public Pole findBy(BlockState state) {
        Block block = state.func_177230_c();
        if (block instanceof Pole) {
            return (Pole)block;
        }
        if (!(!(block instanceof FenceBlock) || ((Boolean)state.func_177229_b((IProperty)FenceBlock.field_196409_a)).booleanValue() || ((Boolean)state.func_177229_b((IProperty)FenceBlock.field_196411_b)).booleanValue() || ((Boolean)state.func_177229_b((IProperty)FenceBlock.field_196413_c)).booleanValue() || ((Boolean)state.func_177229_b((IProperty)FenceBlock.field_196414_y)).booleanValue())) {
            return BuildIn.WOODEN.pole;
        }
        if (!(!(block instanceof PaneBlock) || ((Boolean)state.func_177229_b((IProperty)PaneBlock.field_196409_a)).booleanValue() || ((Boolean)state.func_177229_b((IProperty)PaneBlock.field_196411_b)).booleanValue() || ((Boolean)state.func_177229_b((IProperty)PaneBlock.field_196413_c)).booleanValue() || ((Boolean)state.func_177229_b((IProperty)PaneBlock.field_196414_y)).booleanValue())) {
            if (state.func_185904_a() == Material.field_151573_f) {
                return BuildIn.IRON.pole;
            }
            if (state.func_185904_a() == Material.field_151592_s) {
                return BuildIn.GLASS.pole;
            }
        }
        if (block instanceof EndRodBlock && ((Direction)state.func_177229_b((IProperty)EndRodBlock.field_176387_N)).func_176740_k().func_200128_b()) {
            return BuildIn.TELE.pole;
        }
        return null;
    }

    @Nullable
    public Pole findBy(IWorldReader world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof FenceBlock || block instanceof PaneBlock || block instanceof EndRodBlock) {
            state = block.getExtendedState(state, (IBlockReader)world, pos);
        }
        return this.findBy(state);
    }

    public static enum BuildIn implements IForgeEnum
    {
        WOODEN("@log", 0.2f, false),
        IRON("iron_block", 0.4f, true),
        GLASS("glass", 0.5f, false),
        REDSTONE("redstone_block", 0.5f, true),
        GOLDEN("gold_block", 0.6f, true),
        TELE("end_rod", 0.7f, false),
        DIAMOND("diamond_block", 0.8f, true),
        OBSIDIAN("obsidian", 0.9f, true);

        public final boolean register;
        private Pole pole;
        private final Pole.Properties<?> props;

        private BuildIn(String relatedBlockId, float speedFactor, boolean register) {
            this.props = (Pole.Properties)((Pole.Properties)Pole.Properties.withId(relatedBlockId).name(this.func_176610_l())).speedFactor(speedFactor).propsFromRelatedBlock();
            this.register = register;
        }

        public Pole getPole() {
            return this.pole;
        }
    }
}

