/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.block;

import codechicken.enderstorage.block.BlockEnderStorage;
import codechicken.enderstorage.misc.EnderKnobSlot;
import codechicken.enderstorage.tile.TileEnderChest;
import codechicken.enderstorage.tile.TileFrequencyOwner;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.raytracer.SubHitVoxelShape;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;

public class BlockEnderChest
extends BlockEnderStorage {
    private static final IndexedCuboid6 CHEST = new IndexedCuboid6((Object)0, new Cuboid6(0.0625, 0.0, 0.0625, 0.9375, 0.875, 0.9375));
    private static final IndexedCuboid6[][] BUTTONS = new IndexedCuboid6[4][3];
    private static final IndexedCuboid6[] LATCH = new IndexedCuboid6[4];
    private static final VoxelShape CHEST_SHAPE = VoxelShapes.func_197881_a((AxisAlignedBB)CHEST.aabb());
    private static final VoxelShape[][] SHAPES = new VoxelShape[4][2];
    public static final Transformation[] buttonT = new Transformation[3];

    public BlockEnderChest(Block.Properties properties) {
        super(properties);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        VoxelShape shape = CHEST_SHAPE;
        TileEntity t = worldIn.func_175625_s(pos);
        if (t instanceof TileEnderChest) {
            TileEnderChest tile = (TileEnderChest)t;
            shape = SHAPES[tile.rotation][tile.getRadianLidAngle(0.0f) >= 0.0 ? 0 : 1];
        }
        return shape;
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEnderChest();
    }

    static {
        for (int button = 0; button < 3; ++button) {
            BlockEnderChest.buttonT[button] = new Translation(-0.1875 + 0.1875 * (double)button, 0.875, 0.0);
        }
        for (int rot = 0; rot < 4; ++rot) {
            for (int button = 0; button < 3; ++button) {
                Cuboid6 cuboid = TileFrequencyOwner.selection_button.copy();
                cuboid.apply((Transformation)new Translation(0.5, 0.0, 0.5));
                cuboid.apply(buttonT[button]);
                cuboid.apply(new Rotation((double)(-90 * rot) * 0.017453292519943, Vector3.Y_POS).at(new Vector3(0.5, 0.0, 0.5)));
                BlockEnderChest.BUTTONS[rot][button] = new IndexedCuboid6((Object)(button + 1), cuboid);
            }
            BlockEnderChest.LATCH[rot] = new IndexedCuboid6((Object)4, new Cuboid6(new EnderKnobSlot(rot).getSelectionBB()));
            for (int state = 0; state < 2; ++state) {
                ArrayList<IndexedCuboid6> cuboids = new ArrayList<IndexedCuboid6>();
                cuboids.add(CHEST);
                if (state == 0) {
                    Collections.addAll(cuboids, BUTTONS[rot]);
                    cuboids.add(LATCH[rot]);
                }
                BlockEnderChest.SHAPES[rot][state] = new SubHitVoxelShape(CHEST_SHAPE, cuboids);
            }
        }
    }
}

