/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.particles;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.particles.ParticleMagic;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.ParticleStatus;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class ParticleHandler {
    private static final List<Particle> PARTICLES = new ArrayList<Particle>();
    private static final List<Particle> PARTICLES_NO_DEPTH = new ArrayList<Particle>();
    public static boolean depthEnabled = true;
    public static int range = 32;
    public static boolean culling = true;

    public static void spawnParticle(Supplier<Particle> particle, double x, double y, double z) {
        if (Minecraft.func_71410_x().field_71439_g.func_70092_e(x, y, z) <= (double)(range * range)) {
            if (culling) {
                ParticleStatus setting;
                Minecraft mc = Minecraft.func_71410_x();
                if (!(!((Boolean)ModConfig.instance.respectVanillaParticleSettings.get()).booleanValue() || (setting = mc.field_71474_y.field_74362_aa) == ParticleStatus.ALL || setting == ParticleStatus.DECREASED && mc.field_71441_e.field_73012_v.nextInt(3) == 0 || setting == ParticleStatus.MINIMAL && mc.field_71441_e.field_73012_v.nextInt(10) == 0)) {
                    return;
                }
                double setting2 = (Double)ModConfig.instance.particleAmount.get();
                if (setting2 < 1.0 && mc.field_71441_e.field_73012_v.nextDouble() > setting2) {
                    return;
                }
            }
            if (depthEnabled) {
                PARTICLES.add(particle.get());
            } else {
                PARTICLES_NO_DEPTH.add(particle.get());
            }
        }
    }

    public static void updateParticles() {
        ParticleHandler.updateList(PARTICLES);
        ParticleHandler.updateList(PARTICLES_NO_DEPTH);
        depthEnabled = true;
        range = 32;
        culling = true;
    }

    private static void updateList(List<Particle> particles) {
        for (int i = particles.size() - 1; i >= 0; --i) {
            Particle particle = particles.get(i);
            particle.func_189213_a();
            if (particle.func_187113_k()) continue;
            particles.remove(i);
        }
    }

    public static void renderParticles(MatrixStack stack, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (player != null) {
            ActiveRenderInfo info = mc.field_71460_t.func_215316_n();
            LightTexture lightmap = mc.field_71460_t.func_228384_l_();
            RenderSystem.pushMatrix();
            RenderSystem.multMatrix((Matrix4f)stack.func_227866_c_().func_227870_a_());
            lightmap.func_205109_c();
            RenderSystem.enableAlphaTest();
            RenderSystem.enableBlend();
            RenderSystem.alphaFunc((int)516, (float)0.003921569f);
            RenderSystem.disableCull();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.enableFog();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.depthMask((boolean)false);
            mc.func_110434_K().func_110577_a(ParticleMagic.TEXTURE);
            Tessellator tessy = Tessellator.func_178181_a();
            BufferBuilder buffer = tessy.func_178180_c();
            RenderSystem.enableDepthTest();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
            for (Particle particle : PARTICLES) {
                particle.func_225606_a_((IVertexBuilder)buffer, info, partialTicks);
            }
            tessy.func_78381_a();
            RenderSystem.disableDepthTest();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
            for (Particle particle : PARTICLES_NO_DEPTH) {
                particle.func_225606_a_((IVertexBuilder)buffer, info, partialTicks);
            }
            tessy.func_78381_a();
            RenderSystem.enableDepthTest();
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.disableBlend();
            RenderSystem.alphaFunc((int)516, (float)0.1f);
            RenderSystem.disableFog();
            lightmap.func_205108_b();
            RenderSystem.popMatrix();
        }
    }

    public static int getParticleAmount(boolean depth) {
        return depth ? PARTICLES.size() : PARTICLES_NO_DEPTH.size();
    }

    public static void clearParticles() {
        if (!PARTICLES.isEmpty()) {
            PARTICLES.clear();
        }
        if (!PARTICLES_NO_DEPTH.isEmpty()) {
            PARTICLES_NO_DEPTH.clear();
        }
    }
}

